<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Bridge\Doctrine\Tests\Fixtures;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class AssociationEntity2
{
    #[ORM\Id, ORM\GeneratedValue, ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne]
    public ?SingleIntIdNoToStringEntity $single = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(name: 'composite_id1', referencedColumnName: 'id1')]
    #[ORM\JoinColumn(name: 'composite_id2', referencedColumnName: 'id2')]
    public ?CompositeIntIdEntity $composite = null;
}
