/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.map;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.turbine.util.db.IdGenerator;
import org.apache.turbine.util.db.map.ColumnMap;
import org.apache.turbine.util.db.map.DatabaseMap;

public class TableMap {
    public static final String AUTOINCREMENT = "autoincrement";
    public static final String SEQUENCE = "sequence";
    public static final String IDBROKERTABLE = "idbroker_table";
    public static final String NONE = "none";
    private Hashtable columns;
    private DatabaseMap dbMap;
    private String tableName;
    private String prefix;
    private String primaryKeyMethod = "none";
    private IdGenerator idGenerator;
    private Object pkInfo = null;

    public boolean containsColumn(ColumnMap column) {
        return this.containsColumn(column.getColumnName());
    }

    public boolean containsColumn(String name) {
        if (name.indexOf(46) > 0) {
            name = name.substring(name.indexOf(46) + 1);
        }
        return this.columns.containsKey(name);
    }

    public DatabaseMap getDatabaseMap() {
        return this.dbMap;
    }

    public boolean containsObjectColumn() {
        Enumeration e = this.columns.elements();
        while (e.hasMoreElements()) {
            Object theType = ((ColumnMap)e.nextElement()).getType();
            if (theType instanceof String || theType instanceof Number || theType instanceof Date) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.tableName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrimaryKeyMethod() {
        return this.primaryKeyMethod;
    }

    public IdGenerator getIdGenerator() {
        return this.getDatabaseMap().getIdGenerator(this.primaryKeyMethod);
    }

    public Object getPrimaryKeyMethodInfo() {
        return this.pkInfo;
    }

    public Object getSequenceInfo() {
        return this.getPrimaryKeyMethodInfo();
    }

    public ColumnMap[] getColumns() {
        ColumnMap[] tableColumns = new ColumnMap[this.columns.size()];
        Enumeration e = this.columns.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            tableColumns[i++] = (ColumnMap)e.nextElement();
        }
        return tableColumns;
    }

    public ColumnMap getColumn(String name) {
        try {
            return (ColumnMap)this.columns.get(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addColumn(ColumnMap cmap) {
        this.columns.put(cmap.getColumnName(), cmap);
    }

    public void addColumn(String columnName, Object type) {
        this.addColumn(columnName, type, false, null, null, 0);
    }

    public void addColumn(String columnName, Object type, int size) {
        this.addColumn(columnName, type, false, null, null, size);
    }

    public void addPrimaryKey(String columnName, Object type) {
        this.addColumn(columnName, type, true, null, null, 0);
    }

    public void addPrimaryKey(String columnName, Object type, int size) {
        this.addColumn(columnName, type, true, null, null, size);
    }

    public void addForeignKey(String columnName, Object type, String fkTable, String fkColumn) {
        this.addColumn(columnName, type, false, fkTable, fkColumn, 0);
    }

    public void addForeignKey(String columnName, Object type, String fkTable, String fkColumn, int size) {
        this.addColumn(columnName, type, false, fkTable, fkColumn, size);
    }

    public void addForeignPrimaryKey(String columnName, Object type, String fkTable, String fkColumn) {
        this.addColumn(columnName, type, true, fkTable, fkColumn, 0);
    }

    public void addForeignPrimaryKey(String columnName, Object type, String fkTable, String fkColumn, int size) {
        this.addColumn(columnName, type, true, fkTable, fkColumn, size);
    }

    private void addColumn(String name, Object type, boolean pk, String fkTable, String fkColumn, int size) {
        if (name.indexOf(46) > 0 && name.indexOf(this.getName()) != -1) {
            name = name.substring(this.getName().length() + 1);
        }
        if (fkTable != null && fkTable.length() > 0 && fkColumn != null && fkColumn.length() > 0 && fkColumn.indexOf(46) > 0 && fkColumn.indexOf(fkTable) != -1) {
            fkColumn = fkColumn.substring(fkTable.length() + 1);
        }
        ColumnMap col = new ColumnMap(name, this);
        col.setType(type);
        col.setPrimaryKey(pk);
        col.setForeignKey(fkTable, fkColumn);
        col.setSize(size);
        this.columns.put(name, col);
    }

    public void setPrimaryKeyMethod(String method) {
        this.primaryKeyMethod = method;
    }

    public void setSequenceInfo(Object pkInfo) {
        this.setPrimaryKeyMethodInfo(pkInfo);
    }

    public void setPrimaryKeyMethodInfo(Object pkInfo) {
        this.pkInfo = pkInfo;
    }

    private final boolean hasPrefix(String data) {
        return data.indexOf(this.getPrefix()) != -1;
    }

    private final String removePrefix(String data) {
        return data.substring(this.getPrefix().length());
    }

    public final String removeUnderScores(String data) {
        String tmp = null;
        StringBuffer out = new StringBuffer();
        tmp = this.hasPrefix(data) ? this.removePrefix(data) : data;
        StringTokenizer st = new StringTokenizer(tmp, "_");
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(this.firstLetterCaps(element));
        }
        return out.toString();
    }

    private final String firstLetterCaps(String data) {
        String firstLetter = data.substring(0, 1).toUpperCase();
        String restLetters = data.substring(1).toLowerCase();
        return firstLetter + restLetters;
    }

    public TableMap(String tableName, int numberOfColumns, DatabaseMap containingDB) {
        this.tableName = tableName;
        this.dbMap = containingDB;
        this.columns = new Hashtable((int)(1.25 * (double)numberOfColumns) + 1);
    }

    public TableMap(String tableName, DatabaseMap containingDB) {
        this.tableName = tableName;
        this.dbMap = containingDB;
        this.columns = new Hashtable(20);
    }

    public TableMap(String tableName, String prefix, DatabaseMap containingDB) {
        this.tableName = tableName;
        this.prefix = prefix;
        this.dbMap = containingDB;
        this.columns = new Hashtable(20);
    }
}

