/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_ACCELERATION_STRUCTURE_H
#define VN_PROTOCOL_DRIVER_ACCELERATION_STRUCTURE_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkCopyAccelerationStructureToMemoryKHR
 *   vkCopyMemoryToAccelerationStructureKHR
 *   vkBuildAccelerationStructuresKHR
 */

/* struct VkAccelerationStructureVersionInfoKHR chain */

static inline size_t
vn_sizeof_VkAccelerationStructureVersionInfoKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAccelerationStructureVersionInfoKHR_self(const VkAccelerationStructureVersionInfoKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    if (val->pVersionData) {
        size += vn_sizeof_array_size(2*VK_UUID_SIZE);
        size += vn_sizeof_uint8_t_array(val->pVersionData, 2*VK_UUID_SIZE);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkAccelerationStructureVersionInfoKHR(const VkAccelerationStructureVersionInfoKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAccelerationStructureVersionInfoKHR_pnext(val->pNext);
    size += vn_sizeof_VkAccelerationStructureVersionInfoKHR_self(val);

    return size;
}

static inline void
vn_encode_VkAccelerationStructureVersionInfoKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAccelerationStructureVersionInfoKHR_self(struct vn_cs_encoder *enc, const VkAccelerationStructureVersionInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    if (val->pVersionData) {
        vn_encode_array_size(enc, 2*VK_UUID_SIZE);
        vn_encode_uint8_t_array(enc, val->pVersionData, 2*VK_UUID_SIZE);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkAccelerationStructureVersionInfoKHR(struct vn_cs_encoder *enc, const VkAccelerationStructureVersionInfoKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR });
    vn_encode_VkAccelerationStructureVersionInfoKHR_pnext(enc, val->pNext);
    vn_encode_VkAccelerationStructureVersionInfoKHR_self(enc, val);
}

/* struct VkAccelerationStructureCreateInfoKHR chain */

static inline size_t
vn_sizeof_VkAccelerationStructureCreateInfoKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAccelerationStructureCreateInfoKHR_self(const VkAccelerationStructureCreateInfoKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->createFlags);
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    size += vn_sizeof_VkAccelerationStructureTypeKHR(&val->type);
    size += vn_sizeof_VkDeviceAddress(&val->deviceAddress);
    return size;
}

static inline size_t
vn_sizeof_VkAccelerationStructureCreateInfoKHR(const VkAccelerationStructureCreateInfoKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAccelerationStructureCreateInfoKHR_pnext(val->pNext);
    size += vn_sizeof_VkAccelerationStructureCreateInfoKHR_self(val);

    return size;
}

static inline void
vn_encode_VkAccelerationStructureCreateInfoKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAccelerationStructureCreateInfoKHR_self(struct vn_cs_encoder *enc, const VkAccelerationStructureCreateInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->createFlags);
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkAccelerationStructureTypeKHR(enc, &val->type);
    vn_encode_VkDeviceAddress(enc, &val->deviceAddress);
}

static inline void
vn_encode_VkAccelerationStructureCreateInfoKHR(struct vn_cs_encoder *enc, const VkAccelerationStructureCreateInfoKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR });
    vn_encode_VkAccelerationStructureCreateInfoKHR_pnext(enc, val->pNext);
    vn_encode_VkAccelerationStructureCreateInfoKHR_self(enc, val);
}

/* struct VkAccelerationStructureDeviceAddressInfoKHR chain */

static inline size_t
vn_sizeof_VkAccelerationStructureDeviceAddressInfoKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAccelerationStructureDeviceAddressInfoKHR_self(const VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkAccelerationStructureKHR(&val->accelerationStructure);
    return size;
}

static inline size_t
vn_sizeof_VkAccelerationStructureDeviceAddressInfoKHR(const VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAccelerationStructureDeviceAddressInfoKHR_pnext(val->pNext);
    size += vn_sizeof_VkAccelerationStructureDeviceAddressInfoKHR_self(val);

    return size;
}

static inline void
vn_encode_VkAccelerationStructureDeviceAddressInfoKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAccelerationStructureDeviceAddressInfoKHR_self(struct vn_cs_encoder *enc, const VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkAccelerationStructureKHR(enc, &val->accelerationStructure);
}

static inline void
vn_encode_VkAccelerationStructureDeviceAddressInfoKHR(struct vn_cs_encoder *enc, const VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR });
    vn_encode_VkAccelerationStructureDeviceAddressInfoKHR_pnext(enc, val->pNext);
    vn_encode_VkAccelerationStructureDeviceAddressInfoKHR_self(enc, val);
}

/* struct VkAccelerationStructureBuildSizesInfoKHR chain */

static inline size_t
vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_self(const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->accelerationStructureSize);
    size += vn_sizeof_VkDeviceSize(&val->updateScratchSize);
    size += vn_sizeof_VkDeviceSize(&val->buildScratchSize);
    return size;
}

static inline size_t
vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR(const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_pnext(val->pNext);
    size += vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_self(val);

    return size;
}

static inline void
vn_decode_VkAccelerationStructureBuildSizesInfoKHR_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkAccelerationStructureBuildSizesInfoKHR_self(struct vn_cs_decoder *dec, VkAccelerationStructureBuildSizesInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->accelerationStructureSize);
    vn_decode_VkDeviceSize(dec, &val->updateScratchSize);
    vn_decode_VkDeviceSize(dec, &val->buildScratchSize);
}

static inline void
vn_decode_VkAccelerationStructureBuildSizesInfoKHR(struct vn_cs_decoder *dec, VkAccelerationStructureBuildSizesInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR);

    assert(val->sType == stype);
    vn_decode_VkAccelerationStructureBuildSizesInfoKHR_pnext(dec, val->pNext);
    vn_decode_VkAccelerationStructureBuildSizesInfoKHR_self(dec, val);
}

static inline size_t
vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_self_partial(const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->accelerationStructureSize */
    /* skip val->updateScratchSize */
    /* skip val->buildScratchSize */
    return size;
}

static inline size_t
vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_partial(const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_pnext_partial(val->pNext);
    size += vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_self_partial(val);

    return size;
}

static inline void
vn_encode_VkAccelerationStructureBuildSizesInfoKHR_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAccelerationStructureBuildSizesInfoKHR_self_partial(struct vn_cs_encoder *enc, const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->accelerationStructureSize */
    /* skip val->updateScratchSize */
    /* skip val->buildScratchSize */
}

static inline void
vn_encode_VkAccelerationStructureBuildSizesInfoKHR_partial(struct vn_cs_encoder *enc, const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR });
    vn_encode_VkAccelerationStructureBuildSizesInfoKHR_pnext_partial(enc, val->pNext);
    vn_encode_VkAccelerationStructureBuildSizesInfoKHR_self_partial(enc, val);
}

static inline size_t vn_sizeof_vkDestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyAccelerationStructureKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkAccelerationStructureKHR(&accelerationStructure);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyAccelerationStructureKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyAccelerationStructureKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkAccelerationStructureKHR(enc, &accelerationStructure);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyAccelerationStructureKHR_reply(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyAccelerationStructureKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip accelerationStructure */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyAccelerationStructureKHR_reply(struct vn_cs_decoder *dec, VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyAccelerationStructureKHR_EXT);

    /* skip device */
    /* skip accelerationStructure */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkCopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyAccelerationStructureKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkDeferredOperationKHR(&deferredOperation);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkCopyAccelerationStructureInfoKHR(pInfo);

    return cmd_size;
}

static inline void vn_encode_vkCopyAccelerationStructureKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyAccelerationStructureKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkDeferredOperationKHR(enc, &deferredOperation);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkCopyAccelerationStructureInfoKHR(enc, pInfo);
}

static inline size_t vn_sizeof_vkCopyAccelerationStructureKHR_reply(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyAccelerationStructureKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip deferredOperation */
    /* skip pInfo */

    return cmd_size;
}

static inline VkResult vn_decode_vkCopyAccelerationStructureKHR_reply(struct vn_cs_decoder *dec, VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCopyAccelerationStructureKHR_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip deferredOperation */
    /* skip pInfo */

    return ret;
}

static inline size_t vn_sizeof_vkWriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteAccelerationStructuresPropertiesKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&accelerationStructureCount);
    if (pAccelerationStructures) {
        cmd_size += vn_sizeof_array_size(accelerationStructureCount);
        for (uint32_t i = 0; i < accelerationStructureCount; i++)
            cmd_size += vn_sizeof_VkAccelerationStructureKHR(&pAccelerationStructures[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_VkQueryType(&queryType);
    cmd_size += vn_sizeof_size_t(&dataSize);
    cmd_size += vn_sizeof_simple_pointer(pData); /* out */
    cmd_size += vn_sizeof_size_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkWriteAccelerationStructuresPropertiesKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteAccelerationStructuresPropertiesKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &accelerationStructureCount);
    if (pAccelerationStructures) {
        vn_encode_array_size(enc, accelerationStructureCount);
        for (uint32_t i = 0; i < accelerationStructureCount; i++)
            vn_encode_VkAccelerationStructureKHR(enc, &pAccelerationStructures[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkQueryType(enc, &queryType);
    vn_encode_size_t(enc, &dataSize);
    vn_encode_array_size(enc, pData ? dataSize : 0); /* out */
    vn_encode_size_t(enc, &stride);
}

static inline size_t vn_sizeof_vkWriteAccelerationStructuresPropertiesKHR_reply(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteAccelerationStructuresPropertiesKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip accelerationStructureCount */
    /* skip pAccelerationStructures */
    /* skip queryType */
    /* skip dataSize */
    if (pData) {
        cmd_size += vn_sizeof_array_size(dataSize);
        cmd_size += vn_sizeof_blob_array(pData, dataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    /* skip stride */

    return cmd_size;
}

static inline VkResult vn_decode_vkWriteAccelerationStructuresPropertiesKHR_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkWriteAccelerationStructuresPropertiesKHR_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip accelerationStructureCount */
    /* skip pAccelerationStructures */
    /* skip queryType */
    /* skip dataSize */
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, dataSize);
        vn_decode_blob_array(dec, pData, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        pData = NULL;
    }
    /* skip stride */

    return ret;
}

static inline size_t vn_sizeof_vkGetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceAccelerationStructureCompatibilityKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pVersionInfo);
    if (pVersionInfo)
        cmd_size += vn_sizeof_VkAccelerationStructureVersionInfoKHR(pVersionInfo);
    cmd_size += vn_sizeof_simple_pointer(pCompatibility); /* out */

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceAccelerationStructureCompatibilityKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceAccelerationStructureCompatibilityKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pVersionInfo))
        vn_encode_VkAccelerationStructureVersionInfoKHR(enc, pVersionInfo);
    vn_encode_simple_pointer(enc, pCompatibility); /* out */
}

static inline size_t vn_sizeof_vkGetDeviceAccelerationStructureCompatibilityKHR_reply(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceAccelerationStructureCompatibilityKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pVersionInfo */
    cmd_size += vn_sizeof_simple_pointer(pCompatibility);
    if (pCompatibility)
        cmd_size += vn_sizeof_VkAccelerationStructureCompatibilityKHR(pCompatibility);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceAccelerationStructureCompatibilityKHR_reply(struct vn_cs_decoder *dec, VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceAccelerationStructureCompatibilityKHR_EXT);

    /* skip device */
    /* skip pVersionInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkAccelerationStructureCompatibilityKHR(dec, pCompatibility);
    } else {
        pCompatibility = NULL;
    }
}

static inline size_t vn_sizeof_vkCreateAccelerationStructureKHR(VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateAccelerationStructureKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkAccelerationStructureCreateInfoKHR(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pAccelerationStructure);
    if (pAccelerationStructure)
        cmd_size += vn_sizeof_VkAccelerationStructureKHR(pAccelerationStructure);

    return cmd_size;
}

static inline void vn_encode_vkCreateAccelerationStructureKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateAccelerationStructureKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkAccelerationStructureCreateInfoKHR(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pAccelerationStructure))
        vn_encode_VkAccelerationStructureKHR(enc, pAccelerationStructure);
}

static inline size_t vn_sizeof_vkCreateAccelerationStructureKHR_reply(VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateAccelerationStructureKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pAccelerationStructure);
    if (pAccelerationStructure)
        cmd_size += vn_sizeof_VkAccelerationStructureKHR(pAccelerationStructure);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateAccelerationStructureKHR_reply(struct vn_cs_decoder *dec, VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateAccelerationStructureKHR_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkAccelerationStructureKHR(dec, pAccelerationStructure);
    } else {
        pAccelerationStructure = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkGetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetAccelerationStructureDeviceAddressKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkAccelerationStructureDeviceAddressInfoKHR(pInfo);

    return cmd_size;
}

static inline void vn_encode_vkGetAccelerationStructureDeviceAddressKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetAccelerationStructureDeviceAddressKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkAccelerationStructureDeviceAddressInfoKHR(enc, pInfo);
}

static inline size_t vn_sizeof_vkGetAccelerationStructureDeviceAddressKHR_reply(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetAccelerationStructureDeviceAddressKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkDeviceAddress ret;
    cmd_size += vn_sizeof_VkDeviceAddress(&ret);
    /* skip device */
    /* skip pInfo */

    return cmd_size;
}

static inline VkDeviceAddress vn_decode_vkGetAccelerationStructureDeviceAddressKHR_reply(struct vn_cs_decoder *dec, VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetAccelerationStructureDeviceAddressKHR_EXT);

    VkDeviceAddress ret;
    vn_decode_VkDeviceAddress(dec, &ret);
    /* skip device */
    /* skip pInfo */

    return ret;
}

static inline size_t vn_sizeof_vkGetAccelerationStructureBuildSizesKHR(VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetAccelerationStructureBuildSizesKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkAccelerationStructureBuildTypeKHR(&buildType);
    cmd_size += vn_sizeof_simple_pointer(pBuildInfo);
    if (pBuildInfo)
        cmd_size += vn_sizeof_VkAccelerationStructureBuildGeometryInfoKHR(pBuildInfo);
    if (pMaxPrimitiveCounts) {
        cmd_size += vn_sizeof_array_size((pBuildInfo ? pBuildInfo->geometryCount : 0));
        cmd_size += vn_sizeof_uint32_t_array(pMaxPrimitiveCounts, (pBuildInfo ? pBuildInfo->geometryCount : 0));
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_simple_pointer(pSizeInfo);
    if (pSizeInfo)
        cmd_size += vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR_partial(pSizeInfo);

    return cmd_size;
}

static inline void vn_encode_vkGetAccelerationStructureBuildSizesKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetAccelerationStructureBuildSizesKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkAccelerationStructureBuildTypeKHR(enc, &buildType);
    if (vn_encode_simple_pointer(enc, pBuildInfo))
        vn_encode_VkAccelerationStructureBuildGeometryInfoKHR(enc, pBuildInfo);
    if (pMaxPrimitiveCounts) {
        vn_encode_array_size(enc, (pBuildInfo ? pBuildInfo->geometryCount : 0));
        vn_encode_uint32_t_array(enc, pMaxPrimitiveCounts, (pBuildInfo ? pBuildInfo->geometryCount : 0));
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, pSizeInfo))
        vn_encode_VkAccelerationStructureBuildSizesInfoKHR_partial(enc, pSizeInfo);
}

static inline size_t vn_sizeof_vkGetAccelerationStructureBuildSizesKHR_reply(VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetAccelerationStructureBuildSizesKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip buildType */
    /* skip pBuildInfo */
    /* skip pMaxPrimitiveCounts */
    cmd_size += vn_sizeof_simple_pointer(pSizeInfo);
    if (pSizeInfo)
        cmd_size += vn_sizeof_VkAccelerationStructureBuildSizesInfoKHR(pSizeInfo);

    return cmd_size;
}

static inline void vn_decode_vkGetAccelerationStructureBuildSizesKHR_reply(struct vn_cs_decoder *dec, VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetAccelerationStructureBuildSizesKHR_EXT);

    /* skip device */
    /* skip buildType */
    /* skip pBuildInfo */
    /* skip pMaxPrimitiveCounts */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkAccelerationStructureBuildSizesInfoKHR(dec, pSizeInfo);
    } else {
        pSizeInfo = NULL;
    }
}

static inline void vn_submit_vkDestroyAccelerationStructureKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyAccelerationStructureKHR(device, accelerationStructure, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyAccelerationStructureKHR_reply(device, accelerationStructure, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyAccelerationStructureKHR(enc, cmd_flags, device, accelerationStructure, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCopyAccelerationStructureKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCopyAccelerationStructureKHR(device, deferredOperation, pInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCopyAccelerationStructureKHR_reply(device, deferredOperation, pInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCopyAccelerationStructureKHR(enc, cmd_flags, device, deferredOperation, pInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkWriteAccelerationStructuresPropertiesKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkWriteAccelerationStructuresPropertiesKHR(device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkWriteAccelerationStructuresPropertiesKHR_reply(device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkWriteAccelerationStructuresPropertiesKHR(enc, cmd_flags, device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceAccelerationStructureCompatibilityKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceAccelerationStructureCompatibilityKHR(device, pVersionInfo, pCompatibility);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceAccelerationStructureCompatibilityKHR_reply(device, pVersionInfo, pCompatibility) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceAccelerationStructureCompatibilityKHR(enc, cmd_flags, device, pVersionInfo, pCompatibility);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCreateAccelerationStructureKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateAccelerationStructureKHR(device, pCreateInfo, pAllocator, pAccelerationStructure);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateAccelerationStructureKHR_reply(device, pCreateInfo, pAllocator, pAccelerationStructure) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateAccelerationStructureKHR(enc, cmd_flags, device, pCreateInfo, pAllocator, pAccelerationStructure);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetAccelerationStructureDeviceAddressKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetAccelerationStructureDeviceAddressKHR(device, pInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetAccelerationStructureDeviceAddressKHR_reply(device, pInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetAccelerationStructureDeviceAddressKHR(enc, cmd_flags, device, pInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetAccelerationStructureBuildSizesKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetAccelerationStructureBuildSizesKHR(device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetAccelerationStructureBuildSizesKHR_reply(device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetAccelerationStructureBuildSizesKHR(enc, cmd_flags, device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_async_vkDestroyAccelerationStructureKHR(struct vn_ring *vn_ring, VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyAccelerationStructureKHR(vn_ring, 0, device, accelerationStructure, pAllocator, &submit);
}

static inline VkResult vn_call_vkCopyAccelerationStructureKHR(struct vn_ring *vn_ring, VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCopyAccelerationStructureKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, deferredOperation, pInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCopyAccelerationStructureKHR_reply(dec, device, deferredOperation, pInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCopyAccelerationStructureKHR(struct vn_ring *vn_ring, VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCopyAccelerationStructureKHR(vn_ring, 0, device, deferredOperation, pInfo, &submit);
}

static inline VkResult vn_call_vkWriteAccelerationStructuresPropertiesKHR(struct vn_ring *vn_ring, VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkWriteAccelerationStructuresPropertiesKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkWriteAccelerationStructuresPropertiesKHR_reply(dec, device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkWriteAccelerationStructuresPropertiesKHR(struct vn_ring *vn_ring, VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, size_t dataSize, void* pData, size_t stride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkWriteAccelerationStructuresPropertiesKHR(vn_ring, 0, device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride, &submit);
}

static inline void vn_call_vkGetDeviceAccelerationStructureCompatibilityKHR(struct vn_ring *vn_ring, VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceAccelerationStructureCompatibilityKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pVersionInfo, pCompatibility, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetDeviceAccelerationStructureCompatibilityKHR_reply(dec, device, pVersionInfo, pCompatibility);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetDeviceAccelerationStructureCompatibilityKHR(struct vn_ring *vn_ring, VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceAccelerationStructureCompatibilityKHR(vn_ring, 0, device, pVersionInfo, pCompatibility, &submit);
}

static inline VkResult vn_call_vkCreateAccelerationStructureKHR(struct vn_ring *vn_ring, VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateAccelerationStructureKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pAccelerationStructure, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateAccelerationStructureKHR_reply(dec, device, pCreateInfo, pAllocator, pAccelerationStructure);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateAccelerationStructureKHR(struct vn_ring *vn_ring, VkDevice device, const VkAccelerationStructureCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureKHR* pAccelerationStructure)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateAccelerationStructureKHR(vn_ring, 0, device, pCreateInfo, pAllocator, pAccelerationStructure, &submit);
}

static inline VkDeviceAddress vn_call_vkGetAccelerationStructureDeviceAddressKHR(struct vn_ring *vn_ring, VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetAccelerationStructureDeviceAddressKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkDeviceAddress ret = vn_decode_vkGetAccelerationStructureDeviceAddressKHR_reply(dec, device, pInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetAccelerationStructureDeviceAddressKHR(struct vn_ring *vn_ring, VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetAccelerationStructureDeviceAddressKHR(vn_ring, 0, device, pInfo, &submit);
}

static inline void vn_call_vkGetAccelerationStructureBuildSizesKHR(struct vn_ring *vn_ring, VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetAccelerationStructureBuildSizesKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetAccelerationStructureBuildSizesKHR_reply(dec, device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetAccelerationStructureBuildSizesKHR(struct vn_ring *vn_ring, VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkAccelerationStructureBuildGeometryInfoKHR* pBuildInfo, const uint32_t* pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetAccelerationStructureBuildSizesKHR(vn_ring, 0, device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_ACCELERATION_STRUCTURE_H */
