# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
QEMU_SYSTEM_S390X ?= $(if $(value SNAP_INSTANCE_NAME),$$(test -z "$${SNAP_INSTANCE_NAME-}" && echo $(SNAP_INSTANCE_NAME).)qemu-system-s390x,$(or $(shell command -v qemu-system-s390x),$(warning program qemu-system-s390x is required)qemu-system-s390x))
QEMU_SYSTEM_S390X_MACHINE = s390-ccw-virtio
QEMU_CPU_S390X = qemu
QEMU_SMP_S390X = 1
QEMU_DEFAULT_NET_OPTION_S390X ?= \
	-netdev user,id=netdev0$(QEMU_DEFAULT_NETDEV_SYS_EXTRA)$${QEMU_NETDEV_USER_EXTRA:-} \
	-device virtio-net-pci,netdev=netdev0,id=net0
QEMU_SYSTEM_S390X_CMDLINE = \
	$(QEMU_ENV_QUIRKS) \
	exec $(QEMU_SYSTEM_S390X) \
	-cpu $(QEMU_CPU_S390X) \
	-machine $(QEMU_SYSTEM_S390X_MACHINE)$${QEMU_ACCEL_MACHINE_PROP=,accel=`$(QEMU_SYSTEM_S390X) -accel help | tail -n +2 | sort | paste -sd :`} \
	$${QEMU_MEM_OPTION=$(QEMU_DEFAULT_MEM_OPTION)} \
	$${QEMU_SMP_OPTION=-smp $(QEMU_SMP_S390X)} \
	$${QEMU_DISPLAY_OPTION=$(QEMU_DEFAULT_DISPLAY_OPTION)} \
	$${QEMU_STORAGE_OPTION=-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
		-device virtio-blk,drive=drive0,bootindex=0} \
	$${QEMU_RNG_OPTION=$(QEMU_DEFAULT_RNG_OPTION)} \
	$${QEMU_NET_OPTION=$(QEMU_DEFAULT_NET_OPTION_S390X)}

.PHONY: clean
clean::
	rm -f *.s390x.qcow2
