//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnewrelicobservability_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/newrelic/armnewrelicobservability"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListBySubscription_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NewRelicMonitorResourceListResult = armnewrelicobservability.NewRelicMonitorResourceListResult{
		// 	Value: []*armnewrelicobservability.NewRelicMonitorResource{
		// 		{
		// 			Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
		// 			Type: to.Ptr("hdj"),
		// 			ID: to.Ptr("ilrwkvbuwu"),
		// 			SystemData: &armnewrelicobservability.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
		// 				CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
		// 				CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
		// 				LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("k"),
		// 			Tags: map[string]*string{
		// 				"key6976": to.Ptr("oaxfhf"),
		// 			},
		// 			Identity: &armnewrelicobservability.ManagedServiceIdentity{
		// 				Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
		// 				PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 				TenantID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 				UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
		// 					"key8903": &armnewrelicobservability.UserAssignedIdentity{
		// 						ClientID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 						PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armnewrelicobservability.MonitorProperties{
		// 				AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
		// 				LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
		// 				LiftrResourcePreference: to.Ptr[int32](12),
		// 				MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
		// 				MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
		// 				MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
		// 				NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
		// 					AccountInfo: &armnewrelicobservability.AccountInfo{
		// 						AccountID: to.Ptr("xhqmg"),
		// 						Region: to.Ptr("ljcf"),
		// 					},
		// 					OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
		// 						OrganizationID: to.Ptr("k"),
		// 					},
		// 					SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
		// 						EnterpriseAppID: to.Ptr("kwiwfz"),
		// 						ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
		// 						SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
		// 						SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
		// 					},
		// 					UserID: to.Ptr("vcscxlncofcuduadesd"),
		// 				},
		// 				OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
		// 				PlanData: &armnewrelicobservability.PlanData{
		// 					BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
		// 					EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
		// 					PlanDetails: to.Ptr("tbbiaga"),
		// 					UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
		// 				},
		// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
		// 				UserInfo: &armnewrelicobservability.UserInfo{
		// 					Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
		// 					EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
		// 					FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
		// 					LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
		// 					PhoneNumber: to.Ptr("krf"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListByResourceGroup_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListByResourceGroupPager("rgNewRelic", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NewRelicMonitorResourceListResult = armnewrelicobservability.NewRelicMonitorResourceListResult{
		// 	Value: []*armnewrelicobservability.NewRelicMonitorResource{
		// 		{
		// 			Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
		// 			Type: to.Ptr("hdj"),
		// 			ID: to.Ptr("ilrwkvbuwu"),
		// 			SystemData: &armnewrelicobservability.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
		// 				CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
		// 				CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
		// 				LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("k"),
		// 			Tags: map[string]*string{
		// 				"key6976": to.Ptr("oaxfhf"),
		// 			},
		// 			Identity: &armnewrelicobservability.ManagedServiceIdentity{
		// 				Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
		// 				PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 				TenantID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 				UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
		// 					"key8903": &armnewrelicobservability.UserAssignedIdentity{
		// 						ClientID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 						PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armnewrelicobservability.MonitorProperties{
		// 				AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
		// 				LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
		// 				LiftrResourcePreference: to.Ptr[int32](12),
		// 				MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
		// 				MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
		// 				MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
		// 				NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
		// 					AccountInfo: &armnewrelicobservability.AccountInfo{
		// 						AccountID: to.Ptr("xhqmg"),
		// 						Region: to.Ptr("ljcf"),
		// 					},
		// 					OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
		// 						OrganizationID: to.Ptr("k"),
		// 					},
		// 					SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
		// 						EnterpriseAppID: to.Ptr("kwiwfz"),
		// 						ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
		// 						SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
		// 						SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
		// 					},
		// 					UserID: to.Ptr("vcscxlncofcuduadesd"),
		// 				},
		// 				OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
		// 				PlanData: &armnewrelicobservability.PlanData{
		// 					BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
		// 					EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
		// 					PlanDetails: to.Ptr("tbbiaga"),
		// 					UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
		// 				},
		// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
		// 				UserInfo: &armnewrelicobservability.UserInfo{
		// 					Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
		// 					EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
		// 					FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
		// 					LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
		// 					PhoneNumber: to.Ptr("krf"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_Get_MaximumSet_Gen.json
func ExampleMonitorsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().Get(ctx, "rgNewRelic", "cdlymktqw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NewRelicMonitorResource = armnewrelicobservability.NewRelicMonitorResource{
	// 	Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
	// 	Type: to.Ptr("hdj"),
	// 	ID: to.Ptr("ilrwkvbuwu"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("k"),
	// 	Tags: map[string]*string{
	// 		"key6976": to.Ptr("oaxfhf"),
	// 	},
	// 	Identity: &armnewrelicobservability.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
	// 		PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		TenantID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
	// 			"key8903": &armnewrelicobservability.UserAssignedIdentity{
	// 				ClientID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 				PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnewrelicobservability.MonitorProperties{
	// 		AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
	// 		LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
	// 		LiftrResourcePreference: to.Ptr[int32](12),
	// 		MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
	// 		MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
	// 		MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
	// 		NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
	// 			AccountInfo: &armnewrelicobservability.AccountInfo{
	// 				AccountID: to.Ptr("xhqmg"),
	// 				Region: to.Ptr("ljcf"),
	// 			},
	// 			OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
	// 				OrganizationID: to.Ptr("k"),
	// 			},
	// 			SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
	// 				EnterpriseAppID: to.Ptr("kwiwfz"),
	// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 				SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
	// 				SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
	// 			},
	// 			UserID: to.Ptr("vcscxlncofcuduadesd"),
	// 		},
	// 		OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
	// 		PlanData: &armnewrelicobservability.PlanData{
	// 			BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
	// 			EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
	// 			PlanDetails: to.Ptr("tbbiaga"),
	// 			UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 		UserInfo: &armnewrelicobservability.UserInfo{
	// 			Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
	// 			EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
	// 			FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
	// 			LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
	// 			PhoneNumber: to.Ptr("krf"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_CreateOrUpdate_MaximumSet_Gen.json
func ExampleMonitorsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginCreateOrUpdate(ctx, "rgNewRelic", "cdlymktqw", armnewrelicobservability.NewRelicMonitorResource{
		Location: to.Ptr("k"),
		Tags: map[string]*string{
			"key6976": to.Ptr("oaxfhf"),
		},
		Properties: &armnewrelicobservability.MonitorProperties{
			AccountCreationSource:         to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
			LiftrResourceCategory:         to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
			MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
			MonitoringStatus:              to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
			NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
				AccountInfo: &armnewrelicobservability.AccountInfo{
					AccountID:    to.Ptr("xhqmg"),
					IngestionKey: to.Ptr("wltnimmhqt"),
					Region:       to.Ptr("ljcf"),
				},
				OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
					OrganizationID: to.Ptr("k"),
				},
				SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
					EnterpriseAppID:   to.Ptr("kwiwfz"),
					ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateAccepted),
					SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
					SingleSignOnURL:   to.Ptr("kvseueuljsxmfwpqctz"),
				},
				UserID: to.Ptr("vcscxlncofcuduadesd"),
			},
			OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
			PlanData: &armnewrelicobservability.PlanData{
				BillingCycle:  to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t }()),
				PlanDetails:   to.Ptr("tbbiaga"),
				UsageType:     to.Ptr(armnewrelicobservability.UsageTypePAYG),
			},
			ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateAccepted),
			UserInfo: &armnewrelicobservability.UserInfo{
				Country:      to.Ptr("hslqnwdanrconqyekwbnttaetv"),
				EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
				FirstName:    to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
				LastName:     to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
				PhoneNumber:  to.Ptr("krf"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NewRelicMonitorResource = armnewrelicobservability.NewRelicMonitorResource{
	// 	Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
	// 	Type: to.Ptr("hdj"),
	// 	ID: to.Ptr("ilrwkvbuwu"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("k"),
	// 	Tags: map[string]*string{
	// 		"key6976": to.Ptr("oaxfhf"),
	// 	},
	// 	Properties: &armnewrelicobservability.MonitorProperties{
	// 		AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
	// 		LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
	// 		LiftrResourcePreference: to.Ptr[int32](12),
	// 		MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
	// 		MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
	// 		MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
	// 		NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
	// 			AccountInfo: &armnewrelicobservability.AccountInfo{
	// 				AccountID: to.Ptr("xhqmg"),
	// 				Region: to.Ptr("ljcf"),
	// 			},
	// 			OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
	// 				OrganizationID: to.Ptr("k"),
	// 			},
	// 			SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
	// 				EnterpriseAppID: to.Ptr("kwiwfz"),
	// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 				SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
	// 				SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
	// 			},
	// 			UserID: to.Ptr("vcscxlncofcuduadesd"),
	// 		},
	// 		OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
	// 		PlanData: &armnewrelicobservability.PlanData{
	// 			BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
	// 			EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
	// 			PlanDetails: to.Ptr("tbbiaga"),
	// 			UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 		UserInfo: &armnewrelicobservability.UserInfo{
	// 			Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
	// 			EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
	// 			FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
	// 			LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
	// 			PhoneNumber: to.Ptr("krf"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_Update_MaximumSet_Gen.json
func ExampleMonitorsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().Update(ctx, "rgNewRelic", "cdlymktqw", armnewrelicobservability.NewRelicMonitorResourceUpdate{
		Identity: &armnewrelicobservability.ManagedServiceIdentity{
			Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
			UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
				"key8903": {},
			},
		},
		Properties: &armnewrelicobservability.NewRelicMonitorResourceUpdateProperties{
			AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
			NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
				AccountInfo: &armnewrelicobservability.AccountInfo{
					AccountID:    to.Ptr("xhqmg"),
					IngestionKey: to.Ptr("wltnimmhqt"),
					Region:       to.Ptr("ljcf"),
				},
				OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
					OrganizationID: to.Ptr("k"),
				},
				SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
					EnterpriseAppID:   to.Ptr("kwiwfz"),
					ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateAccepted),
					SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
					SingleSignOnURL:   to.Ptr("kvseueuljsxmfwpqctz"),
				},
				UserID: to.Ptr("vcscxlncofcuduadesd"),
			},
			OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
			PlanData: &armnewrelicobservability.PlanData{
				BillingCycle:  to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t }()),
				PlanDetails:   to.Ptr("tbbiaga"),
				UsageType:     to.Ptr(armnewrelicobservability.UsageTypePAYG),
			},
			UserInfo: &armnewrelicobservability.UserInfo{
				Country:      to.Ptr("hslqnwdanrconqyekwbnttaetv"),
				EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
				FirstName:    to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
				LastName:     to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
				PhoneNumber:  to.Ptr("krf"),
			},
		},
		Tags: map[string]*string{
			"key164": to.Ptr("jqakdrrmmyzytqu"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NewRelicMonitorResource = armnewrelicobservability.NewRelicMonitorResource{
	// 	Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
	// 	Type: to.Ptr("hdj"),
	// 	ID: to.Ptr("ilrwkvbuwu"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("k"),
	// 	Tags: map[string]*string{
	// 		"key6976": to.Ptr("oaxfhf"),
	// 	},
	// 	Identity: &armnewrelicobservability.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
	// 		PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		TenantID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
	// 			"key8903": &armnewrelicobservability.UserAssignedIdentity{
	// 				ClientID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 				PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnewrelicobservability.MonitorProperties{
	// 		AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
	// 		LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
	// 		LiftrResourcePreference: to.Ptr[int32](12),
	// 		MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
	// 		MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
	// 		MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
	// 		NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
	// 			AccountInfo: &armnewrelicobservability.AccountInfo{
	// 				AccountID: to.Ptr("xhqmg"),
	// 				Region: to.Ptr("ljcf"),
	// 			},
	// 			OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
	// 				OrganizationID: to.Ptr("k"),
	// 			},
	// 			SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
	// 				EnterpriseAppID: to.Ptr("kwiwfz"),
	// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 				SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
	// 				SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
	// 			},
	// 			UserID: to.Ptr("vcscxlncofcuduadesd"),
	// 		},
	// 		OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
	// 		PlanData: &armnewrelicobservability.PlanData{
	// 			BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
	// 			EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
	// 			PlanDetails: to.Ptr("tbbiaga"),
	// 			UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 		UserInfo: &armnewrelicobservability.UserInfo{
	// 			Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
	// 			EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
	// 			FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
	// 			LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
	// 			PhoneNumber: to.Ptr("krf"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_Delete_MaximumSet_Gen.json
func ExampleMonitorsClient_BeginDelete_monitorsDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginDelete(ctx, "rgopenapi", "ruxvg@xqkmdhrnoo.hlmbpm", "ipxmlcbonyxtolzejcjshkmlron", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_Delete_MinimumSet_Gen.json
func ExampleMonitorsClient_BeginDelete_monitorsDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginDelete(ctx, "rgopenapi", "ruxvg@xqkmdhrnoo.hlmbpm", "ipxmlcbonyxtolzejcjshkmlron", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_GetMetricRules_MaximumSet_Gen.json
func ExampleMonitorsClient_GetMetricRules_monitorsGetMetricRulesMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMetricRules(ctx, "rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.MetricsRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricRules = armnewrelicobservability.MetricRules{
	// 	FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 		{
	// 			Name: to.Ptr("qnvixg"),
	// 			Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 			Value: to.Ptr("ihyabcsjvhkfzckfjvgvtlhdyvmwge"),
	// 	}},
	// 	SendMetrics: to.Ptr(armnewrelicobservability.SendMetricsStatusEnabled),
	// 	UserEmail: to.Ptr("test@testing.com"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_GetMetricRules_MinimumSet_Gen.json
func ExampleMonitorsClient_GetMetricRules_monitorsGetMetricRulesMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMetricRules(ctx, "rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.MetricsRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricRules = armnewrelicobservability.MetricRules{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_GetMetricStatus_MaximumSet_Gen.json
func ExampleMonitorsClient_GetMetricStatus_monitorsGetMetricStatusMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMetricStatus(ctx, "rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.MetricsStatusRequest{
		AzureResourceIDs: []*string{
			to.Ptr("enfghpfw")},
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricsStatusResponse = armnewrelicobservability.MetricsStatusResponse{
	// 	AzureResourceIDs: []*string{
	// 		to.Ptr("enfghpfw")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_GetMetricStatus_MinimumSet_Gen.json
func ExampleMonitorsClient_GetMetricStatus_monitorsGetMetricStatusMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMetricStatus(ctx, "rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.MetricsStatusRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricsStatusResponse = armnewrelicobservability.MetricsStatusResponse{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListAppServices_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListAppServicesPager_monitorsListAppServicesMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListAppServicesPager("rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.AppServicesGetRequest{
		AzureResourceIDs: []*string{
			to.Ptr("pvzrksrmzowobuhxpwiotnpcvjbu")},
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppServicesListResponse = armnewrelicobservability.AppServicesListResponse{
		// 	Value: []*armnewrelicobservability.AppServiceInfo{
		// 		{
		// 			AgentStatus: to.Ptr("vclwfecbppsfaygdccfu"),
		// 			AgentVersion: to.Ptr("owxkssnbp"),
		// 			AzureResourceID: to.Ptr("kjvbkwuqmouugrrz"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListAppServices_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListAppServicesPager_monitorsListAppServicesMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListAppServicesPager("rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.AppServicesGetRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppServicesListResponse = armnewrelicobservability.AppServicesListResponse{
		// 	Value: []*armnewrelicobservability.AppServiceInfo{
		// 		{
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_SwitchBilling_MaximumSet_Gen.json
func ExampleMonitorsClient_SwitchBilling_monitorsSwitchBillingMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().SwitchBilling(ctx, "rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.SwitchBillingRequest{
		AzureResourceID: to.Ptr("enfghpfw"),
		OrganizationID:  to.Ptr("k"),
		PlanData: &armnewrelicobservability.PlanData{
			BillingCycle:  to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
			EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t }()),
			PlanDetails:   to.Ptr("tbbiaga"),
			UsageType:     to.Ptr(armnewrelicobservability.UsageTypePAYG),
		},
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NewRelicMonitorResource = armnewrelicobservability.NewRelicMonitorResource{
	// 	Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
	// 	Type: to.Ptr("hdj"),
	// 	ID: to.Ptr("ilrwkvbuwu"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("k"),
	// 	Tags: map[string]*string{
	// 		"key6976": to.Ptr("oaxfhf"),
	// 	},
	// 	Identity: &armnewrelicobservability.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
	// 		PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		TenantID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
	// 			"key8903": &armnewrelicobservability.UserAssignedIdentity{
	// 				ClientID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 				PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnewrelicobservability.MonitorProperties{
	// 		AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
	// 		LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
	// 		LiftrResourcePreference: to.Ptr[int32](12),
	// 		MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
	// 		MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
	// 		MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
	// 		NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
	// 			AccountInfo: &armnewrelicobservability.AccountInfo{
	// 				AccountID: to.Ptr("xhqmg"),
	// 				Region: to.Ptr("ljcf"),
	// 			},
	// 			OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
	// 				OrganizationID: to.Ptr("k"),
	// 			},
	// 			SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
	// 				EnterpriseAppID: to.Ptr("kwiwfz"),
	// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 				SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
	// 				SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
	// 			},
	// 			UserID: to.Ptr("vcscxlncofcuduadesd"),
	// 		},
	// 		OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
	// 		PlanData: &armnewrelicobservability.PlanData{
	// 			BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
	// 			EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
	// 			PlanDetails: to.Ptr("tbbiaga"),
	// 			UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 		UserInfo: &armnewrelicobservability.UserInfo{
	// 			Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
	// 			EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
	// 			FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
	// 			LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
	// 			PhoneNumber: to.Ptr("krf"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_SwitchBilling_MinimumSet_Gen.json
func ExampleMonitorsClient_SwitchBilling_monitorsSwitchBillingMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().SwitchBilling(ctx, "rgNewRelic", "fhcjxnxumkdlgpwanewtkdnyuz", armnewrelicobservability.SwitchBillingRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NewRelicMonitorResource = armnewrelicobservability.NewRelicMonitorResource{
	// 	Name: to.Ptr("fteaqmtwspcfgyopqzrepiqu"),
	// 	Type: to.Ptr("hdj"),
	// 	ID: to.Ptr("ilrwkvbuwu"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		CreatedBy: to.Ptr("pcdjzdldbwsdlfi"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.787Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("xbsjrxmwwlmpnpvcica"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("k"),
	// 	Tags: map[string]*string{
	// 		"key6976": to.Ptr("oaxfhf"),
	// 	},
	// 	Identity: &armnewrelicobservability.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnewrelicobservability.ManagedServiceIdentityTypeNone),
	// 		PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		TenantID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 		UserAssignedIdentities: map[string]*armnewrelicobservability.UserAssignedIdentity{
	// 			"key8903": &armnewrelicobservability.UserAssignedIdentity{
	// 				ClientID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 				PrincipalID: to.Ptr("cac47a92-2856-11ed-a261-0242ac120002"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnewrelicobservability.MonitorProperties{
	// 		AccountCreationSource: to.Ptr(armnewrelicobservability.AccountCreationSourceLIFTR),
	// 		LiftrResourceCategory: to.Ptr(armnewrelicobservability.LiftrResourceCategoriesUnknown),
	// 		LiftrResourcePreference: to.Ptr[int32](12),
	// 		MarketplaceSubscriptionID: to.Ptr("jizcsbgrdjhrfqqvvruhgftqhra"),
	// 		MarketplaceSubscriptionStatus: to.Ptr(armnewrelicobservability.MarketplaceSubscriptionStatusActive),
	// 		MonitoringStatus: to.Ptr(armnewrelicobservability.MonitoringStatusEnabled),
	// 		NewRelicAccountProperties: &armnewrelicobservability.AccountPropertiesForNewRelic{
	// 			AccountInfo: &armnewrelicobservability.AccountInfo{
	// 				AccountID: to.Ptr("xhqmg"),
	// 				Region: to.Ptr("ljcf"),
	// 			},
	// 			OrganizationInfo: &armnewrelicobservability.OrganizationInfo{
	// 				OrganizationID: to.Ptr("k"),
	// 			},
	// 			SingleSignOnProperties: &armnewrelicobservability.NewRelicSingleSignOnProperties{
	// 				EnterpriseAppID: to.Ptr("kwiwfz"),
	// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 				SingleSignOnState: to.Ptr(armnewrelicobservability.SingleSignOnStatesInitial),
	// 				SingleSignOnURL: to.Ptr("kvseueuljsxmfwpqctz"),
	// 			},
	// 			UserID: to.Ptr("vcscxlncofcuduadesd"),
	// 		},
	// 		OrgCreationSource: to.Ptr(armnewrelicobservability.OrgCreationSourceLIFTR),
	// 		PlanData: &armnewrelicobservability.PlanData{
	// 			BillingCycle: to.Ptr(armnewrelicobservability.BillingCycleYEARLY),
	// 			EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-05T14:11:37.786Z"); return t}()),
	// 			PlanDetails: to.Ptr("tbbiaga"),
	// 			UsageType: to.Ptr(armnewrelicobservability.UsageTypePAYG),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 		UserInfo: &armnewrelicobservability.UserInfo{
	// 			Country: to.Ptr("hslqnwdanrconqyekwbnttaetv"),
	// 			EmailAddress: to.Ptr("%6%@4-g.N1.3F-kI1.Ue-.lJso"),
	// 			FirstName: to.Ptr("vdftzcggirefejajwahhwhyibutramdaotvnuf"),
	// 			LastName: to.Ptr("bcsztgqovdlmzfkjdrngidwzqsevagexzzilnlc"),
	// 			PhoneNumber: to.Ptr("krf"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListHosts_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListHostsPager_monitorsListHostsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListHostsPager("rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", armnewrelicobservability.HostsGetRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
		VMIDs: []*string{
			to.Ptr("xzphvxvfmvjrnsgyns")},
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VMHostsListResponse = armnewrelicobservability.VMHostsListResponse{
		// 	Value: []*armnewrelicobservability.VMInfo{
		// 		{
		// 			AgentStatus: to.Ptr("psnjslxwuwtviwzzgqhyzynuxvz"),
		// 			AgentVersion: to.Ptr("tbinulnoozxnbr"),
		// 			VMID: to.Ptr("gwyoa"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListHosts_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListHostsPager_monitorsListHostsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListHostsPager("rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", armnewrelicobservability.HostsGetRequest{
		UserEmail: to.Ptr("ruxvg@xqkmdhrnoo.hlmbpm"),
		VMIDs: []*string{
			to.Ptr("xzphvxvfmvjrnsgyns")},
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VMHostsListResponse = armnewrelicobservability.VMHostsListResponse{
		// 	Value: []*armnewrelicobservability.VMInfo{
		// 		{
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListMonitoredResources_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListMonitoredResourcesPager_monitorsListMonitoredResourcesMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListMonitoredResourcesPager("rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitoredResourceListResponse = armnewrelicobservability.MonitoredResourceListResponse{
		// 	Value: []*armnewrelicobservability.MonitoredResource{
		// 		{
		// 			ID: to.Ptr("qmtrcoxuctyphc"),
		// 			ReasonForLogsStatus: to.Ptr("agzxviwuxgr"),
		// 			ReasonForMetricsStatus: to.Ptr("k"),
		// 			SendingLogs: to.Ptr(armnewrelicobservability.SendingLogsStatusEnabled),
		// 			SendingMetrics: to.Ptr(armnewrelicobservability.SendingMetricsStatusEnabled),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_ListMonitoredResources_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListMonitoredResourcesPager_monitorsListMonitoredResourcesMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListMonitoredResourcesPager("rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitoredResourceListResponse = armnewrelicobservability.MonitoredResourceListResponse{
		// 	Value: []*armnewrelicobservability.MonitoredResource{
		// 		{
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_VmHostPayload_MaximumSet_Gen.json
func ExampleMonitorsClient_VMHostPayload_monitorsVmHostPayloadMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().VMHostPayload(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VMExtensionPayload = armnewrelicobservability.VMExtensionPayload{
	// 	IngestionKey: to.Ptr("ltqewhfexphvqgttoevaywrl"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/Monitors_VmHostPayload_MinimumSet_Gen.json
func ExampleMonitorsClient_VMHostPayload_monitorsVmHostPayloadMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().VMHostPayload(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VMExtensionPayload = armnewrelicobservability.VMExtensionPayload{
	// 	IngestionKey: to.Ptr("ltqewhfexphvqgttoevaywrl"),
	// }
}
