//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armconsumption_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ReservationRecommendationDetailsByBillingAccount.json
func ExampleReservationRecommendationDetailsClient_Get_reservationRecommendationsByBillingAccountLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationRecommendationDetailsClient().Get(ctx, "providers/Microsoft.Billing/billingAccounts/000000", armconsumption.ScopeShared, "eastus", armconsumption.TermP1Y, armconsumption.LookBackPeriodLast60Days, "Standard_DS14_v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationRecommendationDetailsModel = armconsumption.ReservationRecommendationDetailsModel{
	// 	Name: to.Ptr("reservationRecommendationDetails"),
	// 	Type: to.Ptr("Microsoft.Consumption/ReservationRecommendationDetails"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/00000000/providers/microsoft.consumption/reservationrecommendationdetails"),
	// 	Properties: &armconsumption.ReservationRecommendationDetailsProperties{
	// 		Currency: to.Ptr("USD"),
	// 		Resource: &armconsumption.ReservationRecommendationDetailsResourceProperties{
	// 			AppliedScopes: []*string{
	// 				to.Ptr("00000000-0000-0000-0000-00000000"),
	// 				to.Ptr("00000000-0000-0000-0000-00000000")},
	// 				OnDemandRate: to.Ptr[float32](1.482),
	// 				Product: to.Ptr("Standard_DS14_v2"),
	// 				Region: to.Ptr("eastus"),
	// 				ReservationRate: to.Ptr[float32](0.70570776255707),
	// 				ResourceType: to.Ptr("virtualmachines"),
	// 			},
	// 			Savings: &armconsumption.ReservationRecommendationDetailsSavingsProperties{
	// 				CalculatedSavings: []*armconsumption.ReservationRecommendationDetailsCalculatedSavingsProperties{
	// 					{
	// 						OnDemandCost: to.Ptr[float32](529550.326618951),
	// 						OverageCost: to.Ptr[float32](63253.5935111345),
	// 						Quantity: to.Ptr[float32](220),
	// 						ReservationCost: to.Ptr[float32](223102.452054792),
	// 						Savings: to.Ptr[float32](243194.281053024),
	// 						TotalReservationCost: to.Ptr[float32](286356.045565927),
	// 					},
	// 					{
	// 						OnDemandCost: to.Ptr[float32](529550.32661895),
	// 						OverageCost: to.Ptr[float32](149335.025050147),
	// 						Quantity: to.Ptr[float32](179),
	// 						ReservationCost: to.Ptr[float32](181524.267808217),
	// 						Savings: to.Ptr[float32](198691.033760586),
	// 						TotalReservationCost: to.Ptr[float32](330859.292858364),
	// 					},
	// 					{
	// 						OnDemandCost: to.Ptr[float32](529550.32661895),
	// 						OverageCost: to.Ptr[float32](195942.319606957),
	// 						Quantity: to.Ptr[float32](157),
	// 						ReservationCost: to.Ptr[float32](159214.022602738),
	// 						Savings: to.Ptr[float32](174393.984409255),
	// 						TotalReservationCost: to.Ptr[float32](355156.342209695),
	// 					},
	// 					{
	// 						OnDemandCost: to.Ptr[float32](529550.32661895),
	// 						OverageCost: to.Ptr[float32](30975.2311896299),
	// 						Quantity: to.Ptr[float32](241),
	// 						ReservationCost: to.Ptr[float32](244398.595205477),
	// 						Savings: to.Ptr[float32](254176.500223843),
	// 						TotalReservationCost: to.Ptr[float32](275373.826395107),
	// 				}},
	// 				LookBackPeriod: to.Ptr[int32](60),
	// 				RecommendedQuantity: to.Ptr[float32](253),
	// 				ReservationOrderTerm: to.Ptr("P1Y"),
	// 				SavingsType: to.Ptr("instance"),
	// 				UnitOfMeasure: to.Ptr("hour"),
	// 			},
	// 			Scope: to.Ptr("Shared"),
	// 			Usage: &armconsumption.ReservationRecommendationDetailsUsageProperties{
	// 				FirstConsumptionDate: to.Ptr("2019-11-27T00:00:00"),
	// 				LastConsumptionDate: to.Ptr("2020-01-25T21:00:00"),
	// 				LookBackUnitType: to.Ptr("virtualMachine quantity"),
	// 				UsageData: []*float32{
	// 					to.Ptr[float32](275.95003899999995),
	// 					to.Ptr[float32](275.916705),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](275.916725),
	// 					to.Ptr[float32](275.916705),
	// 					to.Ptr[float32](275.98335299999997),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](275.98335299999997),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](276),
	// 					to.Ptr[float32](275.933352)},
	// 					UsageGrain: to.Ptr("hourly"),
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ReservationRecommendationDetailsByBillingProfile.json
func ExampleReservationRecommendationDetailsClient_Get_reservationRecommendationsByBillingProfileModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationRecommendationDetailsClient().Get(ctx, "providers/Microsoft.Billing/billingAccounts/00000000-0000-0000-0000-00000000:00000000-0000-0000-0000-00000000/billingProfiles/00000000-0000-0000-0000-00000000", armconsumption.ScopeShared, "australiaeast", armconsumption.TermP1Y, armconsumption.LookBackPeriodLast07Days, "Standard_B2s", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationRecommendationDetailsModel = armconsumption.ReservationRecommendationDetailsModel{
	// 	Name: to.Ptr("reservationRecommendationDetails"),
	// 	Type: to.Ptr("Microsoft.Consumption/ReservationRecommendationDetails"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/00000000-0000-0000-0000-00000000:00000000-0000-0000-0000-00000000/billingProfiles/00000000-0000-0000-0000-00000000/providers/microsoft.consumption/reservationrecommendationdetails"),
	// 	Properties: &armconsumption.ReservationRecommendationDetailsProperties{
	// 		Currency: to.Ptr("AUD"),
	// 		Resource: &armconsumption.ReservationRecommendationDetailsResourceProperties{
	// 			AppliedScopes: []*string{
	// 				to.Ptr("00000000-0000-0000-0000-00000000")},
	// 				OnDemandRate: to.Ptr[float32](0.0725),
	// 				Product: to.Ptr("Standard_B2s"),
	// 				Region: to.Ptr("australiaeast"),
	// 				ReservationRate: to.Ptr[float32](0.04414166531788041),
	// 				ResourceType: to.Ptr("virtualmachines"),
	// 			},
	// 			Savings: &armconsumption.ReservationRecommendationDetailsSavingsProperties{
	// 				CalculatedSavings: []*armconsumption.ReservationRecommendationDetailsCalculatedSavingsProperties{
	// 					{
	// 						OnDemandCost: to.Ptr[float32](632.8844720496894),
	// 						OverageCost: to.Ptr[float32](0),
	// 						Quantity: to.Ptr[float32](1),
	// 						ReservationCost: to.Ptr[float32](387.74038815226174),
	// 						Savings: to.Ptr[float32](245.1440838974277),
	// 						TotalReservationCost: to.Ptr[float32](387.74038815226174),
	// 				}},
	// 				LookBackPeriod: to.Ptr[int32](7),
	// 				RecommendedQuantity: to.Ptr[float32](1),
	// 				ReservationOrderTerm: to.Ptr("P1Y"),
	// 				SavingsType: to.Ptr("instance"),
	// 				UnitOfMeasure: to.Ptr("hour"),
	// 			},
	// 			Scope: to.Ptr("Shared"),
	// 			Usage: &armconsumption.ReservationRecommendationDetailsUsageProperties{
	// 				FirstConsumptionDate: to.Ptr("2020-01-19T00:00:00"),
	// 				LastConsumptionDate: to.Ptr("2020-01-25T17:00:00"),
	// 				LookBackUnitType: to.Ptr("virtualMachine quantity"),
	// 				UsageData: []*float32{
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](0)},
	// 					UsageGrain: to.Ptr("hourly"),
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ReservationRecommendationDetailsByResourceGroup.json
func ExampleReservationRecommendationDetailsClient_Get_reservationRecommendationsByResourceGroupLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationRecommendationDetailsClient().Get(ctx, "subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/testGroup", armconsumption.ScopeSingle, "westus", armconsumption.TermP3Y, armconsumption.LookBackPeriodLast30Days, "Standard_DS13_v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationRecommendationDetailsModel = armconsumption.ReservationRecommendationDetailsModel{
	// 	Name: to.Ptr("reservationRecommendationDetails"),
	// 	Type: to.Ptr("Microsoft.Consumption/ReservationRecommendationDetails"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/testGroup/providers/microsoft.consumption/reservationrecommendationdetails"),
	// 	Properties: &armconsumption.ReservationRecommendationDetailsProperties{
	// 		Currency: to.Ptr("USD"),
	// 		Resource: &armconsumption.ReservationRecommendationDetailsResourceProperties{
	// 			AppliedScopes: []*string{
	// 				to.Ptr("00000000-0000-0000-0000-00000000"),
	// 				to.Ptr("testGroup")},
	// 				OnDemandRate: to.Ptr[float32](0.519),
	// 				Product: to.Ptr("Standard_DS13_v2"),
	// 				Region: to.Ptr("westus"),
	// 				ReservationRate: to.Ptr[float32](0.302549467275493),
	// 				ResourceType: to.Ptr("virtualmachines"),
	// 			},
	// 			ResourceGroup: to.Ptr("testGroup"),
	// 			Savings: &armconsumption.ReservationRecommendationDetailsSavingsProperties{
	// 				CalculatedSavings: []*armconsumption.ReservationRecommendationDetailsCalculatedSavingsProperties{
	// 					{
	// 						OnDemandCost: to.Ptr[float32](368.4813602070006),
	// 						OverageCost: to.Ptr[float32](0),
	// 						Quantity: to.Ptr[float32](2),
	// 						ReservationCost: to.Ptr[float32](429.01514459665),
	// 						Savings: to.Ptr[float32](-60.5337843896494),
	// 						TotalReservationCost: to.Ptr[float32](429.01514459665),
	// 					},
	// 					{
	// 						OnDemandCost: to.Ptr[float32](368.481360207),
	// 						OverageCost: to.Ptr[float32](1.557),
	// 						Quantity: to.Ptr[float32](1),
	// 						ReservationCost: to.Ptr[float32](214.507572298325),
	// 						Savings: to.Ptr[float32](152.416787908675),
	// 						TotalReservationCost: to.Ptr[float32](216.064572298325),
	// 				}},
	// 				LookBackPeriod: to.Ptr[int32](30),
	// 				RecommendedQuantity: to.Ptr[float32](1),
	// 				ReservationOrderTerm: to.Ptr("P3Y"),
	// 				SavingsType: to.Ptr("instance"),
	// 				UnitOfMeasure: to.Ptr("hour"),
	// 			},
	// 			Scope: to.Ptr("Single"),
	// 			Usage: &armconsumption.ReservationRecommendationDetailsUsageProperties{
	// 				FirstConsumptionDate: to.Ptr("2020-02-03T00:00:00"),
	// 				LastConsumptionDate: to.Ptr("2020-03-03T13:00:00"),
	// 				LookBackUnitType: to.Ptr("virtualMachine quantity"),
	// 				UsageData: []*float32{
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1)},
	// 					UsageGrain: to.Ptr("hourly"),
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ReservationRecommendationDetailsBySubscription.json
func ExampleReservationRecommendationDetailsClient_Get_reservationRecommendationsBySubscriptionLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationRecommendationDetailsClient().Get(ctx, "subscriptions/00000000-0000-0000-0000-00000000", armconsumption.ScopeSingle, "westus", armconsumption.TermP3Y, armconsumption.LookBackPeriodLast30Days, "Standard_DS13_v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationRecommendationDetailsModel = armconsumption.ReservationRecommendationDetailsModel{
	// 	Name: to.Ptr("reservationRecommendationDetails"),
	// 	Type: to.Ptr("Microsoft.Consumption/ReservationRecommendationDetails"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-00000000/providers/microsoft.consumption/reservationrecommendationdetails"),
	// 	Properties: &armconsumption.ReservationRecommendationDetailsProperties{
	// 		Currency: to.Ptr("USD"),
	// 		Resource: &armconsumption.ReservationRecommendationDetailsResourceProperties{
	// 			AppliedScopes: []*string{
	// 				to.Ptr("00000000-0000-0000-0000-00000000")},
	// 				OnDemandRate: to.Ptr[float32](0.519),
	// 				Product: to.Ptr("Standard_DS13_v2"),
	// 				Region: to.Ptr("westus"),
	// 				ReservationRate: to.Ptr[float32](0.302549467275493),
	// 				ResourceType: to.Ptr("virtualmachines"),
	// 			},
	// 			Savings: &armconsumption.ReservationRecommendationDetailsSavingsProperties{
	// 				CalculatedSavings: []*armconsumption.ReservationRecommendationDetailsCalculatedSavingsProperties{
	// 					{
	// 						OnDemandCost: to.Ptr[float32](368.4813602070006),
	// 						OverageCost: to.Ptr[float32](0),
	// 						Quantity: to.Ptr[float32](2),
	// 						ReservationCost: to.Ptr[float32](429.01514459665),
	// 						Savings: to.Ptr[float32](-60.5337843896494),
	// 						TotalReservationCost: to.Ptr[float32](429.01514459665),
	// 					},
	// 					{
	// 						OnDemandCost: to.Ptr[float32](368.481360207),
	// 						OverageCost: to.Ptr[float32](1.557),
	// 						Quantity: to.Ptr[float32](1),
	// 						ReservationCost: to.Ptr[float32](214.507572298325),
	// 						Savings: to.Ptr[float32](152.416787908675),
	// 						TotalReservationCost: to.Ptr[float32](216.064572298325),
	// 				}},
	// 				LookBackPeriod: to.Ptr[int32](30),
	// 				RecommendedQuantity: to.Ptr[float32](1),
	// 				ReservationOrderTerm: to.Ptr("P3Y"),
	// 				SavingsType: to.Ptr("instance"),
	// 				UnitOfMeasure: to.Ptr("hour"),
	// 			},
	// 			Scope: to.Ptr("Single"),
	// 			Usage: &armconsumption.ReservationRecommendationDetailsUsageProperties{
	// 				FirstConsumptionDate: to.Ptr("2020-02-03T00:00:00"),
	// 				LastConsumptionDate: to.Ptr("2020-03-03T13:00:00"),
	// 				LookBackUnitType: to.Ptr("virtualMachine quantity"),
	// 				UsageData: []*float32{
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1),
	// 					to.Ptr[float32](1)},
	// 					UsageGrain: to.Ptr("hourly"),
	// 				},
	// 			},
	// 		}
}
