//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/communication/armcommunication/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SenderUsernamesServer is a fake server for instances of the armcommunication.SenderUsernamesClient type.
type SenderUsernamesServer struct {
	// CreateOrUpdate is the fake for method SenderUsernamesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, senderUsername string, parameters armcommunication.SenderUsernameResource, options *armcommunication.SenderUsernamesClientCreateOrUpdateOptions) (resp azfake.Responder[armcommunication.SenderUsernamesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SenderUsernamesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, senderUsername string, options *armcommunication.SenderUsernamesClientDeleteOptions) (resp azfake.Responder[armcommunication.SenderUsernamesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SenderUsernamesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, senderUsername string, options *armcommunication.SenderUsernamesClientGetOptions) (resp azfake.Responder[armcommunication.SenderUsernamesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDomainsPager is the fake for method SenderUsernamesClient.NewListByDomainsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDomainsPager func(resourceGroupName string, emailServiceName string, domainName string, options *armcommunication.SenderUsernamesClientListByDomainsOptions) (resp azfake.PagerResponder[armcommunication.SenderUsernamesClientListByDomainsResponse])
}

// NewSenderUsernamesServerTransport creates a new instance of SenderUsernamesServerTransport with the provided implementation.
// The returned SenderUsernamesServerTransport instance is connected to an instance of armcommunication.SenderUsernamesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSenderUsernamesServerTransport(srv *SenderUsernamesServer) *SenderUsernamesServerTransport {
	return &SenderUsernamesServerTransport{
		srv:                   srv,
		newListByDomainsPager: newTracker[azfake.PagerResponder[armcommunication.SenderUsernamesClientListByDomainsResponse]](),
	}
}

// SenderUsernamesServerTransport connects instances of armcommunication.SenderUsernamesClient to instances of SenderUsernamesServer.
// Don't use this type directly, use NewSenderUsernamesServerTransport instead.
type SenderUsernamesServerTransport struct {
	srv                   *SenderUsernamesServer
	newListByDomainsPager *tracker[azfake.PagerResponder[armcommunication.SenderUsernamesClientListByDomainsResponse]]
}

// Do implements the policy.Transporter interface for SenderUsernamesServerTransport.
func (s *SenderUsernamesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SenderUsernamesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SenderUsernamesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SenderUsernamesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SenderUsernamesClient.NewListByDomainsPager":
		resp, err = s.dispatchNewListByDomainsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SenderUsernamesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/senderUsernames/(?P<senderUsername>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcommunication.SenderUsernameResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	senderUsernameParam, err := url.PathUnescape(matches[regex.SubexpIndex("senderUsername")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, emailServiceNameParam, domainNameParam, senderUsernameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SenderUsernameResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SenderUsernamesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/senderUsernames/(?P<senderUsername>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	senderUsernameParam, err := url.PathUnescape(matches[regex.SubexpIndex("senderUsername")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, emailServiceNameParam, domainNameParam, senderUsernameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SenderUsernamesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/senderUsernames/(?P<senderUsername>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	senderUsernameParam, err := url.PathUnescape(matches[regex.SubexpIndex("senderUsername")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, emailServiceNameParam, domainNameParam, senderUsernameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SenderUsernameResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SenderUsernamesServerTransport) dispatchNewListByDomainsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByDomainsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDomainsPager not implemented")}
	}
	newListByDomainsPager := s.newListByDomainsPager.get(req)
	if newListByDomainsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/senderUsernames`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByDomainsPager(resourceGroupNameParam, emailServiceNameParam, domainNameParam, nil)
		newListByDomainsPager = &resp
		s.newListByDomainsPager.add(req, newListByDomainsPager)
		server.PagerResponderInjectNextLinks(newListByDomainsPager, req, func(page *armcommunication.SenderUsernamesClientListByDomainsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDomainsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByDomainsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDomainsPager) {
		s.newListByDomainsPager.remove(req)
	}
	return resp, nil
}
