//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armautomanage.ClientFactory type.
type ServerFactory struct {
	BestPracticesServer                       BestPracticesServer
	BestPracticesVersionsServer               BestPracticesVersionsServer
	ConfigurationProfileAssignmentsServer     ConfigurationProfileAssignmentsServer
	ConfigurationProfileHCIAssignmentsServer  ConfigurationProfileHCIAssignmentsServer
	ConfigurationProfileHCRPAssignmentsServer ConfigurationProfileHCRPAssignmentsServer
	ConfigurationProfilesServer               ConfigurationProfilesServer
	ConfigurationProfilesVersionsServer       ConfigurationProfilesVersionsServer
	HCIReportsServer                          HCIReportsServer
	HCRPReportsServer                         HCRPReportsServer
	OperationsServer                          OperationsServer
	ReportsServer                             ReportsServer
	ServicePrincipalsServer                   ServicePrincipalsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armautomanage.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armautomanage.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                         *ServerFactory
	trMu                                        sync.Mutex
	trBestPracticesServer                       *BestPracticesServerTransport
	trBestPracticesVersionsServer               *BestPracticesVersionsServerTransport
	trConfigurationProfileAssignmentsServer     *ConfigurationProfileAssignmentsServerTransport
	trConfigurationProfileHCIAssignmentsServer  *ConfigurationProfileHCIAssignmentsServerTransport
	trConfigurationProfileHCRPAssignmentsServer *ConfigurationProfileHCRPAssignmentsServerTransport
	trConfigurationProfilesServer               *ConfigurationProfilesServerTransport
	trConfigurationProfilesVersionsServer       *ConfigurationProfilesVersionsServerTransport
	trHCIReportsServer                          *HCIReportsServerTransport
	trHCRPReportsServer                         *HCRPReportsServerTransport
	trOperationsServer                          *OperationsServerTransport
	trReportsServer                             *ReportsServerTransport
	trServicePrincipalsServer                   *ServicePrincipalsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "BestPracticesClient":
		initServer(s, &s.trBestPracticesServer, func() *BestPracticesServerTransport {
			return NewBestPracticesServerTransport(&s.srv.BestPracticesServer)
		})
		resp, err = s.trBestPracticesServer.Do(req)
	case "BestPracticesVersionsClient":
		initServer(s, &s.trBestPracticesVersionsServer, func() *BestPracticesVersionsServerTransport {
			return NewBestPracticesVersionsServerTransport(&s.srv.BestPracticesVersionsServer)
		})
		resp, err = s.trBestPracticesVersionsServer.Do(req)
	case "ConfigurationProfileAssignmentsClient":
		initServer(s, &s.trConfigurationProfileAssignmentsServer, func() *ConfigurationProfileAssignmentsServerTransport {
			return NewConfigurationProfileAssignmentsServerTransport(&s.srv.ConfigurationProfileAssignmentsServer)
		})
		resp, err = s.trConfigurationProfileAssignmentsServer.Do(req)
	case "ConfigurationProfileHCIAssignmentsClient":
		initServer(s, &s.trConfigurationProfileHCIAssignmentsServer, func() *ConfigurationProfileHCIAssignmentsServerTransport {
			return NewConfigurationProfileHCIAssignmentsServerTransport(&s.srv.ConfigurationProfileHCIAssignmentsServer)
		})
		resp, err = s.trConfigurationProfileHCIAssignmentsServer.Do(req)
	case "ConfigurationProfileHCRPAssignmentsClient":
		initServer(s, &s.trConfigurationProfileHCRPAssignmentsServer, func() *ConfigurationProfileHCRPAssignmentsServerTransport {
			return NewConfigurationProfileHCRPAssignmentsServerTransport(&s.srv.ConfigurationProfileHCRPAssignmentsServer)
		})
		resp, err = s.trConfigurationProfileHCRPAssignmentsServer.Do(req)
	case "ConfigurationProfilesClient":
		initServer(s, &s.trConfigurationProfilesServer, func() *ConfigurationProfilesServerTransport {
			return NewConfigurationProfilesServerTransport(&s.srv.ConfigurationProfilesServer)
		})
		resp, err = s.trConfigurationProfilesServer.Do(req)
	case "ConfigurationProfilesVersionsClient":
		initServer(s, &s.trConfigurationProfilesVersionsServer, func() *ConfigurationProfilesVersionsServerTransport {
			return NewConfigurationProfilesVersionsServerTransport(&s.srv.ConfigurationProfilesVersionsServer)
		})
		resp, err = s.trConfigurationProfilesVersionsServer.Do(req)
	case "HCIReportsClient":
		initServer(s, &s.trHCIReportsServer, func() *HCIReportsServerTransport { return NewHCIReportsServerTransport(&s.srv.HCIReportsServer) })
		resp, err = s.trHCIReportsServer.Do(req)
	case "HCRPReportsClient":
		initServer(s, &s.trHCRPReportsServer, func() *HCRPReportsServerTransport { return NewHCRPReportsServerTransport(&s.srv.HCRPReportsServer) })
		resp, err = s.trHCRPReportsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "ReportsClient":
		initServer(s, &s.trReportsServer, func() *ReportsServerTransport { return NewReportsServerTransport(&s.srv.ReportsServer) })
		resp, err = s.trReportsServer.Do(req)
	case "ServicePrincipalsClient":
		initServer(s, &s.trServicePrincipalsServer, func() *ServicePrincipalsServerTransport {
			return NewServicePrincipalsServerTransport(&s.srv.ServicePrincipalsServer)
		})
		resp, err = s.trServicePrincipalsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
