//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// WebAppsServer is a fake server for instances of the armappservice.WebAppsClient type.
type WebAppsServer struct {
	// AddPremierAddOn is the fake for method WebAppsClient.AddPremierAddOn
	// HTTP status codes to indicate success: http.StatusOK
	AddPremierAddOn func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn armappservice.PremierAddOn, options *armappservice.WebAppsClientAddPremierAddOnOptions) (resp azfake.Responder[armappservice.WebAppsClientAddPremierAddOnResponse], errResp azfake.ErrorResponder)

	// AddPremierAddOnSlot is the fake for method WebAppsClient.AddPremierAddOnSlot
	// HTTP status codes to indicate success: http.StatusOK
	AddPremierAddOnSlot func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, premierAddOn armappservice.PremierAddOn, options *armappservice.WebAppsClientAddPremierAddOnSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientAddPremierAddOnSlotResponse], errResp azfake.ErrorResponder)

	// AnalyzeCustomHostname is the fake for method WebAppsClient.AnalyzeCustomHostname
	// HTTP status codes to indicate success: http.StatusOK
	AnalyzeCustomHostname func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientAnalyzeCustomHostnameOptions) (resp azfake.Responder[armappservice.WebAppsClientAnalyzeCustomHostnameResponse], errResp azfake.ErrorResponder)

	// AnalyzeCustomHostnameSlot is the fake for method WebAppsClient.AnalyzeCustomHostnameSlot
	// HTTP status codes to indicate success: http.StatusOK
	AnalyzeCustomHostnameSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientAnalyzeCustomHostnameSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientAnalyzeCustomHostnameSlotResponse], errResp azfake.ErrorResponder)

	// ApplySlotConfigToProduction is the fake for method WebAppsClient.ApplySlotConfigToProduction
	// HTTP status codes to indicate success: http.StatusOK
	ApplySlotConfigToProduction func(ctx context.Context, resourceGroupName string, name string, slotSwapEntity armappservice.CsmSlotEntity, options *armappservice.WebAppsClientApplySlotConfigToProductionOptions) (resp azfake.Responder[armappservice.WebAppsClientApplySlotConfigToProductionResponse], errResp azfake.ErrorResponder)

	// ApplySlotConfigurationSlot is the fake for method WebAppsClient.ApplySlotConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	ApplySlotConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, slotSwapEntity armappservice.CsmSlotEntity, options *armappservice.WebAppsClientApplySlotConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientApplySlotConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// BeginApproveOrRejectPrivateEndpointConnection is the fake for method WebAppsClient.BeginApproveOrRejectPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginApproveOrRejectPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper armappservice.PrivateLinkConnectionApprovalRequestResource, options *armappservice.WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// BeginApproveOrRejectPrivateEndpointConnectionSlot is the fake for method WebAppsClient.BeginApproveOrRejectPrivateEndpointConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginApproveOrRejectPrivateEndpointConnectionSlot func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, privateEndpointWrapper armappservice.PrivateLinkConnectionApprovalRequestResource, options *armappservice.WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse], errResp azfake.ErrorResponder)

	// Backup is the fake for method WebAppsClient.Backup
	// HTTP status codes to indicate success: http.StatusOK
	Backup func(ctx context.Context, resourceGroupName string, name string, request armappservice.BackupRequest, options *armappservice.WebAppsClientBackupOptions) (resp azfake.Responder[armappservice.WebAppsClientBackupResponse], errResp azfake.ErrorResponder)

	// BackupSlot is the fake for method WebAppsClient.BackupSlot
	// HTTP status codes to indicate success: http.StatusOK
	BackupSlot func(ctx context.Context, resourceGroupName string, name string, slot string, request armappservice.BackupRequest, options *armappservice.WebAppsClientBackupSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientBackupSlotResponse], errResp azfake.ErrorResponder)

	// CreateDeployment is the fake for method WebAppsClient.CreateDeployment
	// HTTP status codes to indicate success: http.StatusOK
	CreateDeployment func(ctx context.Context, resourceGroupName string, name string, id string, deployment armappservice.Deployment, options *armappservice.WebAppsClientCreateDeploymentOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateDeploymentResponse], errResp azfake.ErrorResponder)

	// CreateDeploymentSlot is the fake for method WebAppsClient.CreateDeploymentSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateDeploymentSlot func(ctx context.Context, resourceGroupName string, name string, id string, slot string, deployment armappservice.Deployment, options *armappservice.WebAppsClientCreateDeploymentSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateDeploymentSlotResponse], errResp azfake.ErrorResponder)

	// BeginCreateFunction is the fake for method WebAppsClient.BeginCreateFunction
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateFunction func(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope armappservice.FunctionEnvelope, options *armappservice.WebAppsClientBeginCreateFunctionOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateFunctionResponse], errResp azfake.ErrorResponder)

	// BeginCreateInstanceFunctionSlot is the fake for method WebAppsClient.BeginCreateInstanceFunctionSlot
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateInstanceFunctionSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope armappservice.FunctionEnvelope, options *armappservice.WebAppsClientBeginCreateInstanceFunctionSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceFunctionSlotResponse], errResp azfake.ErrorResponder)

	// BeginCreateInstanceMSDeployOperation is the fake for method WebAppsClient.BeginCreateInstanceMSDeployOperation
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateInstanceMSDeployOperation func(ctx context.Context, resourceGroupName string, name string, instanceID string, msDeploy armappservice.MSDeploy, options *armappservice.WebAppsClientBeginCreateInstanceMSDeployOperationOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceMSDeployOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreateInstanceMSDeployOperationSlot is the fake for method WebAppsClient.BeginCreateInstanceMSDeployOperationSlot
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateInstanceMSDeployOperationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, msDeploy armappservice.MSDeploy, options *armappservice.WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceMSDeployOperationSlotResponse], errResp azfake.ErrorResponder)

	// BeginCreateMSDeployOperation is the fake for method WebAppsClient.BeginCreateMSDeployOperation
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateMSDeployOperation func(ctx context.Context, resourceGroupName string, name string, msDeploy armappservice.MSDeploy, options *armappservice.WebAppsClientBeginCreateMSDeployOperationOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateMSDeployOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreateMSDeployOperationSlot is the fake for method WebAppsClient.BeginCreateMSDeployOperationSlot
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateMSDeployOperationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, msDeploy armappservice.MSDeploy, options *armappservice.WebAppsClientBeginCreateMSDeployOperationSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateMSDeployOperationSlotResponse], errResp azfake.ErrorResponder)

	// CreateOneDeployOperation is the fake for method WebAppsClient.CreateOneDeployOperation
	// HTTP status codes to indicate success: http.StatusOK
	CreateOneDeployOperation func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientCreateOneDeployOperationOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOneDeployOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method WebAppsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, name string, siteEnvelope armappservice.Site, options *armappservice.WebAppsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateConfiguration is the fake for method WebAppsClient.CreateOrUpdateConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateConfiguration func(ctx context.Context, resourceGroupName string, name string, siteConfig armappservice.SiteConfigResource, options *armappservice.WebAppsClientCreateOrUpdateConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateConfigurationResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateConfigurationSlot is the fake for method WebAppsClient.CreateOrUpdateConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteConfig armappservice.SiteConfigResource, options *armappservice.WebAppsClientCreateOrUpdateConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateDomainOwnershipIdentifier is the fake for method WebAppsClient.CreateOrUpdateDomainOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateDomainOwnershipIdentifier func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier armappservice.Identifier, options *armappservice.WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateDomainOwnershipIdentifierSlot is the fake for method WebAppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateDomainOwnershipIdentifierSlot func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, domainOwnershipIdentifier armappservice.Identifier, options *armappservice.WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateFunctionSecret is the fake for method WebAppsClient.CreateOrUpdateFunctionSecret
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateFunctionSecret func(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, key armappservice.KeyInfo, options *armappservice.WebAppsClientCreateOrUpdateFunctionSecretOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateFunctionSecretResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateFunctionSecretSlot is the fake for method WebAppsClient.CreateOrUpdateFunctionSecretSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateFunctionSecretSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, key armappservice.KeyInfo, options *armappservice.WebAppsClientCreateOrUpdateFunctionSecretSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateFunctionSecretSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateHostNameBinding is the fake for method WebAppsClient.CreateOrUpdateHostNameBinding
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateHostNameBinding func(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding armappservice.HostNameBinding, options *armappservice.WebAppsClientCreateOrUpdateHostNameBindingOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateHostNameBindingResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateHostNameBindingSlot is the fake for method WebAppsClient.CreateOrUpdateHostNameBindingSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateHostNameBindingSlot func(ctx context.Context, resourceGroupName string, name string, hostName string, slot string, hostNameBinding armappservice.HostNameBinding, options *armappservice.WebAppsClientCreateOrUpdateHostNameBindingSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateHostNameBindingSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateHostSecret is the fake for method WebAppsClient.CreateOrUpdateHostSecret
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateHostSecret func(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, key armappservice.KeyInfo, options *armappservice.WebAppsClientCreateOrUpdateHostSecretOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateHostSecretResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateHostSecretSlot is the fake for method WebAppsClient.CreateOrUpdateHostSecretSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateHostSecretSlot func(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, key armappservice.KeyInfo, options *armappservice.WebAppsClientCreateOrUpdateHostSecretSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateHostSecretSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateHybridConnection is the fake for method WebAppsClient.CreateOrUpdateHybridConnection
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateHybridConnection func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope armappservice.HybridConnection, options *armappservice.WebAppsClientCreateOrUpdateHybridConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateHybridConnectionResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateHybridConnectionSlot is the fake for method WebAppsClient.CreateOrUpdateHybridConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateHybridConnectionSlot func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, connectionEnvelope armappservice.HybridConnection, options *armappservice.WebAppsClientCreateOrUpdateHybridConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateHybridConnectionSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdatePublicCertificate is the fake for method WebAppsClient.CreateOrUpdatePublicCertificate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdatePublicCertificate func(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate armappservice.PublicCertificate, options *armappservice.WebAppsClientCreateOrUpdatePublicCertificateOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdatePublicCertificateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdatePublicCertificateSlot is the fake for method WebAppsClient.CreateOrUpdatePublicCertificateSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdatePublicCertificateSlot func(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, slot string, publicCertificate armappservice.PublicCertificate, options *armappservice.WebAppsClientCreateOrUpdatePublicCertificateSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdatePublicCertificateSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateRelayServiceConnection is the fake for method WebAppsClient.CreateOrUpdateRelayServiceConnection
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateRelayServiceConnection func(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope armappservice.RelayServiceConnectionEntity, options *armappservice.WebAppsClientCreateOrUpdateRelayServiceConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateRelayServiceConnectionResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateRelayServiceConnectionSlot is the fake for method WebAppsClient.CreateOrUpdateRelayServiceConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateRelayServiceConnectionSlot func(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, connectionEnvelope armappservice.RelayServiceConnectionEntity, options *armappservice.WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateSlot is the fake for method WebAppsClient.BeginCreateOrUpdateSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdateSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteEnvelope armappservice.Site, options *armappservice.WebAppsClientBeginCreateOrUpdateSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSlotResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateSourceControl is the fake for method WebAppsClient.BeginCreateOrUpdateSourceControl
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdateSourceControl func(ctx context.Context, resourceGroupName string, name string, siteSourceControl armappservice.SiteSourceControl, options *armappservice.WebAppsClientBeginCreateOrUpdateSourceControlOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSourceControlResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateSourceControlSlot is the fake for method WebAppsClient.BeginCreateOrUpdateSourceControlSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdateSourceControlSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteSourceControl armappservice.SiteSourceControl, options *armappservice.WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSourceControlSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck is the fake for method WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck func(ctx context.Context, resourceGroupName string, name string, connectionEnvelope armappservice.SwiftVirtualNetwork, options *armappservice.WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot is the fake for method WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot func(ctx context.Context, resourceGroupName string, name string, slot string, connectionEnvelope armappservice.SwiftVirtualNetwork, options *armappservice.WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateVnetConnection is the fake for method WebAppsClient.CreateOrUpdateVnetConnection
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateVnetConnection func(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope armappservice.VnetInfoResource, options *armappservice.WebAppsClientCreateOrUpdateVnetConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateVnetConnectionResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateVnetConnectionGateway is the fake for method WebAppsClient.CreateOrUpdateVnetConnectionGateway
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateVnetConnectionGateway func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope armappservice.VnetGateway, options *armappservice.WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateVnetConnectionGatewaySlot is the fake for method WebAppsClient.CreateOrUpdateVnetConnectionGatewaySlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateVnetConnectionGatewaySlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, connectionEnvelope armappservice.VnetGateway, options *armappservice.WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateVnetConnectionSlot is the fake for method WebAppsClient.CreateOrUpdateVnetConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateVnetConnectionSlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, connectionEnvelope armappservice.VnetInfoResource, options *armappservice.WebAppsClientCreateOrUpdateVnetConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientCreateOrUpdateVnetConnectionSlotResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method WebAppsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientDeleteOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteBackup is the fake for method WebAppsClient.DeleteBackup
	// HTTP status codes to indicate success: http.StatusOK
	DeleteBackup func(ctx context.Context, resourceGroupName string, name string, backupID string, options *armappservice.WebAppsClientDeleteBackupOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteBackupResponse], errResp azfake.ErrorResponder)

	// DeleteBackupConfiguration is the fake for method WebAppsClient.DeleteBackupConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	DeleteBackupConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientDeleteBackupConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteBackupConfigurationResponse], errResp azfake.ErrorResponder)

	// DeleteBackupConfigurationSlot is the fake for method WebAppsClient.DeleteBackupConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeleteBackupConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientDeleteBackupConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteBackupConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// DeleteBackupSlot is the fake for method WebAppsClient.DeleteBackupSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeleteBackupSlot func(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, options *armappservice.WebAppsClientDeleteBackupSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteBackupSlotResponse], errResp azfake.ErrorResponder)

	// DeleteContinuousWebJob is the fake for method WebAppsClient.DeleteContinuousWebJob
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteContinuousWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientDeleteContinuousWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteContinuousWebJobResponse], errResp azfake.ErrorResponder)

	// DeleteContinuousWebJobSlot is the fake for method WebAppsClient.DeleteContinuousWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteContinuousWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientDeleteContinuousWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteContinuousWebJobSlotResponse], errResp azfake.ErrorResponder)

	// DeleteDeployment is the fake for method WebAppsClient.DeleteDeployment
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDeployment func(ctx context.Context, resourceGroupName string, name string, id string, options *armappservice.WebAppsClientDeleteDeploymentOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteDeploymentResponse], errResp azfake.ErrorResponder)

	// DeleteDeploymentSlot is the fake for method WebAppsClient.DeleteDeploymentSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDeploymentSlot func(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *armappservice.WebAppsClientDeleteDeploymentSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteDeploymentSlotResponse], errResp azfake.ErrorResponder)

	// DeleteDomainOwnershipIdentifier is the fake for method WebAppsClient.DeleteDomainOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDomainOwnershipIdentifier func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, options *armappservice.WebAppsClientDeleteDomainOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteDomainOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// DeleteDomainOwnershipIdentifierSlot is the fake for method WebAppsClient.DeleteDomainOwnershipIdentifierSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDomainOwnershipIdentifierSlot func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, options *armappservice.WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse], errResp azfake.ErrorResponder)

	// DeleteFunction is the fake for method WebAppsClient.DeleteFunction
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteFunction func(ctx context.Context, resourceGroupName string, name string, functionName string, options *armappservice.WebAppsClientDeleteFunctionOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteFunctionResponse], errResp azfake.ErrorResponder)

	// DeleteFunctionSecret is the fake for method WebAppsClient.DeleteFunctionSecret
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteFunctionSecret func(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, options *armappservice.WebAppsClientDeleteFunctionSecretOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteFunctionSecretResponse], errResp azfake.ErrorResponder)

	// DeleteFunctionSecretSlot is the fake for method WebAppsClient.DeleteFunctionSecretSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteFunctionSecretSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, options *armappservice.WebAppsClientDeleteFunctionSecretSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteFunctionSecretSlotResponse], errResp azfake.ErrorResponder)

	// DeleteHostNameBinding is the fake for method WebAppsClient.DeleteHostNameBinding
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteHostNameBinding func(ctx context.Context, resourceGroupName string, name string, hostName string, options *armappservice.WebAppsClientDeleteHostNameBindingOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteHostNameBindingResponse], errResp azfake.ErrorResponder)

	// DeleteHostNameBindingSlot is the fake for method WebAppsClient.DeleteHostNameBindingSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteHostNameBindingSlot func(ctx context.Context, resourceGroupName string, name string, slot string, hostName string, options *armappservice.WebAppsClientDeleteHostNameBindingSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteHostNameBindingSlotResponse], errResp azfake.ErrorResponder)

	// DeleteHostSecret is the fake for method WebAppsClient.DeleteHostSecret
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteHostSecret func(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, options *armappservice.WebAppsClientDeleteHostSecretOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteHostSecretResponse], errResp azfake.ErrorResponder)

	// DeleteHostSecretSlot is the fake for method WebAppsClient.DeleteHostSecretSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteHostSecretSlot func(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, options *armappservice.WebAppsClientDeleteHostSecretSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteHostSecretSlotResponse], errResp azfake.ErrorResponder)

	// DeleteHybridConnection is the fake for method WebAppsClient.DeleteHybridConnection
	// HTTP status codes to indicate success: http.StatusOK
	DeleteHybridConnection func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *armappservice.WebAppsClientDeleteHybridConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteHybridConnectionResponse], errResp azfake.ErrorResponder)

	// DeleteHybridConnectionSlot is the fake for method WebAppsClient.DeleteHybridConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeleteHybridConnectionSlot func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, options *armappservice.WebAppsClientDeleteHybridConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteHybridConnectionSlotResponse], errResp azfake.ErrorResponder)

	// DeleteInstanceFunctionSlot is the fake for method WebAppsClient.DeleteInstanceFunctionSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteInstanceFunctionSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *armappservice.WebAppsClientDeleteInstanceFunctionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteInstanceFunctionSlotResponse], errResp azfake.ErrorResponder)

	// DeleteInstanceProcess is the fake for method WebAppsClient.DeleteInstanceProcess
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteInstanceProcess func(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *armappservice.WebAppsClientDeleteInstanceProcessOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteInstanceProcessResponse], errResp azfake.ErrorResponder)

	// DeleteInstanceProcessSlot is the fake for method WebAppsClient.DeleteInstanceProcessSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteInstanceProcessSlot func(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *armappservice.WebAppsClientDeleteInstanceProcessSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteInstanceProcessSlotResponse], errResp azfake.ErrorResponder)

	// DeletePremierAddOn is the fake for method WebAppsClient.DeletePremierAddOn
	// HTTP status codes to indicate success: http.StatusOK
	DeletePremierAddOn func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, options *armappservice.WebAppsClientDeletePremierAddOnOptions) (resp azfake.Responder[armappservice.WebAppsClientDeletePremierAddOnResponse], errResp azfake.ErrorResponder)

	// DeletePremierAddOnSlot is the fake for method WebAppsClient.DeletePremierAddOnSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeletePremierAddOnSlot func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, options *armappservice.WebAppsClientDeletePremierAddOnSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeletePremierAddOnSlotResponse], errResp azfake.ErrorResponder)

	// BeginDeletePrivateEndpointConnection is the fake for method WebAppsClient.BeginDeletePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *armappservice.WebAppsClientBeginDeletePrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientDeletePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// BeginDeletePrivateEndpointConnectionSlot is the fake for method WebAppsClient.BeginDeletePrivateEndpointConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePrivateEndpointConnectionSlot func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *armappservice.WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientDeletePrivateEndpointConnectionSlotResponse], errResp azfake.ErrorResponder)

	// DeleteProcess is the fake for method WebAppsClient.DeleteProcess
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteProcess func(ctx context.Context, resourceGroupName string, name string, processID string, options *armappservice.WebAppsClientDeleteProcessOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteProcessResponse], errResp azfake.ErrorResponder)

	// DeleteProcessSlot is the fake for method WebAppsClient.DeleteProcessSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteProcessSlot func(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *armappservice.WebAppsClientDeleteProcessSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteProcessSlotResponse], errResp azfake.ErrorResponder)

	// DeletePublicCertificate is the fake for method WebAppsClient.DeletePublicCertificate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeletePublicCertificate func(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, options *armappservice.WebAppsClientDeletePublicCertificateOptions) (resp azfake.Responder[armappservice.WebAppsClientDeletePublicCertificateResponse], errResp azfake.ErrorResponder)

	// DeletePublicCertificateSlot is the fake for method WebAppsClient.DeletePublicCertificateSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeletePublicCertificateSlot func(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string, options *armappservice.WebAppsClientDeletePublicCertificateSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeletePublicCertificateSlotResponse], errResp azfake.ErrorResponder)

	// DeleteRelayServiceConnection is the fake for method WebAppsClient.DeleteRelayServiceConnection
	// HTTP status codes to indicate success: http.StatusOK
	DeleteRelayServiceConnection func(ctx context.Context, resourceGroupName string, name string, entityName string, options *armappservice.WebAppsClientDeleteRelayServiceConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteRelayServiceConnectionResponse], errResp azfake.ErrorResponder)

	// DeleteRelayServiceConnectionSlot is the fake for method WebAppsClient.DeleteRelayServiceConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeleteRelayServiceConnectionSlot func(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, options *armappservice.WebAppsClientDeleteRelayServiceConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteRelayServiceConnectionSlotResponse], errResp azfake.ErrorResponder)

	// DeleteSiteExtension is the fake for method WebAppsClient.DeleteSiteExtension
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteSiteExtension func(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *armappservice.WebAppsClientDeleteSiteExtensionOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSiteExtensionResponse], errResp azfake.ErrorResponder)

	// DeleteSiteExtensionSlot is the fake for method WebAppsClient.DeleteSiteExtensionSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteSiteExtensionSlot func(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *armappservice.WebAppsClientDeleteSiteExtensionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSiteExtensionSlotResponse], errResp azfake.ErrorResponder)

	// DeleteSlot is the fake for method WebAppsClient.DeleteSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientDeleteSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSlotResponse], errResp azfake.ErrorResponder)

	// DeleteSourceControl is the fake for method WebAppsClient.DeleteSourceControl
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	DeleteSourceControl func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientDeleteSourceControlOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSourceControlResponse], errResp azfake.ErrorResponder)

	// DeleteSourceControlSlot is the fake for method WebAppsClient.DeleteSourceControlSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	DeleteSourceControlSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientDeleteSourceControlSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSourceControlSlotResponse], errResp azfake.ErrorResponder)

	// DeleteSwiftVirtualNetwork is the fake for method WebAppsClient.DeleteSwiftVirtualNetwork
	// HTTP status codes to indicate success: http.StatusOK
	DeleteSwiftVirtualNetwork func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientDeleteSwiftVirtualNetworkOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSwiftVirtualNetworkResponse], errResp azfake.ErrorResponder)

	// DeleteSwiftVirtualNetworkSlot is the fake for method WebAppsClient.DeleteSwiftVirtualNetworkSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeleteSwiftVirtualNetworkSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientDeleteSwiftVirtualNetworkSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteSwiftVirtualNetworkSlotResponse], errResp azfake.ErrorResponder)

	// DeleteTriggeredWebJob is the fake for method WebAppsClient.DeleteTriggeredWebJob
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteTriggeredWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientDeleteTriggeredWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteTriggeredWebJobResponse], errResp azfake.ErrorResponder)

	// DeleteTriggeredWebJobSlot is the fake for method WebAppsClient.DeleteTriggeredWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteTriggeredWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientDeleteTriggeredWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteTriggeredWebJobSlotResponse], errResp azfake.ErrorResponder)

	// DeleteVnetConnection is the fake for method WebAppsClient.DeleteVnetConnection
	// HTTP status codes to indicate success: http.StatusOK
	DeleteVnetConnection func(ctx context.Context, resourceGroupName string, name string, vnetName string, options *armappservice.WebAppsClientDeleteVnetConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteVnetConnectionResponse], errResp azfake.ErrorResponder)

	// DeleteVnetConnectionSlot is the fake for method WebAppsClient.DeleteVnetConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeleteVnetConnectionSlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, options *armappservice.WebAppsClientDeleteVnetConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeleteVnetConnectionSlotResponse], errResp azfake.ErrorResponder)

	// DeployWorkflowArtifacts is the fake for method WebAppsClient.DeployWorkflowArtifacts
	// HTTP status codes to indicate success: http.StatusOK
	DeployWorkflowArtifacts func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientDeployWorkflowArtifactsOptions) (resp azfake.Responder[armappservice.WebAppsClientDeployWorkflowArtifactsResponse], errResp azfake.ErrorResponder)

	// DeployWorkflowArtifactsSlot is the fake for method WebAppsClient.DeployWorkflowArtifactsSlot
	// HTTP status codes to indicate success: http.StatusOK
	DeployWorkflowArtifactsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientDeployWorkflowArtifactsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDeployWorkflowArtifactsSlotResponse], errResp azfake.ErrorResponder)

	// DiscoverBackup is the fake for method WebAppsClient.DiscoverBackup
	// HTTP status codes to indicate success: http.StatusOK
	DiscoverBackup func(ctx context.Context, resourceGroupName string, name string, request armappservice.RestoreRequest, options *armappservice.WebAppsClientDiscoverBackupOptions) (resp azfake.Responder[armappservice.WebAppsClientDiscoverBackupResponse], errResp azfake.ErrorResponder)

	// DiscoverBackupSlot is the fake for method WebAppsClient.DiscoverBackupSlot
	// HTTP status codes to indicate success: http.StatusOK
	DiscoverBackupSlot func(ctx context.Context, resourceGroupName string, name string, slot string, request armappservice.RestoreRequest, options *armappservice.WebAppsClientDiscoverBackupSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientDiscoverBackupSlotResponse], errResp azfake.ErrorResponder)

	// GenerateNewSitePublishingPassword is the fake for method WebAppsClient.GenerateNewSitePublishingPassword
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GenerateNewSitePublishingPassword func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGenerateNewSitePublishingPasswordOptions) (resp azfake.Responder[armappservice.WebAppsClientGenerateNewSitePublishingPasswordResponse], errResp azfake.ErrorResponder)

	// GenerateNewSitePublishingPasswordSlot is the fake for method WebAppsClient.GenerateNewSitePublishingPasswordSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GenerateNewSitePublishingPasswordSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGenerateNewSitePublishingPasswordSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGenerateNewSitePublishingPasswordSlotResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WebAppsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetOptions) (resp azfake.Responder[armappservice.WebAppsClientGetResponse], errResp azfake.ErrorResponder)

	// GetAppSettingKeyVaultReference is the fake for method WebAppsClient.GetAppSettingKeyVaultReference
	// HTTP status codes to indicate success: http.StatusOK
	GetAppSettingKeyVaultReference func(ctx context.Context, resourceGroupName string, name string, appSettingKey string, options *armappservice.WebAppsClientGetAppSettingKeyVaultReferenceOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAppSettingKeyVaultReferenceResponse], errResp azfake.ErrorResponder)

	// GetAppSettingKeyVaultReferenceSlot is the fake for method WebAppsClient.GetAppSettingKeyVaultReferenceSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetAppSettingKeyVaultReferenceSlot func(ctx context.Context, resourceGroupName string, name string, appSettingKey string, slot string, options *armappservice.WebAppsClientGetAppSettingKeyVaultReferenceSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse], errResp azfake.ErrorResponder)

	// NewGetAppSettingsKeyVaultReferencesPager is the fake for method WebAppsClient.NewGetAppSettingsKeyVaultReferencesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetAppSettingsKeyVaultReferencesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesResponse])

	// NewGetAppSettingsKeyVaultReferencesSlotPager is the fake for method WebAppsClient.NewGetAppSettingsKeyVaultReferencesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetAppSettingsKeyVaultReferencesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse])

	// GetAuthSettings is the fake for method WebAppsClient.GetAuthSettings
	// HTTP status codes to indicate success: http.StatusOK
	GetAuthSettings func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetAuthSettingsOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAuthSettingsResponse], errResp azfake.ErrorResponder)

	// GetAuthSettingsSlot is the fake for method WebAppsClient.GetAuthSettingsSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetAuthSettingsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetAuthSettingsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAuthSettingsSlotResponse], errResp azfake.ErrorResponder)

	// GetAuthSettingsV2 is the fake for method WebAppsClient.GetAuthSettingsV2
	// HTTP status codes to indicate success: http.StatusOK
	GetAuthSettingsV2 func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetAuthSettingsV2Options) (resp azfake.Responder[armappservice.WebAppsClientGetAuthSettingsV2Response], errResp azfake.ErrorResponder)

	// GetAuthSettingsV2Slot is the fake for method WebAppsClient.GetAuthSettingsV2Slot
	// HTTP status codes to indicate success: http.StatusOK
	GetAuthSettingsV2Slot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetAuthSettingsV2SlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAuthSettingsV2SlotResponse], errResp azfake.ErrorResponder)

	// GetAuthSettingsV2WithoutSecrets is the fake for method WebAppsClient.GetAuthSettingsV2WithoutSecrets
	// HTTP status codes to indicate success: http.StatusOK
	GetAuthSettingsV2WithoutSecrets func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetAuthSettingsV2WithoutSecretsOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAuthSettingsV2WithoutSecretsResponse], errResp azfake.ErrorResponder)

	// GetAuthSettingsV2WithoutSecretsSlot is the fake for method WebAppsClient.GetAuthSettingsV2WithoutSecretsSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetAuthSettingsV2WithoutSecretsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetAuthSettingsV2WithoutSecretsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse], errResp azfake.ErrorResponder)

	// GetBackupConfiguration is the fake for method WebAppsClient.GetBackupConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	GetBackupConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetBackupConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientGetBackupConfigurationResponse], errResp azfake.ErrorResponder)

	// GetBackupConfigurationSlot is the fake for method WebAppsClient.GetBackupConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetBackupConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetBackupConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetBackupConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// GetBackupStatus is the fake for method WebAppsClient.GetBackupStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetBackupStatus func(ctx context.Context, resourceGroupName string, name string, backupID string, options *armappservice.WebAppsClientGetBackupStatusOptions) (resp azfake.Responder[armappservice.WebAppsClientGetBackupStatusResponse], errResp azfake.ErrorResponder)

	// GetBackupStatusSlot is the fake for method WebAppsClient.GetBackupStatusSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetBackupStatusSlot func(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, options *armappservice.WebAppsClientGetBackupStatusSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetBackupStatusSlotResponse], errResp azfake.ErrorResponder)

	// GetConfiguration is the fake for method WebAppsClient.GetConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	GetConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientGetConfigurationResponse], errResp azfake.ErrorResponder)

	// GetConfigurationSlot is the fake for method WebAppsClient.GetConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// GetConfigurationSnapshot is the fake for method WebAppsClient.GetConfigurationSnapshot
	// HTTP status codes to indicate success: http.StatusOK
	GetConfigurationSnapshot func(ctx context.Context, resourceGroupName string, name string, snapshotID string, options *armappservice.WebAppsClientGetConfigurationSnapshotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetConfigurationSnapshotResponse], errResp azfake.ErrorResponder)

	// GetConfigurationSnapshotSlot is the fake for method WebAppsClient.GetConfigurationSnapshotSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetConfigurationSnapshotSlot func(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string, options *armappservice.WebAppsClientGetConfigurationSnapshotSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetConfigurationSnapshotSlotResponse], errResp azfake.ErrorResponder)

	// GetContainerLogsZip is the fake for method WebAppsClient.GetContainerLogsZip
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GetContainerLogsZip func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetContainerLogsZipOptions) (resp azfake.Responder[armappservice.WebAppsClientGetContainerLogsZipResponse], errResp azfake.ErrorResponder)

	// GetContainerLogsZipSlot is the fake for method WebAppsClient.GetContainerLogsZipSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GetContainerLogsZipSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetContainerLogsZipSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetContainerLogsZipSlotResponse], errResp azfake.ErrorResponder)

	// GetContinuousWebJob is the fake for method WebAppsClient.GetContinuousWebJob
	// HTTP status codes to indicate success: http.StatusOK
	GetContinuousWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientGetContinuousWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientGetContinuousWebJobResponse], errResp azfake.ErrorResponder)

	// GetContinuousWebJobSlot is the fake for method WebAppsClient.GetContinuousWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetContinuousWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientGetContinuousWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetContinuousWebJobSlotResponse], errResp azfake.ErrorResponder)

	// GetDeployment is the fake for method WebAppsClient.GetDeployment
	// HTTP status codes to indicate success: http.StatusOK
	GetDeployment func(ctx context.Context, resourceGroupName string, name string, id string, options *armappservice.WebAppsClientGetDeploymentOptions) (resp azfake.Responder[armappservice.WebAppsClientGetDeploymentResponse], errResp azfake.ErrorResponder)

	// GetDeploymentSlot is the fake for method WebAppsClient.GetDeploymentSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetDeploymentSlot func(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *armappservice.WebAppsClientGetDeploymentSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetDeploymentSlotResponse], errResp azfake.ErrorResponder)

	// GetDiagnosticLogsConfiguration is the fake for method WebAppsClient.GetDiagnosticLogsConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	GetDiagnosticLogsConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetDiagnosticLogsConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientGetDiagnosticLogsConfigurationResponse], errResp azfake.ErrorResponder)

	// GetDiagnosticLogsConfigurationSlot is the fake for method WebAppsClient.GetDiagnosticLogsConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetDiagnosticLogsConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetDiagnosticLogsConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetDiagnosticLogsConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// GetDomainOwnershipIdentifier is the fake for method WebAppsClient.GetDomainOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK
	GetDomainOwnershipIdentifier func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, options *armappservice.WebAppsClientGetDomainOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.WebAppsClientGetDomainOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// GetDomainOwnershipIdentifierSlot is the fake for method WebAppsClient.GetDomainOwnershipIdentifierSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetDomainOwnershipIdentifierSlot func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, options *armappservice.WebAppsClientGetDomainOwnershipIdentifierSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetDomainOwnershipIdentifierSlotResponse], errResp azfake.ErrorResponder)

	// GetFtpAllowed is the fake for method WebAppsClient.GetFtpAllowed
	// HTTP status codes to indicate success: http.StatusOK
	GetFtpAllowed func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetFtpAllowedOptions) (resp azfake.Responder[armappservice.WebAppsClientGetFtpAllowedResponse], errResp azfake.ErrorResponder)

	// GetFtpAllowedSlot is the fake for method WebAppsClient.GetFtpAllowedSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetFtpAllowedSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetFtpAllowedSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetFtpAllowedSlotResponse], errResp azfake.ErrorResponder)

	// GetFunction is the fake for method WebAppsClient.GetFunction
	// HTTP status codes to indicate success: http.StatusOK
	GetFunction func(ctx context.Context, resourceGroupName string, name string, functionName string, options *armappservice.WebAppsClientGetFunctionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetFunctionResponse], errResp azfake.ErrorResponder)

	// GetFunctionsAdminToken is the fake for method WebAppsClient.GetFunctionsAdminToken
	// HTTP status codes to indicate success: http.StatusOK
	GetFunctionsAdminToken func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetFunctionsAdminTokenOptions) (resp azfake.Responder[armappservice.WebAppsClientGetFunctionsAdminTokenResponse], errResp azfake.ErrorResponder)

	// GetFunctionsAdminTokenSlot is the fake for method WebAppsClient.GetFunctionsAdminTokenSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetFunctionsAdminTokenSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetFunctionsAdminTokenSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetFunctionsAdminTokenSlotResponse], errResp azfake.ErrorResponder)

	// GetHostNameBinding is the fake for method WebAppsClient.GetHostNameBinding
	// HTTP status codes to indicate success: http.StatusOK
	GetHostNameBinding func(ctx context.Context, resourceGroupName string, name string, hostName string, options *armappservice.WebAppsClientGetHostNameBindingOptions) (resp azfake.Responder[armappservice.WebAppsClientGetHostNameBindingResponse], errResp azfake.ErrorResponder)

	// GetHostNameBindingSlot is the fake for method WebAppsClient.GetHostNameBindingSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetHostNameBindingSlot func(ctx context.Context, resourceGroupName string, name string, slot string, hostName string, options *armappservice.WebAppsClientGetHostNameBindingSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetHostNameBindingSlotResponse], errResp azfake.ErrorResponder)

	// GetHybridConnection is the fake for method WebAppsClient.GetHybridConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetHybridConnection func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *armappservice.WebAppsClientGetHybridConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetHybridConnectionResponse], errResp azfake.ErrorResponder)

	// GetHybridConnectionSlot is the fake for method WebAppsClient.GetHybridConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetHybridConnectionSlot func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, options *armappservice.WebAppsClientGetHybridConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetHybridConnectionSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceFunctionSlot is the fake for method WebAppsClient.GetInstanceFunctionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceFunctionSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *armappservice.WebAppsClientGetInstanceFunctionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceFunctionSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceInfo is the fake for method WebAppsClient.GetInstanceInfo
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceInfo func(ctx context.Context, resourceGroupName string, name string, instanceID string, options *armappservice.WebAppsClientGetInstanceInfoOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceInfoResponse], errResp azfake.ErrorResponder)

	// GetInstanceInfoSlot is the fake for method WebAppsClient.GetInstanceInfoSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceInfoSlot func(ctx context.Context, resourceGroupName string, name string, instanceID string, slot string, options *armappservice.WebAppsClientGetInstanceInfoSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceInfoSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceMSDeployLog is the fake for method WebAppsClient.GetInstanceMSDeployLog
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceMSDeployLog func(ctx context.Context, resourceGroupName string, name string, instanceID string, options *armappservice.WebAppsClientGetInstanceMSDeployLogOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceMSDeployLogResponse], errResp azfake.ErrorResponder)

	// GetInstanceMSDeployLogSlot is the fake for method WebAppsClient.GetInstanceMSDeployLogSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceMSDeployLogSlot func(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *armappservice.WebAppsClientGetInstanceMSDeployLogSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceMSDeployLogSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceMsDeployStatus is the fake for method WebAppsClient.GetInstanceMsDeployStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceMsDeployStatus func(ctx context.Context, resourceGroupName string, name string, instanceID string, options *armappservice.WebAppsClientGetInstanceMsDeployStatusOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceMsDeployStatusResponse], errResp azfake.ErrorResponder)

	// GetInstanceMsDeployStatusSlot is the fake for method WebAppsClient.GetInstanceMsDeployStatusSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceMsDeployStatusSlot func(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *armappservice.WebAppsClientGetInstanceMsDeployStatusSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceMsDeployStatusSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceProcess is the fake for method WebAppsClient.GetInstanceProcess
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceProcess func(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *armappservice.WebAppsClientGetInstanceProcessOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceProcessResponse], errResp azfake.ErrorResponder)

	// GetInstanceProcessDump is the fake for method WebAppsClient.GetInstanceProcessDump
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceProcessDump func(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *armappservice.WebAppsClientGetInstanceProcessDumpOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceProcessDumpResponse], errResp azfake.ErrorResponder)

	// GetInstanceProcessDumpSlot is the fake for method WebAppsClient.GetInstanceProcessDumpSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceProcessDumpSlot func(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *armappservice.WebAppsClientGetInstanceProcessDumpSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceProcessDumpSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceProcessModule is the fake for method WebAppsClient.GetInstanceProcessModule
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceProcessModule func(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string, options *armappservice.WebAppsClientGetInstanceProcessModuleOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceProcessModuleResponse], errResp azfake.ErrorResponder)

	// GetInstanceProcessModuleSlot is the fake for method WebAppsClient.GetInstanceProcessModuleSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceProcessModuleSlot func(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string, options *armappservice.WebAppsClientGetInstanceProcessModuleSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceProcessModuleSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceProcessSlot is the fake for method WebAppsClient.GetInstanceProcessSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceProcessSlot func(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *armappservice.WebAppsClientGetInstanceProcessSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceProcessSlotResponse], errResp azfake.ErrorResponder)

	// GetInstanceWorkflowSlot is the fake for method WebAppsClient.GetInstanceWorkflowSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceWorkflowSlot func(ctx context.Context, resourceGroupName string, name string, slot string, workflowName string, options *armappservice.WebAppsClientGetInstanceWorkflowSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetInstanceWorkflowSlotResponse], errResp azfake.ErrorResponder)

	// GetMSDeployLog is the fake for method WebAppsClient.GetMSDeployLog
	// HTTP status codes to indicate success: http.StatusOK
	GetMSDeployLog func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetMSDeployLogOptions) (resp azfake.Responder[armappservice.WebAppsClientGetMSDeployLogResponse], errResp azfake.ErrorResponder)

	// GetMSDeployLogSlot is the fake for method WebAppsClient.GetMSDeployLogSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetMSDeployLogSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetMSDeployLogSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetMSDeployLogSlotResponse], errResp azfake.ErrorResponder)

	// GetMSDeployStatus is the fake for method WebAppsClient.GetMSDeployStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetMSDeployStatus func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetMSDeployStatusOptions) (resp azfake.Responder[armappservice.WebAppsClientGetMSDeployStatusResponse], errResp azfake.ErrorResponder)

	// GetMSDeployStatusSlot is the fake for method WebAppsClient.GetMSDeployStatusSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetMSDeployStatusSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetMSDeployStatusSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetMSDeployStatusSlotResponse], errResp azfake.ErrorResponder)

	// GetMigrateMySQLStatus is the fake for method WebAppsClient.GetMigrateMySQLStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetMigrateMySQLStatus func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetMigrateMySQLStatusOptions) (resp azfake.Responder[armappservice.WebAppsClientGetMigrateMySQLStatusResponse], errResp azfake.ErrorResponder)

	// GetMigrateMySQLStatusSlot is the fake for method WebAppsClient.GetMigrateMySQLStatusSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetMigrateMySQLStatusSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetMigrateMySQLStatusSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetMigrateMySQLStatusSlotResponse], errResp azfake.ErrorResponder)

	// GetNetworkTraceOperation is the fake for method WebAppsClient.GetNetworkTraceOperation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetNetworkTraceOperation func(ctx context.Context, resourceGroupName string, name string, operationID string, options *armappservice.WebAppsClientGetNetworkTraceOperationOptions) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTraceOperationResponse], errResp azfake.ErrorResponder)

	// GetNetworkTraceOperationSlot is the fake for method WebAppsClient.GetNetworkTraceOperationSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetNetworkTraceOperationSlot func(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *armappservice.WebAppsClientGetNetworkTraceOperationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTraceOperationSlotResponse], errResp azfake.ErrorResponder)

	// GetNetworkTraceOperationSlotV2 is the fake for method WebAppsClient.GetNetworkTraceOperationSlotV2
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetNetworkTraceOperationSlotV2 func(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *armappservice.WebAppsClientGetNetworkTraceOperationSlotV2Options) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTraceOperationSlotV2Response], errResp azfake.ErrorResponder)

	// GetNetworkTraceOperationV2 is the fake for method WebAppsClient.GetNetworkTraceOperationV2
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetNetworkTraceOperationV2 func(ctx context.Context, resourceGroupName string, name string, operationID string, options *armappservice.WebAppsClientGetNetworkTraceOperationV2Options) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTraceOperationV2Response], errResp azfake.ErrorResponder)

	// GetNetworkTraces is the fake for method WebAppsClient.GetNetworkTraces
	// HTTP status codes to indicate success: http.StatusOK
	GetNetworkTraces func(ctx context.Context, resourceGroupName string, name string, operationID string, options *armappservice.WebAppsClientGetNetworkTracesOptions) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTracesResponse], errResp azfake.ErrorResponder)

	// GetNetworkTracesSlot is the fake for method WebAppsClient.GetNetworkTracesSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetNetworkTracesSlot func(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *armappservice.WebAppsClientGetNetworkTracesSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTracesSlotResponse], errResp azfake.ErrorResponder)

	// GetNetworkTracesSlotV2 is the fake for method WebAppsClient.GetNetworkTracesSlotV2
	// HTTP status codes to indicate success: http.StatusOK
	GetNetworkTracesSlotV2 func(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *armappservice.WebAppsClientGetNetworkTracesSlotV2Options) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTracesSlotV2Response], errResp azfake.ErrorResponder)

	// GetNetworkTracesV2 is the fake for method WebAppsClient.GetNetworkTracesV2
	// HTTP status codes to indicate success: http.StatusOK
	GetNetworkTracesV2 func(ctx context.Context, resourceGroupName string, name string, operationID string, options *armappservice.WebAppsClientGetNetworkTracesV2Options) (resp azfake.Responder[armappservice.WebAppsClientGetNetworkTracesV2Response], errResp azfake.ErrorResponder)

	// GetOneDeployStatus is the fake for method WebAppsClient.GetOneDeployStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetOneDeployStatus func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetOneDeployStatusOptions) (resp azfake.Responder[armappservice.WebAppsClientGetOneDeployStatusResponse], errResp azfake.ErrorResponder)

	// GetPremierAddOn is the fake for method WebAppsClient.GetPremierAddOn
	// HTTP status codes to indicate success: http.StatusOK
	GetPremierAddOn func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, options *armappservice.WebAppsClientGetPremierAddOnOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPremierAddOnResponse], errResp azfake.ErrorResponder)

	// GetPremierAddOnSlot is the fake for method WebAppsClient.GetPremierAddOnSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetPremierAddOnSlot func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, options *armappservice.WebAppsClientGetPremierAddOnSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPremierAddOnSlotResponse], errResp azfake.ErrorResponder)

	// GetPrivateAccess is the fake for method WebAppsClient.GetPrivateAccess
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateAccess func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetPrivateAccessOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPrivateAccessResponse], errResp azfake.ErrorResponder)

	// GetPrivateAccessSlot is the fake for method WebAppsClient.GetPrivateAccessSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateAccessSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetPrivateAccessSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPrivateAccessSlotResponse], errResp azfake.ErrorResponder)

	// GetPrivateEndpointConnection is the fake for method WebAppsClient.GetPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *armappservice.WebAppsClientGetPrivateEndpointConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// NewGetPrivateEndpointConnectionListPager is the fake for method WebAppsClient.NewGetPrivateEndpointConnectionListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetPrivateEndpointConnectionListPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientGetPrivateEndpointConnectionListOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientGetPrivateEndpointConnectionListResponse])

	// NewGetPrivateEndpointConnectionListSlotPager is the fake for method WebAppsClient.NewGetPrivateEndpointConnectionListSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetPrivateEndpointConnectionListSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetPrivateEndpointConnectionListSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientGetPrivateEndpointConnectionListSlotResponse])

	// GetPrivateEndpointConnectionSlot is the fake for method WebAppsClient.GetPrivateEndpointConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateEndpointConnectionSlot func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *armappservice.WebAppsClientGetPrivateEndpointConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPrivateEndpointConnectionSlotResponse], errResp azfake.ErrorResponder)

	// GetPrivateLinkResources is the fake for method WebAppsClient.GetPrivateLinkResources
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateLinkResources func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetPrivateLinkResourcesOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPrivateLinkResourcesResponse], errResp azfake.ErrorResponder)

	// GetPrivateLinkResourcesSlot is the fake for method WebAppsClient.GetPrivateLinkResourcesSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateLinkResourcesSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetPrivateLinkResourcesSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPrivateLinkResourcesSlotResponse], errResp azfake.ErrorResponder)

	// GetProcess is the fake for method WebAppsClient.GetProcess
	// HTTP status codes to indicate success: http.StatusOK
	GetProcess func(ctx context.Context, resourceGroupName string, name string, processID string, options *armappservice.WebAppsClientGetProcessOptions) (resp azfake.Responder[armappservice.WebAppsClientGetProcessResponse], errResp azfake.ErrorResponder)

	// GetProcessDump is the fake for method WebAppsClient.GetProcessDump
	// HTTP status codes to indicate success: http.StatusOK
	GetProcessDump func(ctx context.Context, resourceGroupName string, name string, processID string, options *armappservice.WebAppsClientGetProcessDumpOptions) (resp azfake.Responder[armappservice.WebAppsClientGetProcessDumpResponse], errResp azfake.ErrorResponder)

	// GetProcessDumpSlot is the fake for method WebAppsClient.GetProcessDumpSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetProcessDumpSlot func(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *armappservice.WebAppsClientGetProcessDumpSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetProcessDumpSlotResponse], errResp azfake.ErrorResponder)

	// GetProcessModule is the fake for method WebAppsClient.GetProcessModule
	// HTTP status codes to indicate success: http.StatusOK
	GetProcessModule func(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, options *armappservice.WebAppsClientGetProcessModuleOptions) (resp azfake.Responder[armappservice.WebAppsClientGetProcessModuleResponse], errResp azfake.ErrorResponder)

	// GetProcessModuleSlot is the fake for method WebAppsClient.GetProcessModuleSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetProcessModuleSlot func(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, options *armappservice.WebAppsClientGetProcessModuleSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetProcessModuleSlotResponse], errResp azfake.ErrorResponder)

	// GetProcessSlot is the fake for method WebAppsClient.GetProcessSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetProcessSlot func(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *armappservice.WebAppsClientGetProcessSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetProcessSlotResponse], errResp azfake.ErrorResponder)

	// BeginGetProductionSiteDeploymentStatus is the fake for method WebAppsClient.BeginGetProductionSiteDeploymentStatus
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetProductionSiteDeploymentStatus func(ctx context.Context, resourceGroupName string, name string, deploymentStatusID string, options *armappservice.WebAppsClientBeginGetProductionSiteDeploymentStatusOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientGetProductionSiteDeploymentStatusResponse], errResp azfake.ErrorResponder)

	// GetPublicCertificate is the fake for method WebAppsClient.GetPublicCertificate
	// HTTP status codes to indicate success: http.StatusOK
	GetPublicCertificate func(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, options *armappservice.WebAppsClientGetPublicCertificateOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPublicCertificateResponse], errResp azfake.ErrorResponder)

	// GetPublicCertificateSlot is the fake for method WebAppsClient.GetPublicCertificateSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetPublicCertificateSlot func(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string, options *armappservice.WebAppsClientGetPublicCertificateSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetPublicCertificateSlotResponse], errResp azfake.ErrorResponder)

	// GetRelayServiceConnection is the fake for method WebAppsClient.GetRelayServiceConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetRelayServiceConnection func(ctx context.Context, resourceGroupName string, name string, entityName string, options *armappservice.WebAppsClientGetRelayServiceConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetRelayServiceConnectionResponse], errResp azfake.ErrorResponder)

	// GetRelayServiceConnectionSlot is the fake for method WebAppsClient.GetRelayServiceConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetRelayServiceConnectionSlot func(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, options *armappservice.WebAppsClientGetRelayServiceConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetRelayServiceConnectionSlotResponse], errResp azfake.ErrorResponder)

	// GetScmAllowed is the fake for method WebAppsClient.GetScmAllowed
	// HTTP status codes to indicate success: http.StatusOK
	GetScmAllowed func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetScmAllowedOptions) (resp azfake.Responder[armappservice.WebAppsClientGetScmAllowedResponse], errResp azfake.ErrorResponder)

	// GetScmAllowedSlot is the fake for method WebAppsClient.GetScmAllowedSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetScmAllowedSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetScmAllowedSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetScmAllowedSlotResponse], errResp azfake.ErrorResponder)

	// GetSiteConnectionStringKeyVaultReference is the fake for method WebAppsClient.GetSiteConnectionStringKeyVaultReference
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteConnectionStringKeyVaultReference func(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, options *armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferenceOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse], errResp azfake.ErrorResponder)

	// GetSiteConnectionStringKeyVaultReferenceSlot is the fake for method WebAppsClient.GetSiteConnectionStringKeyVaultReferenceSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteConnectionStringKeyVaultReferenceSlot func(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, slot string, options *armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse], errResp azfake.ErrorResponder)

	// NewGetSiteConnectionStringKeyVaultReferencesPager is the fake for method WebAppsClient.NewGetSiteConnectionStringKeyVaultReferencesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetSiteConnectionStringKeyVaultReferencesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse])

	// NewGetSiteConnectionStringKeyVaultReferencesSlotPager is the fake for method WebAppsClient.NewGetSiteConnectionStringKeyVaultReferencesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetSiteConnectionStringKeyVaultReferencesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse])

	// GetSiteExtension is the fake for method WebAppsClient.GetSiteExtension
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteExtension func(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *armappservice.WebAppsClientGetSiteExtensionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSiteExtensionResponse], errResp azfake.ErrorResponder)

	// GetSiteExtensionSlot is the fake for method WebAppsClient.GetSiteExtensionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteExtensionSlot func(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *armappservice.WebAppsClientGetSiteExtensionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSiteExtensionSlotResponse], errResp azfake.ErrorResponder)

	// GetSitePhpErrorLogFlag is the fake for method WebAppsClient.GetSitePhpErrorLogFlag
	// HTTP status codes to indicate success: http.StatusOK
	GetSitePhpErrorLogFlag func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetSitePhpErrorLogFlagOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSitePhpErrorLogFlagResponse], errResp azfake.ErrorResponder)

	// GetSitePhpErrorLogFlagSlot is the fake for method WebAppsClient.GetSitePhpErrorLogFlagSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSitePhpErrorLogFlagSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetSitePhpErrorLogFlagSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSitePhpErrorLogFlagSlotResponse], errResp azfake.ErrorResponder)

	// GetSlot is the fake for method WebAppsClient.GetSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSlotResponse], errResp azfake.ErrorResponder)

	// BeginGetSlotSiteDeploymentStatusSlot is the fake for method WebAppsClient.BeginGetSlotSiteDeploymentStatusSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetSlotSiteDeploymentStatusSlot func(ctx context.Context, resourceGroupName string, name string, slot string, deploymentStatusID string, options *armappservice.WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientGetSlotSiteDeploymentStatusSlotResponse], errResp azfake.ErrorResponder)

	// GetSourceControl is the fake for method WebAppsClient.GetSourceControl
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	GetSourceControl func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetSourceControlOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSourceControlResponse], errResp azfake.ErrorResponder)

	// GetSourceControlSlot is the fake for method WebAppsClient.GetSourceControlSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	GetSourceControlSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetSourceControlSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSourceControlSlotResponse], errResp azfake.ErrorResponder)

	// GetSwiftVirtualNetworkConnection is the fake for method WebAppsClient.GetSwiftVirtualNetworkConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetSwiftVirtualNetworkConnection func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetSwiftVirtualNetworkConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSwiftVirtualNetworkConnectionResponse], errResp azfake.ErrorResponder)

	// GetSwiftVirtualNetworkConnectionSlot is the fake for method WebAppsClient.GetSwiftVirtualNetworkConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSwiftVirtualNetworkConnectionSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse], errResp azfake.ErrorResponder)

	// GetTriggeredWebJob is the fake for method WebAppsClient.GetTriggeredWebJob
	// HTTP status codes to indicate success: http.StatusOK
	GetTriggeredWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientGetTriggeredWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientGetTriggeredWebJobResponse], errResp azfake.ErrorResponder)

	// GetTriggeredWebJobHistory is the fake for method WebAppsClient.GetTriggeredWebJobHistory
	// HTTP status codes to indicate success: http.StatusOK
	GetTriggeredWebJobHistory func(ctx context.Context, resourceGroupName string, name string, webJobName string, id string, options *armappservice.WebAppsClientGetTriggeredWebJobHistoryOptions) (resp azfake.Responder[armappservice.WebAppsClientGetTriggeredWebJobHistoryResponse], errResp azfake.ErrorResponder)

	// GetTriggeredWebJobHistorySlot is the fake for method WebAppsClient.GetTriggeredWebJobHistorySlot
	// HTTP status codes to indicate success: http.StatusOK
	GetTriggeredWebJobHistorySlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, id string, slot string, options *armappservice.WebAppsClientGetTriggeredWebJobHistorySlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetTriggeredWebJobHistorySlotResponse], errResp azfake.ErrorResponder)

	// GetTriggeredWebJobSlot is the fake for method WebAppsClient.GetTriggeredWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetTriggeredWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientGetTriggeredWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetTriggeredWebJobSlotResponse], errResp azfake.ErrorResponder)

	// GetVnetConnection is the fake for method WebAppsClient.GetVnetConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetVnetConnection func(ctx context.Context, resourceGroupName string, name string, vnetName string, options *armappservice.WebAppsClientGetVnetConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientGetVnetConnectionResponse], errResp azfake.ErrorResponder)

	// GetVnetConnectionGateway is the fake for method WebAppsClient.GetVnetConnectionGateway
	// HTTP status codes to indicate success: http.StatusOK
	GetVnetConnectionGateway func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, options *armappservice.WebAppsClientGetVnetConnectionGatewayOptions) (resp azfake.Responder[armappservice.WebAppsClientGetVnetConnectionGatewayResponse], errResp azfake.ErrorResponder)

	// GetVnetConnectionGatewaySlot is the fake for method WebAppsClient.GetVnetConnectionGatewaySlot
	// HTTP status codes to indicate success: http.StatusOK
	GetVnetConnectionGatewaySlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, options *armappservice.WebAppsClientGetVnetConnectionGatewaySlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetVnetConnectionGatewaySlotResponse], errResp azfake.ErrorResponder)

	// GetVnetConnectionSlot is the fake for method WebAppsClient.GetVnetConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetVnetConnectionSlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, options *armappservice.WebAppsClientGetVnetConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetVnetConnectionSlotResponse], errResp azfake.ErrorResponder)

	// GetWebJob is the fake for method WebAppsClient.GetWebJob
	// HTTP status codes to indicate success: http.StatusOK
	GetWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientGetWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientGetWebJobResponse], errResp azfake.ErrorResponder)

	// GetWebJobSlot is the fake for method WebAppsClient.GetWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientGetWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetWebJobSlotResponse], errResp azfake.ErrorResponder)

	// GetWebSiteContainerLogs is the fake for method WebAppsClient.GetWebSiteContainerLogs
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GetWebSiteContainerLogs func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientGetWebSiteContainerLogsOptions) (resp azfake.Responder[armappservice.WebAppsClientGetWebSiteContainerLogsResponse], errResp azfake.ErrorResponder)

	// GetWebSiteContainerLogsSlot is the fake for method WebAppsClient.GetWebSiteContainerLogsSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GetWebSiteContainerLogsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientGetWebSiteContainerLogsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientGetWebSiteContainerLogsSlotResponse], errResp azfake.ErrorResponder)

	// GetWorkflow is the fake for method WebAppsClient.GetWorkflow
	// HTTP status codes to indicate success: http.StatusOK
	GetWorkflow func(ctx context.Context, resourceGroupName string, name string, workflowName string, options *armappservice.WebAppsClientGetWorkflowOptions) (resp azfake.Responder[armappservice.WebAppsClientGetWorkflowResponse], errResp azfake.ErrorResponder)

	// BeginInstallSiteExtension is the fake for method WebAppsClient.BeginInstallSiteExtension
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginInstallSiteExtension func(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *armappservice.WebAppsClientBeginInstallSiteExtensionOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientInstallSiteExtensionResponse], errResp azfake.ErrorResponder)

	// BeginInstallSiteExtensionSlot is the fake for method WebAppsClient.BeginInstallSiteExtensionSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginInstallSiteExtensionSlot func(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *armappservice.WebAppsClientBeginInstallSiteExtensionSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientInstallSiteExtensionSlotResponse], errResp azfake.ErrorResponder)

	// IsCloneable is the fake for method WebAppsClient.IsCloneable
	// HTTP status codes to indicate success: http.StatusOK
	IsCloneable func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientIsCloneableOptions) (resp azfake.Responder[armappservice.WebAppsClientIsCloneableResponse], errResp azfake.ErrorResponder)

	// IsCloneableSlot is the fake for method WebAppsClient.IsCloneableSlot
	// HTTP status codes to indicate success: http.StatusOK
	IsCloneableSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientIsCloneableSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientIsCloneableSlotResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WebAppsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.WebAppsClientListOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListResponse])

	// ListApplicationSettings is the fake for method WebAppsClient.ListApplicationSettings
	// HTTP status codes to indicate success: http.StatusOK
	ListApplicationSettings func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListApplicationSettingsOptions) (resp azfake.Responder[armappservice.WebAppsClientListApplicationSettingsResponse], errResp azfake.ErrorResponder)

	// ListApplicationSettingsSlot is the fake for method WebAppsClient.ListApplicationSettingsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListApplicationSettingsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListApplicationSettingsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListApplicationSettingsSlotResponse], errResp azfake.ErrorResponder)

	// ListAzureStorageAccounts is the fake for method WebAppsClient.ListAzureStorageAccounts
	// HTTP status codes to indicate success: http.StatusOK
	ListAzureStorageAccounts func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListAzureStorageAccountsOptions) (resp azfake.Responder[armappservice.WebAppsClientListAzureStorageAccountsResponse], errResp azfake.ErrorResponder)

	// ListAzureStorageAccountsSlot is the fake for method WebAppsClient.ListAzureStorageAccountsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListAzureStorageAccountsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListAzureStorageAccountsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListAzureStorageAccountsSlotResponse], errResp azfake.ErrorResponder)

	// ListBackupStatusSecrets is the fake for method WebAppsClient.ListBackupStatusSecrets
	// HTTP status codes to indicate success: http.StatusOK
	ListBackupStatusSecrets func(ctx context.Context, resourceGroupName string, name string, backupID string, request armappservice.BackupRequest, options *armappservice.WebAppsClientListBackupStatusSecretsOptions) (resp azfake.Responder[armappservice.WebAppsClientListBackupStatusSecretsResponse], errResp azfake.ErrorResponder)

	// ListBackupStatusSecretsSlot is the fake for method WebAppsClient.ListBackupStatusSecretsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListBackupStatusSecretsSlot func(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, request armappservice.BackupRequest, options *armappservice.WebAppsClientListBackupStatusSecretsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListBackupStatusSecretsSlotResponse], errResp azfake.ErrorResponder)

	// NewListBackupsPager is the fake for method WebAppsClient.NewListBackupsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBackupsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListBackupsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListBackupsResponse])

	// NewListBackupsSlotPager is the fake for method WebAppsClient.NewListBackupsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBackupsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListBackupsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListBackupsSlotResponse])

	// NewListBasicPublishingCredentialsPoliciesPager is the fake for method WebAppsClient.NewListBasicPublishingCredentialsPoliciesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBasicPublishingCredentialsPoliciesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesResponse])

	// NewListBasicPublishingCredentialsPoliciesSlotPager is the fake for method WebAppsClient.NewListBasicPublishingCredentialsPoliciesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBasicPublishingCredentialsPoliciesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse])

	// NewListByResourceGroupPager is the fake for method WebAppsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armappservice.WebAppsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListByResourceGroupResponse])

	// NewListConfigurationSnapshotInfoPager is the fake for method WebAppsClient.NewListConfigurationSnapshotInfoPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConfigurationSnapshotInfoPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListConfigurationSnapshotInfoOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListConfigurationSnapshotInfoResponse])

	// NewListConfigurationSnapshotInfoSlotPager is the fake for method WebAppsClient.NewListConfigurationSnapshotInfoSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConfigurationSnapshotInfoSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListConfigurationSnapshotInfoSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListConfigurationSnapshotInfoSlotResponse])

	// NewListConfigurationsPager is the fake for method WebAppsClient.NewListConfigurationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConfigurationsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListConfigurationsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListConfigurationsResponse])

	// NewListConfigurationsSlotPager is the fake for method WebAppsClient.NewListConfigurationsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConfigurationsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListConfigurationsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListConfigurationsSlotResponse])

	// ListConnectionStrings is the fake for method WebAppsClient.ListConnectionStrings
	// HTTP status codes to indicate success: http.StatusOK
	ListConnectionStrings func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListConnectionStringsOptions) (resp azfake.Responder[armappservice.WebAppsClientListConnectionStringsResponse], errResp azfake.ErrorResponder)

	// ListConnectionStringsSlot is the fake for method WebAppsClient.ListConnectionStringsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListConnectionStringsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListConnectionStringsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListConnectionStringsSlotResponse], errResp azfake.ErrorResponder)

	// NewListContinuousWebJobsPager is the fake for method WebAppsClient.NewListContinuousWebJobsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListContinuousWebJobsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListContinuousWebJobsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListContinuousWebJobsResponse])

	// NewListContinuousWebJobsSlotPager is the fake for method WebAppsClient.NewListContinuousWebJobsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListContinuousWebJobsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListContinuousWebJobsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListContinuousWebJobsSlotResponse])

	// ListDeploymentLog is the fake for method WebAppsClient.ListDeploymentLog
	// HTTP status codes to indicate success: http.StatusOK
	ListDeploymentLog func(ctx context.Context, resourceGroupName string, name string, id string, options *armappservice.WebAppsClientListDeploymentLogOptions) (resp azfake.Responder[armappservice.WebAppsClientListDeploymentLogResponse], errResp azfake.ErrorResponder)

	// ListDeploymentLogSlot is the fake for method WebAppsClient.ListDeploymentLogSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListDeploymentLogSlot func(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *armappservice.WebAppsClientListDeploymentLogSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListDeploymentLogSlotResponse], errResp azfake.ErrorResponder)

	// NewListDeploymentsPager is the fake for method WebAppsClient.NewListDeploymentsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeploymentsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListDeploymentsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListDeploymentsResponse])

	// NewListDeploymentsSlotPager is the fake for method WebAppsClient.NewListDeploymentsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeploymentsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListDeploymentsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListDeploymentsSlotResponse])

	// NewListDomainOwnershipIdentifiersPager is the fake for method WebAppsClient.NewListDomainOwnershipIdentifiersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDomainOwnershipIdentifiersPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListDomainOwnershipIdentifiersOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListDomainOwnershipIdentifiersResponse])

	// NewListDomainOwnershipIdentifiersSlotPager is the fake for method WebAppsClient.NewListDomainOwnershipIdentifiersSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDomainOwnershipIdentifiersSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListDomainOwnershipIdentifiersSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListDomainOwnershipIdentifiersSlotResponse])

	// ListFunctionKeys is the fake for method WebAppsClient.ListFunctionKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListFunctionKeys func(ctx context.Context, resourceGroupName string, name string, functionName string, options *armappservice.WebAppsClientListFunctionKeysOptions) (resp azfake.Responder[armappservice.WebAppsClientListFunctionKeysResponse], errResp azfake.ErrorResponder)

	// ListFunctionKeysSlot is the fake for method WebAppsClient.ListFunctionKeysSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListFunctionKeysSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *armappservice.WebAppsClientListFunctionKeysSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListFunctionKeysSlotResponse], errResp azfake.ErrorResponder)

	// ListFunctionSecrets is the fake for method WebAppsClient.ListFunctionSecrets
	// HTTP status codes to indicate success: http.StatusOK
	ListFunctionSecrets func(ctx context.Context, resourceGroupName string, name string, functionName string, options *armappservice.WebAppsClientListFunctionSecretsOptions) (resp azfake.Responder[armappservice.WebAppsClientListFunctionSecretsResponse], errResp azfake.ErrorResponder)

	// ListFunctionSecretsSlot is the fake for method WebAppsClient.ListFunctionSecretsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListFunctionSecretsSlot func(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *armappservice.WebAppsClientListFunctionSecretsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListFunctionSecretsSlotResponse], errResp azfake.ErrorResponder)

	// NewListFunctionsPager is the fake for method WebAppsClient.NewListFunctionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFunctionsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListFunctionsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListFunctionsResponse])

	// ListHostKeys is the fake for method WebAppsClient.ListHostKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListHostKeys func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListHostKeysOptions) (resp azfake.Responder[armappservice.WebAppsClientListHostKeysResponse], errResp azfake.ErrorResponder)

	// ListHostKeysSlot is the fake for method WebAppsClient.ListHostKeysSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListHostKeysSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListHostKeysSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListHostKeysSlotResponse], errResp azfake.ErrorResponder)

	// NewListHostNameBindingsPager is the fake for method WebAppsClient.NewListHostNameBindingsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHostNameBindingsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListHostNameBindingsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListHostNameBindingsResponse])

	// NewListHostNameBindingsSlotPager is the fake for method WebAppsClient.NewListHostNameBindingsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHostNameBindingsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListHostNameBindingsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListHostNameBindingsSlotResponse])

	// ListHybridConnections is the fake for method WebAppsClient.ListHybridConnections
	// HTTP status codes to indicate success: http.StatusOK
	ListHybridConnections func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListHybridConnectionsOptions) (resp azfake.Responder[armappservice.WebAppsClientListHybridConnectionsResponse], errResp azfake.ErrorResponder)

	// ListHybridConnectionsSlot is the fake for method WebAppsClient.ListHybridConnectionsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListHybridConnectionsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListHybridConnectionsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListHybridConnectionsSlotResponse], errResp azfake.ErrorResponder)

	// NewListInstanceFunctionsSlotPager is the fake for method WebAppsClient.NewListInstanceFunctionsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceFunctionsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListInstanceFunctionsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceFunctionsSlotResponse])

	// NewListInstanceIdentifiersPager is the fake for method WebAppsClient.NewListInstanceIdentifiersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceIdentifiersPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListInstanceIdentifiersOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceIdentifiersResponse])

	// NewListInstanceIdentifiersSlotPager is the fake for method WebAppsClient.NewListInstanceIdentifiersSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceIdentifiersSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListInstanceIdentifiersSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceIdentifiersSlotResponse])

	// NewListInstanceProcessModulesPager is the fake for method WebAppsClient.NewListInstanceProcessModulesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceProcessModulesPager func(resourceGroupName string, name string, processID string, instanceID string, options *armappservice.WebAppsClientListInstanceProcessModulesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessModulesResponse])

	// NewListInstanceProcessModulesSlotPager is the fake for method WebAppsClient.NewListInstanceProcessModulesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceProcessModulesSlotPager func(resourceGroupName string, name string, processID string, slot string, instanceID string, options *armappservice.WebAppsClientListInstanceProcessModulesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessModulesSlotResponse])

	// NewListInstanceProcessThreadsPager is the fake for method WebAppsClient.NewListInstanceProcessThreadsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceProcessThreadsPager func(resourceGroupName string, name string, processID string, instanceID string, options *armappservice.WebAppsClientListInstanceProcessThreadsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessThreadsResponse])

	// NewListInstanceProcessThreadsSlotPager is the fake for method WebAppsClient.NewListInstanceProcessThreadsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceProcessThreadsSlotPager func(resourceGroupName string, name string, processID string, slot string, instanceID string, options *armappservice.WebAppsClientListInstanceProcessThreadsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessThreadsSlotResponse])

	// NewListInstanceProcessesPager is the fake for method WebAppsClient.NewListInstanceProcessesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceProcessesPager func(resourceGroupName string, name string, instanceID string, options *armappservice.WebAppsClientListInstanceProcessesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessesResponse])

	// NewListInstanceProcessesSlotPager is the fake for method WebAppsClient.NewListInstanceProcessesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceProcessesSlotPager func(resourceGroupName string, name string, slot string, instanceID string, options *armappservice.WebAppsClientListInstanceProcessesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessesSlotResponse])

	// NewListInstanceWorkflowsSlotPager is the fake for method WebAppsClient.NewListInstanceWorkflowsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceWorkflowsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListInstanceWorkflowsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListInstanceWorkflowsSlotResponse])

	// ListMetadata is the fake for method WebAppsClient.ListMetadata
	// HTTP status codes to indicate success: http.StatusOK
	ListMetadata func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListMetadataOptions) (resp azfake.Responder[armappservice.WebAppsClientListMetadataResponse], errResp azfake.ErrorResponder)

	// ListMetadataSlot is the fake for method WebAppsClient.ListMetadataSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListMetadataSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListMetadataSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListMetadataSlotResponse], errResp azfake.ErrorResponder)

	// ListNetworkFeatures is the fake for method WebAppsClient.ListNetworkFeatures
	// HTTP status codes to indicate success: http.StatusOK
	ListNetworkFeatures func(ctx context.Context, resourceGroupName string, name string, view string, options *armappservice.WebAppsClientListNetworkFeaturesOptions) (resp azfake.Responder[armappservice.WebAppsClientListNetworkFeaturesResponse], errResp azfake.ErrorResponder)

	// ListNetworkFeaturesSlot is the fake for method WebAppsClient.ListNetworkFeaturesSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListNetworkFeaturesSlot func(ctx context.Context, resourceGroupName string, name string, view string, slot string, options *armappservice.WebAppsClientListNetworkFeaturesSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListNetworkFeaturesSlotResponse], errResp azfake.ErrorResponder)

	// NewListPerfMonCountersPager is the fake for method WebAppsClient.NewListPerfMonCountersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPerfMonCountersPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListPerfMonCountersOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListPerfMonCountersResponse])

	// NewListPerfMonCountersSlotPager is the fake for method WebAppsClient.NewListPerfMonCountersSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPerfMonCountersSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListPerfMonCountersSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListPerfMonCountersSlotResponse])

	// ListPremierAddOns is the fake for method WebAppsClient.ListPremierAddOns
	// HTTP status codes to indicate success: http.StatusOK
	ListPremierAddOns func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListPremierAddOnsOptions) (resp azfake.Responder[armappservice.WebAppsClientListPremierAddOnsResponse], errResp azfake.ErrorResponder)

	// ListPremierAddOnsSlot is the fake for method WebAppsClient.ListPremierAddOnsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListPremierAddOnsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListPremierAddOnsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListPremierAddOnsSlotResponse], errResp azfake.ErrorResponder)

	// NewListProcessModulesPager is the fake for method WebAppsClient.NewListProcessModulesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProcessModulesPager func(resourceGroupName string, name string, processID string, options *armappservice.WebAppsClientListProcessModulesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProcessModulesResponse])

	// NewListProcessModulesSlotPager is the fake for method WebAppsClient.NewListProcessModulesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProcessModulesSlotPager func(resourceGroupName string, name string, processID string, slot string, options *armappservice.WebAppsClientListProcessModulesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProcessModulesSlotResponse])

	// NewListProcessThreadsPager is the fake for method WebAppsClient.NewListProcessThreadsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProcessThreadsPager func(resourceGroupName string, name string, processID string, options *armappservice.WebAppsClientListProcessThreadsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProcessThreadsResponse])

	// NewListProcessThreadsSlotPager is the fake for method WebAppsClient.NewListProcessThreadsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProcessThreadsSlotPager func(resourceGroupName string, name string, processID string, slot string, options *armappservice.WebAppsClientListProcessThreadsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProcessThreadsSlotResponse])

	// NewListProcessesPager is the fake for method WebAppsClient.NewListProcessesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProcessesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListProcessesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProcessesResponse])

	// NewListProcessesSlotPager is the fake for method WebAppsClient.NewListProcessesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProcessesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListProcessesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProcessesSlotResponse])

	// NewListProductionSiteDeploymentStatusesPager is the fake for method WebAppsClient.NewListProductionSiteDeploymentStatusesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProductionSiteDeploymentStatusesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListProductionSiteDeploymentStatusesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListProductionSiteDeploymentStatusesResponse])

	// NewListPublicCertificatesPager is the fake for method WebAppsClient.NewListPublicCertificatesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPublicCertificatesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListPublicCertificatesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListPublicCertificatesResponse])

	// NewListPublicCertificatesSlotPager is the fake for method WebAppsClient.NewListPublicCertificatesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPublicCertificatesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListPublicCertificatesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListPublicCertificatesSlotResponse])

	// BeginListPublishingCredentials is the fake for method WebAppsClient.BeginListPublishingCredentials
	// HTTP status codes to indicate success: http.StatusOK
	BeginListPublishingCredentials func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientBeginListPublishingCredentialsOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientListPublishingCredentialsResponse], errResp azfake.ErrorResponder)

	// BeginListPublishingCredentialsSlot is the fake for method WebAppsClient.BeginListPublishingCredentialsSlot
	// HTTP status codes to indicate success: http.StatusOK
	BeginListPublishingCredentialsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientBeginListPublishingCredentialsSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientListPublishingCredentialsSlotResponse], errResp azfake.ErrorResponder)

	// ListPublishingProfileXMLWithSecrets is the fake for method WebAppsClient.ListPublishingProfileXMLWithSecrets
	// HTTP status codes to indicate success: http.StatusOK
	ListPublishingProfileXMLWithSecrets func(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions armappservice.CsmPublishingProfileOptions, options *armappservice.WebAppsClientListPublishingProfileXMLWithSecretsOptions) (resp azfake.Responder[armappservice.WebAppsClientListPublishingProfileXMLWithSecretsResponse], errResp azfake.ErrorResponder)

	// ListPublishingProfileXMLWithSecretsSlot is the fake for method WebAppsClient.ListPublishingProfileXMLWithSecretsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListPublishingProfileXMLWithSecretsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, publishingProfileOptions armappservice.CsmPublishingProfileOptions, options *armappservice.WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse], errResp azfake.ErrorResponder)

	// ListRelayServiceConnections is the fake for method WebAppsClient.ListRelayServiceConnections
	// HTTP status codes to indicate success: http.StatusOK
	ListRelayServiceConnections func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListRelayServiceConnectionsOptions) (resp azfake.Responder[armappservice.WebAppsClientListRelayServiceConnectionsResponse], errResp azfake.ErrorResponder)

	// ListRelayServiceConnectionsSlot is the fake for method WebAppsClient.ListRelayServiceConnectionsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListRelayServiceConnectionsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListRelayServiceConnectionsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListRelayServiceConnectionsSlotResponse], errResp azfake.ErrorResponder)

	// NewListSiteBackupsPager is the fake for method WebAppsClient.NewListSiteBackupsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteBackupsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListSiteBackupsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSiteBackupsResponse])

	// NewListSiteBackupsSlotPager is the fake for method WebAppsClient.NewListSiteBackupsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteBackupsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSiteBackupsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSiteBackupsSlotResponse])

	// NewListSiteExtensionsPager is the fake for method WebAppsClient.NewListSiteExtensionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteExtensionsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListSiteExtensionsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSiteExtensionsResponse])

	// NewListSiteExtensionsSlotPager is the fake for method WebAppsClient.NewListSiteExtensionsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteExtensionsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSiteExtensionsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSiteExtensionsSlotResponse])

	// ListSitePushSettings is the fake for method WebAppsClient.ListSitePushSettings
	// HTTP status codes to indicate success: http.StatusOK
	ListSitePushSettings func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListSitePushSettingsOptions) (resp azfake.Responder[armappservice.WebAppsClientListSitePushSettingsResponse], errResp azfake.ErrorResponder)

	// ListSitePushSettingsSlot is the fake for method WebAppsClient.ListSitePushSettingsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListSitePushSettingsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSitePushSettingsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListSitePushSettingsSlotResponse], errResp azfake.ErrorResponder)

	// ListSlotConfigurationNames is the fake for method WebAppsClient.ListSlotConfigurationNames
	// HTTP status codes to indicate success: http.StatusOK
	ListSlotConfigurationNames func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListSlotConfigurationNamesOptions) (resp azfake.Responder[armappservice.WebAppsClientListSlotConfigurationNamesResponse], errResp azfake.ErrorResponder)

	// NewListSlotDifferencesFromProductionPager is the fake for method WebAppsClient.NewListSlotDifferencesFromProductionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSlotDifferencesFromProductionPager func(resourceGroupName string, name string, slotSwapEntity armappservice.CsmSlotEntity, options *armappservice.WebAppsClientListSlotDifferencesFromProductionOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSlotDifferencesFromProductionResponse])

	// NewListSlotDifferencesSlotPager is the fake for method WebAppsClient.NewListSlotDifferencesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSlotDifferencesSlotPager func(resourceGroupName string, name string, slot string, slotSwapEntity armappservice.CsmSlotEntity, options *armappservice.WebAppsClientListSlotDifferencesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSlotDifferencesSlotResponse])

	// NewListSlotSiteDeploymentStatusesSlotPager is the fake for method WebAppsClient.NewListSlotSiteDeploymentStatusesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSlotSiteDeploymentStatusesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSlotSiteDeploymentStatusesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSlotSiteDeploymentStatusesSlotResponse])

	// NewListSlotsPager is the fake for method WebAppsClient.NewListSlotsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSlotsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListSlotsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSlotsResponse])

	// NewListSnapshotsPager is the fake for method WebAppsClient.NewListSnapshotsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSnapshotsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListSnapshotsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsResponse])

	// NewListSnapshotsFromDRSecondaryPager is the fake for method WebAppsClient.NewListSnapshotsFromDRSecondaryPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSnapshotsFromDRSecondaryPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListSnapshotsFromDRSecondaryOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsFromDRSecondaryResponse])

	// NewListSnapshotsFromDRSecondarySlotPager is the fake for method WebAppsClient.NewListSnapshotsFromDRSecondarySlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSnapshotsFromDRSecondarySlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSnapshotsFromDRSecondarySlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsFromDRSecondarySlotResponse])

	// NewListSnapshotsSlotPager is the fake for method WebAppsClient.NewListSnapshotsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSnapshotsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSnapshotsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsSlotResponse])

	// ListSyncFunctionTriggers is the fake for method WebAppsClient.ListSyncFunctionTriggers
	// HTTP status codes to indicate success: http.StatusOK
	ListSyncFunctionTriggers func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListSyncFunctionTriggersOptions) (resp azfake.Responder[armappservice.WebAppsClientListSyncFunctionTriggersResponse], errResp azfake.ErrorResponder)

	// ListSyncFunctionTriggersSlot is the fake for method WebAppsClient.ListSyncFunctionTriggersSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListSyncFunctionTriggersSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSyncFunctionTriggersSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListSyncFunctionTriggersSlotResponse], errResp azfake.ErrorResponder)

	// ListSyncStatus is the fake for method WebAppsClient.ListSyncStatus
	// HTTP status codes to indicate success: http.StatusNoContent
	ListSyncStatus func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListSyncStatusOptions) (resp azfake.Responder[armappservice.WebAppsClientListSyncStatusResponse], errResp azfake.ErrorResponder)

	// ListSyncStatusSlot is the fake for method WebAppsClient.ListSyncStatusSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	ListSyncStatusSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListSyncStatusSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListSyncStatusSlotResponse], errResp azfake.ErrorResponder)

	// NewListTriggeredWebJobHistoryPager is the fake for method WebAppsClient.NewListTriggeredWebJobHistoryPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListTriggeredWebJobHistoryPager func(resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientListTriggeredWebJobHistoryOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobHistoryResponse])

	// NewListTriggeredWebJobHistorySlotPager is the fake for method WebAppsClient.NewListTriggeredWebJobHistorySlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListTriggeredWebJobHistorySlotPager func(resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientListTriggeredWebJobHistorySlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobHistorySlotResponse])

	// NewListTriggeredWebJobsPager is the fake for method WebAppsClient.NewListTriggeredWebJobsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListTriggeredWebJobsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListTriggeredWebJobsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobsResponse])

	// NewListTriggeredWebJobsSlotPager is the fake for method WebAppsClient.NewListTriggeredWebJobsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListTriggeredWebJobsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListTriggeredWebJobsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobsSlotResponse])

	// NewListUsagesPager is the fake for method WebAppsClient.NewListUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagesPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListUsagesOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListUsagesResponse])

	// NewListUsagesSlotPager is the fake for method WebAppsClient.NewListUsagesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagesSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListUsagesSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListUsagesSlotResponse])

	// ListVnetConnections is the fake for method WebAppsClient.ListVnetConnections
	// HTTP status codes to indicate success: http.StatusOK
	ListVnetConnections func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListVnetConnectionsOptions) (resp azfake.Responder[armappservice.WebAppsClientListVnetConnectionsResponse], errResp azfake.ErrorResponder)

	// ListVnetConnectionsSlot is the fake for method WebAppsClient.ListVnetConnectionsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListVnetConnectionsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListVnetConnectionsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListVnetConnectionsSlotResponse], errResp azfake.ErrorResponder)

	// NewListWebJobsPager is the fake for method WebAppsClient.NewListWebJobsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebJobsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListWebJobsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListWebJobsResponse])

	// NewListWebJobsSlotPager is the fake for method WebAppsClient.NewListWebJobsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebJobsSlotPager func(resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListWebJobsSlotOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListWebJobsSlotResponse])

	// NewListWorkflowsPager is the fake for method WebAppsClient.NewListWorkflowsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWorkflowsPager func(resourceGroupName string, name string, options *armappservice.WebAppsClientListWorkflowsOptions) (resp azfake.PagerResponder[armappservice.WebAppsClientListWorkflowsResponse])

	// ListWorkflowsConnections is the fake for method WebAppsClient.ListWorkflowsConnections
	// HTTP status codes to indicate success: http.StatusOK
	ListWorkflowsConnections func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientListWorkflowsConnectionsOptions) (resp azfake.Responder[armappservice.WebAppsClientListWorkflowsConnectionsResponse], errResp azfake.ErrorResponder)

	// ListWorkflowsConnectionsSlot is the fake for method WebAppsClient.ListWorkflowsConnectionsSlot
	// HTTP status codes to indicate success: http.StatusOK
	ListWorkflowsConnectionsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientListWorkflowsConnectionsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientListWorkflowsConnectionsSlotResponse], errResp azfake.ErrorResponder)

	// BeginMigrateMySQL is the fake for method WebAppsClient.BeginMigrateMySQL
	// HTTP status codes to indicate success: http.StatusOK
	BeginMigrateMySQL func(ctx context.Context, resourceGroupName string, name string, migrationRequestEnvelope armappservice.MigrateMySQLRequest, options *armappservice.WebAppsClientBeginMigrateMySQLOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientMigrateMySQLResponse], errResp azfake.ErrorResponder)

	// BeginMigrateStorage is the fake for method WebAppsClient.BeginMigrateStorage
	// HTTP status codes to indicate success: http.StatusOK
	BeginMigrateStorage func(ctx context.Context, subscriptionName string, resourceGroupName string, name string, migrationOptions armappservice.StorageMigrationOptions, options *armappservice.WebAppsClientBeginMigrateStorageOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientMigrateStorageResponse], errResp azfake.ErrorResponder)

	// PutPrivateAccessVnet is the fake for method WebAppsClient.PutPrivateAccessVnet
	// HTTP status codes to indicate success: http.StatusOK
	PutPrivateAccessVnet func(ctx context.Context, resourceGroupName string, name string, access armappservice.PrivateAccess, options *armappservice.WebAppsClientPutPrivateAccessVnetOptions) (resp azfake.Responder[armappservice.WebAppsClientPutPrivateAccessVnetResponse], errResp azfake.ErrorResponder)

	// PutPrivateAccessVnetSlot is the fake for method WebAppsClient.PutPrivateAccessVnetSlot
	// HTTP status codes to indicate success: http.StatusOK
	PutPrivateAccessVnetSlot func(ctx context.Context, resourceGroupName string, name string, slot string, access armappservice.PrivateAccess, options *armappservice.WebAppsClientPutPrivateAccessVnetSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientPutPrivateAccessVnetSlotResponse], errResp azfake.ErrorResponder)

	// RecoverSiteConfigurationSnapshot is the fake for method WebAppsClient.RecoverSiteConfigurationSnapshot
	// HTTP status codes to indicate success: http.StatusNoContent
	RecoverSiteConfigurationSnapshot func(ctx context.Context, resourceGroupName string, name string, snapshotID string, options *armappservice.WebAppsClientRecoverSiteConfigurationSnapshotOptions) (resp azfake.Responder[armappservice.WebAppsClientRecoverSiteConfigurationSnapshotResponse], errResp azfake.ErrorResponder)

	// RecoverSiteConfigurationSnapshotSlot is the fake for method WebAppsClient.RecoverSiteConfigurationSnapshotSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	RecoverSiteConfigurationSnapshotSlot func(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string, options *armappservice.WebAppsClientRecoverSiteConfigurationSnapshotSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientRecoverSiteConfigurationSnapshotSlotResponse], errResp azfake.ErrorResponder)

	// ResetProductionSlotConfig is the fake for method WebAppsClient.ResetProductionSlotConfig
	// HTTP status codes to indicate success: http.StatusOK
	ResetProductionSlotConfig func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientResetProductionSlotConfigOptions) (resp azfake.Responder[armappservice.WebAppsClientResetProductionSlotConfigResponse], errResp azfake.ErrorResponder)

	// ResetSlotConfigurationSlot is the fake for method WebAppsClient.ResetSlotConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	ResetSlotConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientResetSlotConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientResetSlotConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// Restart is the fake for method WebAppsClient.Restart
	// HTTP status codes to indicate success: http.StatusOK
	Restart func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientRestartOptions) (resp azfake.Responder[armappservice.WebAppsClientRestartResponse], errResp azfake.ErrorResponder)

	// RestartSlot is the fake for method WebAppsClient.RestartSlot
	// HTTP status codes to indicate success: http.StatusOK
	RestartSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientRestartSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientRestartSlotResponse], errResp azfake.ErrorResponder)

	// BeginRestore is the fake for method WebAppsClient.BeginRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestore func(ctx context.Context, resourceGroupName string, name string, backupID string, request armappservice.RestoreRequest, options *armappservice.WebAppsClientBeginRestoreOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreResponse], errResp azfake.ErrorResponder)

	// BeginRestoreFromBackupBlob is the fake for method WebAppsClient.BeginRestoreFromBackupBlob
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreFromBackupBlob func(ctx context.Context, resourceGroupName string, name string, request armappservice.RestoreRequest, options *armappservice.WebAppsClientBeginRestoreFromBackupBlobOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreFromBackupBlobResponse], errResp azfake.ErrorResponder)

	// BeginRestoreFromBackupBlobSlot is the fake for method WebAppsClient.BeginRestoreFromBackupBlobSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreFromBackupBlobSlot func(ctx context.Context, resourceGroupName string, name string, slot string, request armappservice.RestoreRequest, options *armappservice.WebAppsClientBeginRestoreFromBackupBlobSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreFromBackupBlobSlotResponse], errResp azfake.ErrorResponder)

	// BeginRestoreFromDeletedApp is the fake for method WebAppsClient.BeginRestoreFromDeletedApp
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreFromDeletedApp func(ctx context.Context, resourceGroupName string, name string, restoreRequest armappservice.DeletedAppRestoreRequest, options *armappservice.WebAppsClientBeginRestoreFromDeletedAppOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreFromDeletedAppResponse], errResp azfake.ErrorResponder)

	// BeginRestoreFromDeletedAppSlot is the fake for method WebAppsClient.BeginRestoreFromDeletedAppSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreFromDeletedAppSlot func(ctx context.Context, resourceGroupName string, name string, slot string, restoreRequest armappservice.DeletedAppRestoreRequest, options *armappservice.WebAppsClientBeginRestoreFromDeletedAppSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreFromDeletedAppSlotResponse], errResp azfake.ErrorResponder)

	// BeginRestoreSlot is the fake for method WebAppsClient.BeginRestoreSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreSlot func(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, request armappservice.RestoreRequest, options *armappservice.WebAppsClientBeginRestoreSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreSlotResponse], errResp azfake.ErrorResponder)

	// BeginRestoreSnapshot is the fake for method WebAppsClient.BeginRestoreSnapshot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreSnapshot func(ctx context.Context, resourceGroupName string, name string, restoreRequest armappservice.SnapshotRestoreRequest, options *armappservice.WebAppsClientBeginRestoreSnapshotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreSnapshotResponse], errResp azfake.ErrorResponder)

	// BeginRestoreSnapshotSlot is the fake for method WebAppsClient.BeginRestoreSnapshotSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreSnapshotSlot func(ctx context.Context, resourceGroupName string, name string, slot string, restoreRequest armappservice.SnapshotRestoreRequest, options *armappservice.WebAppsClientBeginRestoreSnapshotSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientRestoreSnapshotSlotResponse], errResp azfake.ErrorResponder)

	// RunTriggeredWebJob is the fake for method WebAppsClient.RunTriggeredWebJob
	// HTTP status codes to indicate success: http.StatusOK
	RunTriggeredWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientRunTriggeredWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientRunTriggeredWebJobResponse], errResp azfake.ErrorResponder)

	// RunTriggeredWebJobSlot is the fake for method WebAppsClient.RunTriggeredWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK
	RunTriggeredWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientRunTriggeredWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientRunTriggeredWebJobSlotResponse], errResp azfake.ErrorResponder)

	// Start is the fake for method WebAppsClient.Start
	// HTTP status codes to indicate success: http.StatusOK
	Start func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientStartOptions) (resp azfake.Responder[armappservice.WebAppsClientStartResponse], errResp azfake.ErrorResponder)

	// StartContinuousWebJob is the fake for method WebAppsClient.StartContinuousWebJob
	// HTTP status codes to indicate success: http.StatusOK
	StartContinuousWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientStartContinuousWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientStartContinuousWebJobResponse], errResp azfake.ErrorResponder)

	// StartContinuousWebJobSlot is the fake for method WebAppsClient.StartContinuousWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK
	StartContinuousWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientStartContinuousWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStartContinuousWebJobSlotResponse], errResp azfake.ErrorResponder)

	// BeginStartNetworkTrace is the fake for method WebAppsClient.BeginStartNetworkTrace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartNetworkTrace func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientBeginStartNetworkTraceOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientStartNetworkTraceResponse], errResp azfake.ErrorResponder)

	// BeginStartNetworkTraceSlot is the fake for method WebAppsClient.BeginStartNetworkTraceSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartNetworkTraceSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientBeginStartNetworkTraceSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientStartNetworkTraceSlotResponse], errResp azfake.ErrorResponder)

	// StartSlot is the fake for method WebAppsClient.StartSlot
	// HTTP status codes to indicate success: http.StatusOK
	StartSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientStartSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStartSlotResponse], errResp azfake.ErrorResponder)

	// StartWebSiteNetworkTrace is the fake for method WebAppsClient.StartWebSiteNetworkTrace
	// HTTP status codes to indicate success: http.StatusOK
	StartWebSiteNetworkTrace func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientStartWebSiteNetworkTraceOptions) (resp azfake.Responder[armappservice.WebAppsClientStartWebSiteNetworkTraceResponse], errResp azfake.ErrorResponder)

	// BeginStartWebSiteNetworkTraceOperation is the fake for method WebAppsClient.BeginStartWebSiteNetworkTraceOperation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartWebSiteNetworkTraceOperation func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientStartWebSiteNetworkTraceOperationResponse], errResp azfake.ErrorResponder)

	// BeginStartWebSiteNetworkTraceOperationSlot is the fake for method WebAppsClient.BeginStartWebSiteNetworkTraceOperationSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartWebSiteNetworkTraceOperationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse], errResp azfake.ErrorResponder)

	// StartWebSiteNetworkTraceSlot is the fake for method WebAppsClient.StartWebSiteNetworkTraceSlot
	// HTTP status codes to indicate success: http.StatusOK
	StartWebSiteNetworkTraceSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientStartWebSiteNetworkTraceSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStartWebSiteNetworkTraceSlotResponse], errResp azfake.ErrorResponder)

	// Stop is the fake for method WebAppsClient.Stop
	// HTTP status codes to indicate success: http.StatusOK
	Stop func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientStopOptions) (resp azfake.Responder[armappservice.WebAppsClientStopResponse], errResp azfake.ErrorResponder)

	// StopContinuousWebJob is the fake for method WebAppsClient.StopContinuousWebJob
	// HTTP status codes to indicate success: http.StatusOK
	StopContinuousWebJob func(ctx context.Context, resourceGroupName string, name string, webJobName string, options *armappservice.WebAppsClientStopContinuousWebJobOptions) (resp azfake.Responder[armappservice.WebAppsClientStopContinuousWebJobResponse], errResp azfake.ErrorResponder)

	// StopContinuousWebJobSlot is the fake for method WebAppsClient.StopContinuousWebJobSlot
	// HTTP status codes to indicate success: http.StatusOK
	StopContinuousWebJobSlot func(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *armappservice.WebAppsClientStopContinuousWebJobSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStopContinuousWebJobSlotResponse], errResp azfake.ErrorResponder)

	// StopNetworkTrace is the fake for method WebAppsClient.StopNetworkTrace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	StopNetworkTrace func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientStopNetworkTraceOptions) (resp azfake.Responder[armappservice.WebAppsClientStopNetworkTraceResponse], errResp azfake.ErrorResponder)

	// StopNetworkTraceSlot is the fake for method WebAppsClient.StopNetworkTraceSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	StopNetworkTraceSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientStopNetworkTraceSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStopNetworkTraceSlotResponse], errResp azfake.ErrorResponder)

	// StopSlot is the fake for method WebAppsClient.StopSlot
	// HTTP status codes to indicate success: http.StatusOK
	StopSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientStopSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStopSlotResponse], errResp azfake.ErrorResponder)

	// StopWebSiteNetworkTrace is the fake for method WebAppsClient.StopWebSiteNetworkTrace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	StopWebSiteNetworkTrace func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientStopWebSiteNetworkTraceOptions) (resp azfake.Responder[armappservice.WebAppsClientStopWebSiteNetworkTraceResponse], errResp azfake.ErrorResponder)

	// StopWebSiteNetworkTraceSlot is the fake for method WebAppsClient.StopWebSiteNetworkTraceSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	StopWebSiteNetworkTraceSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientStopWebSiteNetworkTraceSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientStopWebSiteNetworkTraceSlotResponse], errResp azfake.ErrorResponder)

	// BeginSwapSlot is the fake for method WebAppsClient.BeginSwapSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSwapSlot func(ctx context.Context, resourceGroupName string, name string, slot string, slotSwapEntity armappservice.CsmSlotEntity, options *armappservice.WebAppsClientBeginSwapSlotOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientSwapSlotResponse], errResp azfake.ErrorResponder)

	// BeginSwapSlotWithProduction is the fake for method WebAppsClient.BeginSwapSlotWithProduction
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSwapSlotWithProduction func(ctx context.Context, resourceGroupName string, name string, slotSwapEntity armappservice.CsmSlotEntity, options *armappservice.WebAppsClientBeginSwapSlotWithProductionOptions) (resp azfake.PollerResponder[armappservice.WebAppsClientSwapSlotWithProductionResponse], errResp azfake.ErrorResponder)

	// SyncFunctionTriggers is the fake for method WebAppsClient.SyncFunctionTriggers
	// HTTP status codes to indicate success: http.StatusNoContent
	SyncFunctionTriggers func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientSyncFunctionTriggersOptions) (resp azfake.Responder[armappservice.WebAppsClientSyncFunctionTriggersResponse], errResp azfake.ErrorResponder)

	// SyncFunctionTriggersSlot is the fake for method WebAppsClient.SyncFunctionTriggersSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	SyncFunctionTriggersSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientSyncFunctionTriggersSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientSyncFunctionTriggersSlotResponse], errResp azfake.ErrorResponder)

	// SyncFunctions is the fake for method WebAppsClient.SyncFunctions
	// HTTP status codes to indicate success: http.StatusNoContent
	SyncFunctions func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientSyncFunctionsOptions) (resp azfake.Responder[armappservice.WebAppsClientSyncFunctionsResponse], errResp azfake.ErrorResponder)

	// SyncFunctionsSlot is the fake for method WebAppsClient.SyncFunctionsSlot
	// HTTP status codes to indicate success: http.StatusNoContent
	SyncFunctionsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientSyncFunctionsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientSyncFunctionsSlotResponse], errResp azfake.ErrorResponder)

	// SyncRepository is the fake for method WebAppsClient.SyncRepository
	// HTTP status codes to indicate success: http.StatusOK
	SyncRepository func(ctx context.Context, resourceGroupName string, name string, options *armappservice.WebAppsClientSyncRepositoryOptions) (resp azfake.Responder[armappservice.WebAppsClientSyncRepositoryResponse], errResp azfake.ErrorResponder)

	// SyncRepositorySlot is the fake for method WebAppsClient.SyncRepositorySlot
	// HTTP status codes to indicate success: http.StatusOK
	SyncRepositorySlot func(ctx context.Context, resourceGroupName string, name string, slot string, options *armappservice.WebAppsClientSyncRepositorySlotOptions) (resp azfake.Responder[armappservice.WebAppsClientSyncRepositorySlotResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method WebAppsClient.Update
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	Update func(ctx context.Context, resourceGroupName string, name string, siteEnvelope armappservice.SitePatchResource, options *armappservice.WebAppsClientUpdateOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateApplicationSettings is the fake for method WebAppsClient.UpdateApplicationSettings
	// HTTP status codes to indicate success: http.StatusOK
	UpdateApplicationSettings func(ctx context.Context, resourceGroupName string, name string, appSettings armappservice.StringDictionary, options *armappservice.WebAppsClientUpdateApplicationSettingsOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateApplicationSettingsResponse], errResp azfake.ErrorResponder)

	// UpdateApplicationSettingsSlot is the fake for method WebAppsClient.UpdateApplicationSettingsSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateApplicationSettingsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, appSettings armappservice.StringDictionary, options *armappservice.WebAppsClientUpdateApplicationSettingsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateApplicationSettingsSlotResponse], errResp azfake.ErrorResponder)

	// UpdateAuthSettings is the fake for method WebAppsClient.UpdateAuthSettings
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAuthSettings func(ctx context.Context, resourceGroupName string, name string, siteAuthSettings armappservice.SiteAuthSettings, options *armappservice.WebAppsClientUpdateAuthSettingsOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateAuthSettingsResponse], errResp azfake.ErrorResponder)

	// UpdateAuthSettingsSlot is the fake for method WebAppsClient.UpdateAuthSettingsSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAuthSettingsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteAuthSettings armappservice.SiteAuthSettings, options *armappservice.WebAppsClientUpdateAuthSettingsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateAuthSettingsSlotResponse], errResp azfake.ErrorResponder)

	// UpdateAuthSettingsV2 is the fake for method WebAppsClient.UpdateAuthSettingsV2
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAuthSettingsV2 func(ctx context.Context, resourceGroupName string, name string, siteAuthSettingsV2 armappservice.SiteAuthSettingsV2, options *armappservice.WebAppsClientUpdateAuthSettingsV2Options) (resp azfake.Responder[armappservice.WebAppsClientUpdateAuthSettingsV2Response], errResp azfake.ErrorResponder)

	// UpdateAuthSettingsV2Slot is the fake for method WebAppsClient.UpdateAuthSettingsV2Slot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAuthSettingsV2Slot func(ctx context.Context, resourceGroupName string, name string, slot string, siteAuthSettingsV2 armappservice.SiteAuthSettingsV2, options *armappservice.WebAppsClientUpdateAuthSettingsV2SlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateAuthSettingsV2SlotResponse], errResp azfake.ErrorResponder)

	// UpdateAzureStorageAccounts is the fake for method WebAppsClient.UpdateAzureStorageAccounts
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAzureStorageAccounts func(ctx context.Context, resourceGroupName string, name string, azureStorageAccounts armappservice.AzureStoragePropertyDictionaryResource, options *armappservice.WebAppsClientUpdateAzureStorageAccountsOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateAzureStorageAccountsResponse], errResp azfake.ErrorResponder)

	// UpdateAzureStorageAccountsSlot is the fake for method WebAppsClient.UpdateAzureStorageAccountsSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAzureStorageAccountsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, azureStorageAccounts armappservice.AzureStoragePropertyDictionaryResource, options *armappservice.WebAppsClientUpdateAzureStorageAccountsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateAzureStorageAccountsSlotResponse], errResp azfake.ErrorResponder)

	// UpdateBackupConfiguration is the fake for method WebAppsClient.UpdateBackupConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	UpdateBackupConfiguration func(ctx context.Context, resourceGroupName string, name string, request armappservice.BackupRequest, options *armappservice.WebAppsClientUpdateBackupConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateBackupConfigurationResponse], errResp azfake.ErrorResponder)

	// UpdateBackupConfigurationSlot is the fake for method WebAppsClient.UpdateBackupConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateBackupConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, request armappservice.BackupRequest, options *armappservice.WebAppsClientUpdateBackupConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateBackupConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// UpdateConfiguration is the fake for method WebAppsClient.UpdateConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	UpdateConfiguration func(ctx context.Context, resourceGroupName string, name string, siteConfig armappservice.SiteConfigResource, options *armappservice.WebAppsClientUpdateConfigurationOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateConfigurationResponse], errResp azfake.ErrorResponder)

	// UpdateConfigurationSlot is the fake for method WebAppsClient.UpdateConfigurationSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateConfigurationSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteConfig armappservice.SiteConfigResource, options *armappservice.WebAppsClientUpdateConfigurationSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateConfigurationSlotResponse], errResp azfake.ErrorResponder)

	// UpdateConnectionStrings is the fake for method WebAppsClient.UpdateConnectionStrings
	// HTTP status codes to indicate success: http.StatusOK
	UpdateConnectionStrings func(ctx context.Context, resourceGroupName string, name string, connectionStrings armappservice.ConnectionStringDictionary, options *armappservice.WebAppsClientUpdateConnectionStringsOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateConnectionStringsResponse], errResp azfake.ErrorResponder)

	// UpdateConnectionStringsSlot is the fake for method WebAppsClient.UpdateConnectionStringsSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateConnectionStringsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, connectionStrings armappservice.ConnectionStringDictionary, options *armappservice.WebAppsClientUpdateConnectionStringsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateConnectionStringsSlotResponse], errResp azfake.ErrorResponder)

	// UpdateDiagnosticLogsConfig is the fake for method WebAppsClient.UpdateDiagnosticLogsConfig
	// HTTP status codes to indicate success: http.StatusOK
	UpdateDiagnosticLogsConfig func(ctx context.Context, resourceGroupName string, name string, siteLogsConfig armappservice.SiteLogsConfig, options *armappservice.WebAppsClientUpdateDiagnosticLogsConfigOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateDiagnosticLogsConfigResponse], errResp azfake.ErrorResponder)

	// UpdateDiagnosticLogsConfigSlot is the fake for method WebAppsClient.UpdateDiagnosticLogsConfigSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateDiagnosticLogsConfigSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteLogsConfig armappservice.SiteLogsConfig, options *armappservice.WebAppsClientUpdateDiagnosticLogsConfigSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateDiagnosticLogsConfigSlotResponse], errResp azfake.ErrorResponder)

	// UpdateDomainOwnershipIdentifier is the fake for method WebAppsClient.UpdateDomainOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK
	UpdateDomainOwnershipIdentifier func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier armappservice.Identifier, options *armappservice.WebAppsClientUpdateDomainOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateDomainOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// UpdateDomainOwnershipIdentifierSlot is the fake for method WebAppsClient.UpdateDomainOwnershipIdentifierSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateDomainOwnershipIdentifierSlot func(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, domainOwnershipIdentifier armappservice.Identifier, options *armappservice.WebAppsClientUpdateDomainOwnershipIdentifierSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateDomainOwnershipIdentifierSlotResponse], errResp azfake.ErrorResponder)

	// UpdateFtpAllowed is the fake for method WebAppsClient.UpdateFtpAllowed
	// HTTP status codes to indicate success: http.StatusOK
	UpdateFtpAllowed func(ctx context.Context, resourceGroupName string, name string, csmPublishingAccessPoliciesEntity armappservice.CsmPublishingCredentialsPoliciesEntity, options *armappservice.WebAppsClientUpdateFtpAllowedOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateFtpAllowedResponse], errResp azfake.ErrorResponder)

	// UpdateFtpAllowedSlot is the fake for method WebAppsClient.UpdateFtpAllowedSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateFtpAllowedSlot func(ctx context.Context, resourceGroupName string, name string, slot string, csmPublishingAccessPoliciesEntity armappservice.CsmPublishingCredentialsPoliciesEntity, options *armappservice.WebAppsClientUpdateFtpAllowedSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateFtpAllowedSlotResponse], errResp azfake.ErrorResponder)

	// UpdateHybridConnection is the fake for method WebAppsClient.UpdateHybridConnection
	// HTTP status codes to indicate success: http.StatusOK
	UpdateHybridConnection func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope armappservice.HybridConnection, options *armappservice.WebAppsClientUpdateHybridConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateHybridConnectionResponse], errResp azfake.ErrorResponder)

	// UpdateHybridConnectionSlot is the fake for method WebAppsClient.UpdateHybridConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateHybridConnectionSlot func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, connectionEnvelope armappservice.HybridConnection, options *armappservice.WebAppsClientUpdateHybridConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateHybridConnectionSlotResponse], errResp azfake.ErrorResponder)

	// UpdateMetadata is the fake for method WebAppsClient.UpdateMetadata
	// HTTP status codes to indicate success: http.StatusOK
	UpdateMetadata func(ctx context.Context, resourceGroupName string, name string, metadata armappservice.StringDictionary, options *armappservice.WebAppsClientUpdateMetadataOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateMetadataResponse], errResp azfake.ErrorResponder)

	// UpdateMetadataSlot is the fake for method WebAppsClient.UpdateMetadataSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateMetadataSlot func(ctx context.Context, resourceGroupName string, name string, slot string, metadata armappservice.StringDictionary, options *armappservice.WebAppsClientUpdateMetadataSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateMetadataSlotResponse], errResp azfake.ErrorResponder)

	// UpdatePremierAddOn is the fake for method WebAppsClient.UpdatePremierAddOn
	// HTTP status codes to indicate success: http.StatusOK
	UpdatePremierAddOn func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn armappservice.PremierAddOnPatchResource, options *armappservice.WebAppsClientUpdatePremierAddOnOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdatePremierAddOnResponse], errResp azfake.ErrorResponder)

	// UpdatePremierAddOnSlot is the fake for method WebAppsClient.UpdatePremierAddOnSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdatePremierAddOnSlot func(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, premierAddOn armappservice.PremierAddOnPatchResource, options *armappservice.WebAppsClientUpdatePremierAddOnSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdatePremierAddOnSlotResponse], errResp azfake.ErrorResponder)

	// UpdateRelayServiceConnection is the fake for method WebAppsClient.UpdateRelayServiceConnection
	// HTTP status codes to indicate success: http.StatusOK
	UpdateRelayServiceConnection func(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope armappservice.RelayServiceConnectionEntity, options *armappservice.WebAppsClientUpdateRelayServiceConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateRelayServiceConnectionResponse], errResp azfake.ErrorResponder)

	// UpdateRelayServiceConnectionSlot is the fake for method WebAppsClient.UpdateRelayServiceConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateRelayServiceConnectionSlot func(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, connectionEnvelope armappservice.RelayServiceConnectionEntity, options *armappservice.WebAppsClientUpdateRelayServiceConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateRelayServiceConnectionSlotResponse], errResp azfake.ErrorResponder)

	// UpdateScmAllowed is the fake for method WebAppsClient.UpdateScmAllowed
	// HTTP status codes to indicate success: http.StatusOK
	UpdateScmAllowed func(ctx context.Context, resourceGroupName string, name string, csmPublishingAccessPoliciesEntity armappservice.CsmPublishingCredentialsPoliciesEntity, options *armappservice.WebAppsClientUpdateScmAllowedOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateScmAllowedResponse], errResp azfake.ErrorResponder)

	// UpdateScmAllowedSlot is the fake for method WebAppsClient.UpdateScmAllowedSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateScmAllowedSlot func(ctx context.Context, resourceGroupName string, name string, slot string, csmPublishingAccessPoliciesEntity armappservice.CsmPublishingCredentialsPoliciesEntity, options *armappservice.WebAppsClientUpdateScmAllowedSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateScmAllowedSlotResponse], errResp azfake.ErrorResponder)

	// UpdateSitePushSettings is the fake for method WebAppsClient.UpdateSitePushSettings
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSitePushSettings func(ctx context.Context, resourceGroupName string, name string, pushSettings armappservice.PushSettings, options *armappservice.WebAppsClientUpdateSitePushSettingsOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSitePushSettingsResponse], errResp azfake.ErrorResponder)

	// UpdateSitePushSettingsSlot is the fake for method WebAppsClient.UpdateSitePushSettingsSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSitePushSettingsSlot func(ctx context.Context, resourceGroupName string, name string, slot string, pushSettings armappservice.PushSettings, options *armappservice.WebAppsClientUpdateSitePushSettingsSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSitePushSettingsSlotResponse], errResp azfake.ErrorResponder)

	// UpdateSlot is the fake for method WebAppsClient.UpdateSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	UpdateSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteEnvelope armappservice.SitePatchResource, options *armappservice.WebAppsClientUpdateSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSlotResponse], errResp azfake.ErrorResponder)

	// UpdateSlotConfigurationNames is the fake for method WebAppsClient.UpdateSlotConfigurationNames
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSlotConfigurationNames func(ctx context.Context, resourceGroupName string, name string, slotConfigNames armappservice.SlotConfigNamesResource, options *armappservice.WebAppsClientUpdateSlotConfigurationNamesOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSlotConfigurationNamesResponse], errResp azfake.ErrorResponder)

	// UpdateSourceControl is the fake for method WebAppsClient.UpdateSourceControl
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	UpdateSourceControl func(ctx context.Context, resourceGroupName string, name string, siteSourceControl armappservice.SiteSourceControl, options *armappservice.WebAppsClientUpdateSourceControlOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSourceControlResponse], errResp azfake.ErrorResponder)

	// UpdateSourceControlSlot is the fake for method WebAppsClient.UpdateSourceControlSlot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	UpdateSourceControlSlot func(ctx context.Context, resourceGroupName string, name string, slot string, siteSourceControl armappservice.SiteSourceControl, options *armappservice.WebAppsClientUpdateSourceControlSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSourceControlSlotResponse], errResp azfake.ErrorResponder)

	// UpdateSwiftVirtualNetworkConnectionWithCheck is the fake for method WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheck
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSwiftVirtualNetworkConnectionWithCheck func(ctx context.Context, resourceGroupName string, name string, connectionEnvelope armappservice.SwiftVirtualNetwork, options *armappservice.WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckResponse], errResp azfake.ErrorResponder)

	// UpdateSwiftVirtualNetworkConnectionWithCheckSlot is the fake for method WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheckSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSwiftVirtualNetworkConnectionWithCheckSlot func(ctx context.Context, resourceGroupName string, name string, slot string, connectionEnvelope armappservice.SwiftVirtualNetwork, options *armappservice.WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse], errResp azfake.ErrorResponder)

	// UpdateVnetConnection is the fake for method WebAppsClient.UpdateVnetConnection
	// HTTP status codes to indicate success: http.StatusOK
	UpdateVnetConnection func(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope armappservice.VnetInfoResource, options *armappservice.WebAppsClientUpdateVnetConnectionOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateVnetConnectionResponse], errResp azfake.ErrorResponder)

	// UpdateVnetConnectionGateway is the fake for method WebAppsClient.UpdateVnetConnectionGateway
	// HTTP status codes to indicate success: http.StatusOK
	UpdateVnetConnectionGateway func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope armappservice.VnetGateway, options *armappservice.WebAppsClientUpdateVnetConnectionGatewayOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateVnetConnectionGatewayResponse], errResp azfake.ErrorResponder)

	// UpdateVnetConnectionGatewaySlot is the fake for method WebAppsClient.UpdateVnetConnectionGatewaySlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateVnetConnectionGatewaySlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, connectionEnvelope armappservice.VnetGateway, options *armappservice.WebAppsClientUpdateVnetConnectionGatewaySlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateVnetConnectionGatewaySlotResponse], errResp azfake.ErrorResponder)

	// UpdateVnetConnectionSlot is the fake for method WebAppsClient.UpdateVnetConnectionSlot
	// HTTP status codes to indicate success: http.StatusOK
	UpdateVnetConnectionSlot func(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, connectionEnvelope armappservice.VnetInfoResource, options *armappservice.WebAppsClientUpdateVnetConnectionSlotOptions) (resp azfake.Responder[armappservice.WebAppsClientUpdateVnetConnectionSlotResponse], errResp azfake.ErrorResponder)
}

// NewWebAppsServerTransport creates a new instance of WebAppsServerTransport with the provided implementation.
// The returned WebAppsServerTransport instance is connected to an instance of armappservice.WebAppsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWebAppsServerTransport(srv *WebAppsServer) *WebAppsServerTransport {
	return &WebAppsServerTransport{
		srv: srv,
		beginApproveOrRejectPrivateEndpointConnection:         newTracker[azfake.PollerResponder[armappservice.WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse]](),
		beginApproveOrRejectPrivateEndpointConnectionSlot:     newTracker[azfake.PollerResponder[armappservice.WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse]](),
		beginCreateFunction:                                   newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateFunctionResponse]](),
		beginCreateInstanceFunctionSlot:                       newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceFunctionSlotResponse]](),
		beginCreateInstanceMSDeployOperation:                  newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceMSDeployOperationResponse]](),
		beginCreateInstanceMSDeployOperationSlot:              newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceMSDeployOperationSlotResponse]](),
		beginCreateMSDeployOperation:                          newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateMSDeployOperationResponse]](),
		beginCreateMSDeployOperationSlot:                      newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateMSDeployOperationSlotResponse]](),
		beginCreateOrUpdate:                                   newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateResponse]](),
		beginCreateOrUpdateSlot:                               newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSlotResponse]](),
		beginCreateOrUpdateSourceControl:                      newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSourceControlResponse]](),
		beginCreateOrUpdateSourceControlSlot:                  newTracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSourceControlSlotResponse]](),
		beginDeletePrivateEndpointConnection:                  newTracker[azfake.PollerResponder[armappservice.WebAppsClientDeletePrivateEndpointConnectionResponse]](),
		beginDeletePrivateEndpointConnectionSlot:              newTracker[azfake.PollerResponder[armappservice.WebAppsClientDeletePrivateEndpointConnectionSlotResponse]](),
		newGetAppSettingsKeyVaultReferencesPager:              newTracker[azfake.PagerResponder[armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesResponse]](),
		newGetAppSettingsKeyVaultReferencesSlotPager:          newTracker[azfake.PagerResponder[armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse]](),
		newGetPrivateEndpointConnectionListPager:              newTracker[azfake.PagerResponder[armappservice.WebAppsClientGetPrivateEndpointConnectionListResponse]](),
		newGetPrivateEndpointConnectionListSlotPager:          newTracker[azfake.PagerResponder[armappservice.WebAppsClientGetPrivateEndpointConnectionListSlotResponse]](),
		beginGetProductionSiteDeploymentStatus:                newTracker[azfake.PollerResponder[armappservice.WebAppsClientGetProductionSiteDeploymentStatusResponse]](),
		newGetSiteConnectionStringKeyVaultReferencesPager:     newTracker[azfake.PagerResponder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse]](),
		newGetSiteConnectionStringKeyVaultReferencesSlotPager: newTracker[azfake.PagerResponder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse]](),
		beginGetSlotSiteDeploymentStatusSlot:                  newTracker[azfake.PollerResponder[armappservice.WebAppsClientGetSlotSiteDeploymentStatusSlotResponse]](),
		beginInstallSiteExtension:                             newTracker[azfake.PollerResponder[armappservice.WebAppsClientInstallSiteExtensionResponse]](),
		beginInstallSiteExtensionSlot:                         newTracker[azfake.PollerResponder[armappservice.WebAppsClientInstallSiteExtensionSlotResponse]](),
		newListPager:                                          newTracker[azfake.PagerResponder[armappservice.WebAppsClientListResponse]](),
		newListBackupsPager:                                   newTracker[azfake.PagerResponder[armappservice.WebAppsClientListBackupsResponse]](),
		newListBackupsSlotPager:                               newTracker[azfake.PagerResponder[armappservice.WebAppsClientListBackupsSlotResponse]](),
		newListBasicPublishingCredentialsPoliciesPager:        newTracker[azfake.PagerResponder[armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesResponse]](),
		newListBasicPublishingCredentialsPoliciesSlotPager:    newTracker[azfake.PagerResponder[armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse]](),
		newListByResourceGroupPager:                           newTracker[azfake.PagerResponder[armappservice.WebAppsClientListByResourceGroupResponse]](),
		newListConfigurationSnapshotInfoPager:                 newTracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationSnapshotInfoResponse]](),
		newListConfigurationSnapshotInfoSlotPager:             newTracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationSnapshotInfoSlotResponse]](),
		newListConfigurationsPager:                            newTracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationsResponse]](),
		newListConfigurationsSlotPager:                        newTracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationsSlotResponse]](),
		newListContinuousWebJobsPager:                         newTracker[azfake.PagerResponder[armappservice.WebAppsClientListContinuousWebJobsResponse]](),
		newListContinuousWebJobsSlotPager:                     newTracker[azfake.PagerResponder[armappservice.WebAppsClientListContinuousWebJobsSlotResponse]](),
		newListDeploymentsPager:                               newTracker[azfake.PagerResponder[armappservice.WebAppsClientListDeploymentsResponse]](),
		newListDeploymentsSlotPager:                           newTracker[azfake.PagerResponder[armappservice.WebAppsClientListDeploymentsSlotResponse]](),
		newListDomainOwnershipIdentifiersPager:                newTracker[azfake.PagerResponder[armappservice.WebAppsClientListDomainOwnershipIdentifiersResponse]](),
		newListDomainOwnershipIdentifiersSlotPager:            newTracker[azfake.PagerResponder[armappservice.WebAppsClientListDomainOwnershipIdentifiersSlotResponse]](),
		newListFunctionsPager:                                 newTracker[azfake.PagerResponder[armappservice.WebAppsClientListFunctionsResponse]](),
		newListHostNameBindingsPager:                          newTracker[azfake.PagerResponder[armappservice.WebAppsClientListHostNameBindingsResponse]](),
		newListHostNameBindingsSlotPager:                      newTracker[azfake.PagerResponder[armappservice.WebAppsClientListHostNameBindingsSlotResponse]](),
		newListInstanceFunctionsSlotPager:                     newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceFunctionsSlotResponse]](),
		newListInstanceIdentifiersPager:                       newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceIdentifiersResponse]](),
		newListInstanceIdentifiersSlotPager:                   newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceIdentifiersSlotResponse]](),
		newListInstanceProcessModulesPager:                    newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessModulesResponse]](),
		newListInstanceProcessModulesSlotPager:                newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessModulesSlotResponse]](),
		newListInstanceProcessThreadsPager:                    newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessThreadsResponse]](),
		newListInstanceProcessThreadsSlotPager:                newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessThreadsSlotResponse]](),
		newListInstanceProcessesPager:                         newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessesResponse]](),
		newListInstanceProcessesSlotPager:                     newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessesSlotResponse]](),
		newListInstanceWorkflowsSlotPager:                     newTracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceWorkflowsSlotResponse]](),
		newListPerfMonCountersPager:                           newTracker[azfake.PagerResponder[armappservice.WebAppsClientListPerfMonCountersResponse]](),
		newListPerfMonCountersSlotPager:                       newTracker[azfake.PagerResponder[armappservice.WebAppsClientListPerfMonCountersSlotResponse]](),
		newListProcessModulesPager:                            newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessModulesResponse]](),
		newListProcessModulesSlotPager:                        newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessModulesSlotResponse]](),
		newListProcessThreadsPager:                            newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessThreadsResponse]](),
		newListProcessThreadsSlotPager:                        newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessThreadsSlotResponse]](),
		newListProcessesPager:                                 newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessesResponse]](),
		newListProcessesSlotPager:                             newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessesSlotResponse]](),
		newListProductionSiteDeploymentStatusesPager:          newTracker[azfake.PagerResponder[armappservice.WebAppsClientListProductionSiteDeploymentStatusesResponse]](),
		newListPublicCertificatesPager:                        newTracker[azfake.PagerResponder[armappservice.WebAppsClientListPublicCertificatesResponse]](),
		newListPublicCertificatesSlotPager:                    newTracker[azfake.PagerResponder[armappservice.WebAppsClientListPublicCertificatesSlotResponse]](),
		beginListPublishingCredentials:                        newTracker[azfake.PollerResponder[armappservice.WebAppsClientListPublishingCredentialsResponse]](),
		beginListPublishingCredentialsSlot:                    newTracker[azfake.PollerResponder[armappservice.WebAppsClientListPublishingCredentialsSlotResponse]](),
		newListSiteBackupsPager:                               newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteBackupsResponse]](),
		newListSiteBackupsSlotPager:                           newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteBackupsSlotResponse]](),
		newListSiteExtensionsPager:                            newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteExtensionsResponse]](),
		newListSiteExtensionsSlotPager:                        newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteExtensionsSlotResponse]](),
		newListSlotDifferencesFromProductionPager:             newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotDifferencesFromProductionResponse]](),
		newListSlotDifferencesSlotPager:                       newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotDifferencesSlotResponse]](),
		newListSlotSiteDeploymentStatusesSlotPager:            newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotSiteDeploymentStatusesSlotResponse]](),
		newListSlotsPager:                                     newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotsResponse]](),
		newListSnapshotsPager:                                 newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsResponse]](),
		newListSnapshotsFromDRSecondaryPager:                  newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsFromDRSecondaryResponse]](),
		newListSnapshotsFromDRSecondarySlotPager:              newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsFromDRSecondarySlotResponse]](),
		newListSnapshotsSlotPager:                             newTracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsSlotResponse]](),
		newListTriggeredWebJobHistoryPager:                    newTracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobHistoryResponse]](),
		newListTriggeredWebJobHistorySlotPager:                newTracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobHistorySlotResponse]](),
		newListTriggeredWebJobsPager:                          newTracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobsResponse]](),
		newListTriggeredWebJobsSlotPager:                      newTracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobsSlotResponse]](),
		newListUsagesPager:                                    newTracker[azfake.PagerResponder[armappservice.WebAppsClientListUsagesResponse]](),
		newListUsagesSlotPager:                                newTracker[azfake.PagerResponder[armappservice.WebAppsClientListUsagesSlotResponse]](),
		newListWebJobsPager:                                   newTracker[azfake.PagerResponder[armappservice.WebAppsClientListWebJobsResponse]](),
		newListWebJobsSlotPager:                               newTracker[azfake.PagerResponder[armappservice.WebAppsClientListWebJobsSlotResponse]](),
		newListWorkflowsPager:                                 newTracker[azfake.PagerResponder[armappservice.WebAppsClientListWorkflowsResponse]](),
		beginMigrateMySQL:                                     newTracker[azfake.PollerResponder[armappservice.WebAppsClientMigrateMySQLResponse]](),
		beginMigrateStorage:                                   newTracker[azfake.PollerResponder[armappservice.WebAppsClientMigrateStorageResponse]](),
		beginRestore:                                          newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreResponse]](),
		beginRestoreFromBackupBlob:                            newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromBackupBlobResponse]](),
		beginRestoreFromBackupBlobSlot:                        newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromBackupBlobSlotResponse]](),
		beginRestoreFromDeletedApp:                            newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromDeletedAppResponse]](),
		beginRestoreFromDeletedAppSlot:                        newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromDeletedAppSlotResponse]](),
		beginRestoreSlot:                                      newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreSlotResponse]](),
		beginRestoreSnapshot:                                  newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreSnapshotResponse]](),
		beginRestoreSnapshotSlot:                              newTracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreSnapshotSlotResponse]](),
		beginStartNetworkTrace:                                newTracker[azfake.PollerResponder[armappservice.WebAppsClientStartNetworkTraceResponse]](),
		beginStartNetworkTraceSlot:                            newTracker[azfake.PollerResponder[armappservice.WebAppsClientStartNetworkTraceSlotResponse]](),
		beginStartWebSiteNetworkTraceOperation:                newTracker[azfake.PollerResponder[armappservice.WebAppsClientStartWebSiteNetworkTraceOperationResponse]](),
		beginStartWebSiteNetworkTraceOperationSlot:            newTracker[azfake.PollerResponder[armappservice.WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse]](),
		beginSwapSlot:                                         newTracker[azfake.PollerResponder[armappservice.WebAppsClientSwapSlotResponse]](),
		beginSwapSlotWithProduction:                           newTracker[azfake.PollerResponder[armappservice.WebAppsClientSwapSlotWithProductionResponse]](),
	}
}

// WebAppsServerTransport connects instances of armappservice.WebAppsClient to instances of WebAppsServer.
// Don't use this type directly, use NewWebAppsServerTransport instead.
type WebAppsServerTransport struct {
	srv                                                   *WebAppsServer
	beginApproveOrRejectPrivateEndpointConnection         *tracker[azfake.PollerResponder[armappservice.WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse]]
	beginApproveOrRejectPrivateEndpointConnectionSlot     *tracker[azfake.PollerResponder[armappservice.WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse]]
	beginCreateFunction                                   *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateFunctionResponse]]
	beginCreateInstanceFunctionSlot                       *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceFunctionSlotResponse]]
	beginCreateInstanceMSDeployOperation                  *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceMSDeployOperationResponse]]
	beginCreateInstanceMSDeployOperationSlot              *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateInstanceMSDeployOperationSlotResponse]]
	beginCreateMSDeployOperation                          *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateMSDeployOperationResponse]]
	beginCreateMSDeployOperationSlot                      *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateMSDeployOperationSlotResponse]]
	beginCreateOrUpdate                                   *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateResponse]]
	beginCreateOrUpdateSlot                               *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSlotResponse]]
	beginCreateOrUpdateSourceControl                      *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSourceControlResponse]]
	beginCreateOrUpdateSourceControlSlot                  *tracker[azfake.PollerResponder[armappservice.WebAppsClientCreateOrUpdateSourceControlSlotResponse]]
	beginDeletePrivateEndpointConnection                  *tracker[azfake.PollerResponder[armappservice.WebAppsClientDeletePrivateEndpointConnectionResponse]]
	beginDeletePrivateEndpointConnectionSlot              *tracker[azfake.PollerResponder[armappservice.WebAppsClientDeletePrivateEndpointConnectionSlotResponse]]
	newGetAppSettingsKeyVaultReferencesPager              *tracker[azfake.PagerResponder[armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesResponse]]
	newGetAppSettingsKeyVaultReferencesSlotPager          *tracker[azfake.PagerResponder[armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse]]
	newGetPrivateEndpointConnectionListPager              *tracker[azfake.PagerResponder[armappservice.WebAppsClientGetPrivateEndpointConnectionListResponse]]
	newGetPrivateEndpointConnectionListSlotPager          *tracker[azfake.PagerResponder[armappservice.WebAppsClientGetPrivateEndpointConnectionListSlotResponse]]
	beginGetProductionSiteDeploymentStatus                *tracker[azfake.PollerResponder[armappservice.WebAppsClientGetProductionSiteDeploymentStatusResponse]]
	newGetSiteConnectionStringKeyVaultReferencesPager     *tracker[azfake.PagerResponder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse]]
	newGetSiteConnectionStringKeyVaultReferencesSlotPager *tracker[azfake.PagerResponder[armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse]]
	beginGetSlotSiteDeploymentStatusSlot                  *tracker[azfake.PollerResponder[armappservice.WebAppsClientGetSlotSiteDeploymentStatusSlotResponse]]
	beginInstallSiteExtension                             *tracker[azfake.PollerResponder[armappservice.WebAppsClientInstallSiteExtensionResponse]]
	beginInstallSiteExtensionSlot                         *tracker[azfake.PollerResponder[armappservice.WebAppsClientInstallSiteExtensionSlotResponse]]
	newListPager                                          *tracker[azfake.PagerResponder[armappservice.WebAppsClientListResponse]]
	newListBackupsPager                                   *tracker[azfake.PagerResponder[armappservice.WebAppsClientListBackupsResponse]]
	newListBackupsSlotPager                               *tracker[azfake.PagerResponder[armappservice.WebAppsClientListBackupsSlotResponse]]
	newListBasicPublishingCredentialsPoliciesPager        *tracker[azfake.PagerResponder[armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesResponse]]
	newListBasicPublishingCredentialsPoliciesSlotPager    *tracker[azfake.PagerResponder[armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse]]
	newListByResourceGroupPager                           *tracker[azfake.PagerResponder[armappservice.WebAppsClientListByResourceGroupResponse]]
	newListConfigurationSnapshotInfoPager                 *tracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationSnapshotInfoResponse]]
	newListConfigurationSnapshotInfoSlotPager             *tracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationSnapshotInfoSlotResponse]]
	newListConfigurationsPager                            *tracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationsResponse]]
	newListConfigurationsSlotPager                        *tracker[azfake.PagerResponder[armappservice.WebAppsClientListConfigurationsSlotResponse]]
	newListContinuousWebJobsPager                         *tracker[azfake.PagerResponder[armappservice.WebAppsClientListContinuousWebJobsResponse]]
	newListContinuousWebJobsSlotPager                     *tracker[azfake.PagerResponder[armappservice.WebAppsClientListContinuousWebJobsSlotResponse]]
	newListDeploymentsPager                               *tracker[azfake.PagerResponder[armappservice.WebAppsClientListDeploymentsResponse]]
	newListDeploymentsSlotPager                           *tracker[azfake.PagerResponder[armappservice.WebAppsClientListDeploymentsSlotResponse]]
	newListDomainOwnershipIdentifiersPager                *tracker[azfake.PagerResponder[armappservice.WebAppsClientListDomainOwnershipIdentifiersResponse]]
	newListDomainOwnershipIdentifiersSlotPager            *tracker[azfake.PagerResponder[armappservice.WebAppsClientListDomainOwnershipIdentifiersSlotResponse]]
	newListFunctionsPager                                 *tracker[azfake.PagerResponder[armappservice.WebAppsClientListFunctionsResponse]]
	newListHostNameBindingsPager                          *tracker[azfake.PagerResponder[armappservice.WebAppsClientListHostNameBindingsResponse]]
	newListHostNameBindingsSlotPager                      *tracker[azfake.PagerResponder[armappservice.WebAppsClientListHostNameBindingsSlotResponse]]
	newListInstanceFunctionsSlotPager                     *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceFunctionsSlotResponse]]
	newListInstanceIdentifiersPager                       *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceIdentifiersResponse]]
	newListInstanceIdentifiersSlotPager                   *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceIdentifiersSlotResponse]]
	newListInstanceProcessModulesPager                    *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessModulesResponse]]
	newListInstanceProcessModulesSlotPager                *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessModulesSlotResponse]]
	newListInstanceProcessThreadsPager                    *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessThreadsResponse]]
	newListInstanceProcessThreadsSlotPager                *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessThreadsSlotResponse]]
	newListInstanceProcessesPager                         *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessesResponse]]
	newListInstanceProcessesSlotPager                     *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceProcessesSlotResponse]]
	newListInstanceWorkflowsSlotPager                     *tracker[azfake.PagerResponder[armappservice.WebAppsClientListInstanceWorkflowsSlotResponse]]
	newListPerfMonCountersPager                           *tracker[azfake.PagerResponder[armappservice.WebAppsClientListPerfMonCountersResponse]]
	newListPerfMonCountersSlotPager                       *tracker[azfake.PagerResponder[armappservice.WebAppsClientListPerfMonCountersSlotResponse]]
	newListProcessModulesPager                            *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessModulesResponse]]
	newListProcessModulesSlotPager                        *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessModulesSlotResponse]]
	newListProcessThreadsPager                            *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessThreadsResponse]]
	newListProcessThreadsSlotPager                        *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessThreadsSlotResponse]]
	newListProcessesPager                                 *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessesResponse]]
	newListProcessesSlotPager                             *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProcessesSlotResponse]]
	newListProductionSiteDeploymentStatusesPager          *tracker[azfake.PagerResponder[armappservice.WebAppsClientListProductionSiteDeploymentStatusesResponse]]
	newListPublicCertificatesPager                        *tracker[azfake.PagerResponder[armappservice.WebAppsClientListPublicCertificatesResponse]]
	newListPublicCertificatesSlotPager                    *tracker[azfake.PagerResponder[armappservice.WebAppsClientListPublicCertificatesSlotResponse]]
	beginListPublishingCredentials                        *tracker[azfake.PollerResponder[armappservice.WebAppsClientListPublishingCredentialsResponse]]
	beginListPublishingCredentialsSlot                    *tracker[azfake.PollerResponder[armappservice.WebAppsClientListPublishingCredentialsSlotResponse]]
	newListSiteBackupsPager                               *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteBackupsResponse]]
	newListSiteBackupsSlotPager                           *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteBackupsSlotResponse]]
	newListSiteExtensionsPager                            *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteExtensionsResponse]]
	newListSiteExtensionsSlotPager                        *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSiteExtensionsSlotResponse]]
	newListSlotDifferencesFromProductionPager             *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotDifferencesFromProductionResponse]]
	newListSlotDifferencesSlotPager                       *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotDifferencesSlotResponse]]
	newListSlotSiteDeploymentStatusesSlotPager            *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotSiteDeploymentStatusesSlotResponse]]
	newListSlotsPager                                     *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSlotsResponse]]
	newListSnapshotsPager                                 *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsResponse]]
	newListSnapshotsFromDRSecondaryPager                  *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsFromDRSecondaryResponse]]
	newListSnapshotsFromDRSecondarySlotPager              *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsFromDRSecondarySlotResponse]]
	newListSnapshotsSlotPager                             *tracker[azfake.PagerResponder[armappservice.WebAppsClientListSnapshotsSlotResponse]]
	newListTriggeredWebJobHistoryPager                    *tracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobHistoryResponse]]
	newListTriggeredWebJobHistorySlotPager                *tracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobHistorySlotResponse]]
	newListTriggeredWebJobsPager                          *tracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobsResponse]]
	newListTriggeredWebJobsSlotPager                      *tracker[azfake.PagerResponder[armappservice.WebAppsClientListTriggeredWebJobsSlotResponse]]
	newListUsagesPager                                    *tracker[azfake.PagerResponder[armappservice.WebAppsClientListUsagesResponse]]
	newListUsagesSlotPager                                *tracker[azfake.PagerResponder[armappservice.WebAppsClientListUsagesSlotResponse]]
	newListWebJobsPager                                   *tracker[azfake.PagerResponder[armappservice.WebAppsClientListWebJobsResponse]]
	newListWebJobsSlotPager                               *tracker[azfake.PagerResponder[armappservice.WebAppsClientListWebJobsSlotResponse]]
	newListWorkflowsPager                                 *tracker[azfake.PagerResponder[armappservice.WebAppsClientListWorkflowsResponse]]
	beginMigrateMySQL                                     *tracker[azfake.PollerResponder[armappservice.WebAppsClientMigrateMySQLResponse]]
	beginMigrateStorage                                   *tracker[azfake.PollerResponder[armappservice.WebAppsClientMigrateStorageResponse]]
	beginRestore                                          *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreResponse]]
	beginRestoreFromBackupBlob                            *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromBackupBlobResponse]]
	beginRestoreFromBackupBlobSlot                        *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromBackupBlobSlotResponse]]
	beginRestoreFromDeletedApp                            *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromDeletedAppResponse]]
	beginRestoreFromDeletedAppSlot                        *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreFromDeletedAppSlotResponse]]
	beginRestoreSlot                                      *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreSlotResponse]]
	beginRestoreSnapshot                                  *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreSnapshotResponse]]
	beginRestoreSnapshotSlot                              *tracker[azfake.PollerResponder[armappservice.WebAppsClientRestoreSnapshotSlotResponse]]
	beginStartNetworkTrace                                *tracker[azfake.PollerResponder[armappservice.WebAppsClientStartNetworkTraceResponse]]
	beginStartNetworkTraceSlot                            *tracker[azfake.PollerResponder[armappservice.WebAppsClientStartNetworkTraceSlotResponse]]
	beginStartWebSiteNetworkTraceOperation                *tracker[azfake.PollerResponder[armappservice.WebAppsClientStartWebSiteNetworkTraceOperationResponse]]
	beginStartWebSiteNetworkTraceOperationSlot            *tracker[azfake.PollerResponder[armappservice.WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse]]
	beginSwapSlot                                         *tracker[azfake.PollerResponder[armappservice.WebAppsClientSwapSlotResponse]]
	beginSwapSlotWithProduction                           *tracker[azfake.PollerResponder[armappservice.WebAppsClientSwapSlotWithProductionResponse]]
}

// Do implements the policy.Transporter interface for WebAppsServerTransport.
func (w *WebAppsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WebAppsClient.AddPremierAddOn":
		resp, err = w.dispatchAddPremierAddOn(req)
	case "WebAppsClient.AddPremierAddOnSlot":
		resp, err = w.dispatchAddPremierAddOnSlot(req)
	case "WebAppsClient.AnalyzeCustomHostname":
		resp, err = w.dispatchAnalyzeCustomHostname(req)
	case "WebAppsClient.AnalyzeCustomHostnameSlot":
		resp, err = w.dispatchAnalyzeCustomHostnameSlot(req)
	case "WebAppsClient.ApplySlotConfigToProduction":
		resp, err = w.dispatchApplySlotConfigToProduction(req)
	case "WebAppsClient.ApplySlotConfigurationSlot":
		resp, err = w.dispatchApplySlotConfigurationSlot(req)
	case "WebAppsClient.BeginApproveOrRejectPrivateEndpointConnection":
		resp, err = w.dispatchBeginApproveOrRejectPrivateEndpointConnection(req)
	case "WebAppsClient.BeginApproveOrRejectPrivateEndpointConnectionSlot":
		resp, err = w.dispatchBeginApproveOrRejectPrivateEndpointConnectionSlot(req)
	case "WebAppsClient.Backup":
		resp, err = w.dispatchBackup(req)
	case "WebAppsClient.BackupSlot":
		resp, err = w.dispatchBackupSlot(req)
	case "WebAppsClient.CreateDeployment":
		resp, err = w.dispatchCreateDeployment(req)
	case "WebAppsClient.CreateDeploymentSlot":
		resp, err = w.dispatchCreateDeploymentSlot(req)
	case "WebAppsClient.BeginCreateFunction":
		resp, err = w.dispatchBeginCreateFunction(req)
	case "WebAppsClient.BeginCreateInstanceFunctionSlot":
		resp, err = w.dispatchBeginCreateInstanceFunctionSlot(req)
	case "WebAppsClient.BeginCreateInstanceMSDeployOperation":
		resp, err = w.dispatchBeginCreateInstanceMSDeployOperation(req)
	case "WebAppsClient.BeginCreateInstanceMSDeployOperationSlot":
		resp, err = w.dispatchBeginCreateInstanceMSDeployOperationSlot(req)
	case "WebAppsClient.BeginCreateMSDeployOperation":
		resp, err = w.dispatchBeginCreateMSDeployOperation(req)
	case "WebAppsClient.BeginCreateMSDeployOperationSlot":
		resp, err = w.dispatchBeginCreateMSDeployOperationSlot(req)
	case "WebAppsClient.CreateOneDeployOperation":
		resp, err = w.dispatchCreateOneDeployOperation(req)
	case "WebAppsClient.BeginCreateOrUpdate":
		resp, err = w.dispatchBeginCreateOrUpdate(req)
	case "WebAppsClient.CreateOrUpdateConfiguration":
		resp, err = w.dispatchCreateOrUpdateConfiguration(req)
	case "WebAppsClient.CreateOrUpdateConfigurationSlot":
		resp, err = w.dispatchCreateOrUpdateConfigurationSlot(req)
	case "WebAppsClient.CreateOrUpdateDomainOwnershipIdentifier":
		resp, err = w.dispatchCreateOrUpdateDomainOwnershipIdentifier(req)
	case "WebAppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot":
		resp, err = w.dispatchCreateOrUpdateDomainOwnershipIdentifierSlot(req)
	case "WebAppsClient.CreateOrUpdateFunctionSecret":
		resp, err = w.dispatchCreateOrUpdateFunctionSecret(req)
	case "WebAppsClient.CreateOrUpdateFunctionSecretSlot":
		resp, err = w.dispatchCreateOrUpdateFunctionSecretSlot(req)
	case "WebAppsClient.CreateOrUpdateHostNameBinding":
		resp, err = w.dispatchCreateOrUpdateHostNameBinding(req)
	case "WebAppsClient.CreateOrUpdateHostNameBindingSlot":
		resp, err = w.dispatchCreateOrUpdateHostNameBindingSlot(req)
	case "WebAppsClient.CreateOrUpdateHostSecret":
		resp, err = w.dispatchCreateOrUpdateHostSecret(req)
	case "WebAppsClient.CreateOrUpdateHostSecretSlot":
		resp, err = w.dispatchCreateOrUpdateHostSecretSlot(req)
	case "WebAppsClient.CreateOrUpdateHybridConnection":
		resp, err = w.dispatchCreateOrUpdateHybridConnection(req)
	case "WebAppsClient.CreateOrUpdateHybridConnectionSlot":
		resp, err = w.dispatchCreateOrUpdateHybridConnectionSlot(req)
	case "WebAppsClient.CreateOrUpdatePublicCertificate":
		resp, err = w.dispatchCreateOrUpdatePublicCertificate(req)
	case "WebAppsClient.CreateOrUpdatePublicCertificateSlot":
		resp, err = w.dispatchCreateOrUpdatePublicCertificateSlot(req)
	case "WebAppsClient.CreateOrUpdateRelayServiceConnection":
		resp, err = w.dispatchCreateOrUpdateRelayServiceConnection(req)
	case "WebAppsClient.CreateOrUpdateRelayServiceConnectionSlot":
		resp, err = w.dispatchCreateOrUpdateRelayServiceConnectionSlot(req)
	case "WebAppsClient.BeginCreateOrUpdateSlot":
		resp, err = w.dispatchBeginCreateOrUpdateSlot(req)
	case "WebAppsClient.BeginCreateOrUpdateSourceControl":
		resp, err = w.dispatchBeginCreateOrUpdateSourceControl(req)
	case "WebAppsClient.BeginCreateOrUpdateSourceControlSlot":
		resp, err = w.dispatchBeginCreateOrUpdateSourceControlSlot(req)
	case "WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck":
		resp, err = w.dispatchCreateOrUpdateSwiftVirtualNetworkConnectionWithCheck(req)
	case "WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot":
		resp, err = w.dispatchCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot(req)
	case "WebAppsClient.CreateOrUpdateVnetConnection":
		resp, err = w.dispatchCreateOrUpdateVnetConnection(req)
	case "WebAppsClient.CreateOrUpdateVnetConnectionGateway":
		resp, err = w.dispatchCreateOrUpdateVnetConnectionGateway(req)
	case "WebAppsClient.CreateOrUpdateVnetConnectionGatewaySlot":
		resp, err = w.dispatchCreateOrUpdateVnetConnectionGatewaySlot(req)
	case "WebAppsClient.CreateOrUpdateVnetConnectionSlot":
		resp, err = w.dispatchCreateOrUpdateVnetConnectionSlot(req)
	case "WebAppsClient.Delete":
		resp, err = w.dispatchDelete(req)
	case "WebAppsClient.DeleteBackup":
		resp, err = w.dispatchDeleteBackup(req)
	case "WebAppsClient.DeleteBackupConfiguration":
		resp, err = w.dispatchDeleteBackupConfiguration(req)
	case "WebAppsClient.DeleteBackupConfigurationSlot":
		resp, err = w.dispatchDeleteBackupConfigurationSlot(req)
	case "WebAppsClient.DeleteBackupSlot":
		resp, err = w.dispatchDeleteBackupSlot(req)
	case "WebAppsClient.DeleteContinuousWebJob":
		resp, err = w.dispatchDeleteContinuousWebJob(req)
	case "WebAppsClient.DeleteContinuousWebJobSlot":
		resp, err = w.dispatchDeleteContinuousWebJobSlot(req)
	case "WebAppsClient.DeleteDeployment":
		resp, err = w.dispatchDeleteDeployment(req)
	case "WebAppsClient.DeleteDeploymentSlot":
		resp, err = w.dispatchDeleteDeploymentSlot(req)
	case "WebAppsClient.DeleteDomainOwnershipIdentifier":
		resp, err = w.dispatchDeleteDomainOwnershipIdentifier(req)
	case "WebAppsClient.DeleteDomainOwnershipIdentifierSlot":
		resp, err = w.dispatchDeleteDomainOwnershipIdentifierSlot(req)
	case "WebAppsClient.DeleteFunction":
		resp, err = w.dispatchDeleteFunction(req)
	case "WebAppsClient.DeleteFunctionSecret":
		resp, err = w.dispatchDeleteFunctionSecret(req)
	case "WebAppsClient.DeleteFunctionSecretSlot":
		resp, err = w.dispatchDeleteFunctionSecretSlot(req)
	case "WebAppsClient.DeleteHostNameBinding":
		resp, err = w.dispatchDeleteHostNameBinding(req)
	case "WebAppsClient.DeleteHostNameBindingSlot":
		resp, err = w.dispatchDeleteHostNameBindingSlot(req)
	case "WebAppsClient.DeleteHostSecret":
		resp, err = w.dispatchDeleteHostSecret(req)
	case "WebAppsClient.DeleteHostSecretSlot":
		resp, err = w.dispatchDeleteHostSecretSlot(req)
	case "WebAppsClient.DeleteHybridConnection":
		resp, err = w.dispatchDeleteHybridConnection(req)
	case "WebAppsClient.DeleteHybridConnectionSlot":
		resp, err = w.dispatchDeleteHybridConnectionSlot(req)
	case "WebAppsClient.DeleteInstanceFunctionSlot":
		resp, err = w.dispatchDeleteInstanceFunctionSlot(req)
	case "WebAppsClient.DeleteInstanceProcess":
		resp, err = w.dispatchDeleteInstanceProcess(req)
	case "WebAppsClient.DeleteInstanceProcessSlot":
		resp, err = w.dispatchDeleteInstanceProcessSlot(req)
	case "WebAppsClient.DeletePremierAddOn":
		resp, err = w.dispatchDeletePremierAddOn(req)
	case "WebAppsClient.DeletePremierAddOnSlot":
		resp, err = w.dispatchDeletePremierAddOnSlot(req)
	case "WebAppsClient.BeginDeletePrivateEndpointConnection":
		resp, err = w.dispatchBeginDeletePrivateEndpointConnection(req)
	case "WebAppsClient.BeginDeletePrivateEndpointConnectionSlot":
		resp, err = w.dispatchBeginDeletePrivateEndpointConnectionSlot(req)
	case "WebAppsClient.DeleteProcess":
		resp, err = w.dispatchDeleteProcess(req)
	case "WebAppsClient.DeleteProcessSlot":
		resp, err = w.dispatchDeleteProcessSlot(req)
	case "WebAppsClient.DeletePublicCertificate":
		resp, err = w.dispatchDeletePublicCertificate(req)
	case "WebAppsClient.DeletePublicCertificateSlot":
		resp, err = w.dispatchDeletePublicCertificateSlot(req)
	case "WebAppsClient.DeleteRelayServiceConnection":
		resp, err = w.dispatchDeleteRelayServiceConnection(req)
	case "WebAppsClient.DeleteRelayServiceConnectionSlot":
		resp, err = w.dispatchDeleteRelayServiceConnectionSlot(req)
	case "WebAppsClient.DeleteSiteExtension":
		resp, err = w.dispatchDeleteSiteExtension(req)
	case "WebAppsClient.DeleteSiteExtensionSlot":
		resp, err = w.dispatchDeleteSiteExtensionSlot(req)
	case "WebAppsClient.DeleteSlot":
		resp, err = w.dispatchDeleteSlot(req)
	case "WebAppsClient.DeleteSourceControl":
		resp, err = w.dispatchDeleteSourceControl(req)
	case "WebAppsClient.DeleteSourceControlSlot":
		resp, err = w.dispatchDeleteSourceControlSlot(req)
	case "WebAppsClient.DeleteSwiftVirtualNetwork":
		resp, err = w.dispatchDeleteSwiftVirtualNetwork(req)
	case "WebAppsClient.DeleteSwiftVirtualNetworkSlot":
		resp, err = w.dispatchDeleteSwiftVirtualNetworkSlot(req)
	case "WebAppsClient.DeleteTriggeredWebJob":
		resp, err = w.dispatchDeleteTriggeredWebJob(req)
	case "WebAppsClient.DeleteTriggeredWebJobSlot":
		resp, err = w.dispatchDeleteTriggeredWebJobSlot(req)
	case "WebAppsClient.DeleteVnetConnection":
		resp, err = w.dispatchDeleteVnetConnection(req)
	case "WebAppsClient.DeleteVnetConnectionSlot":
		resp, err = w.dispatchDeleteVnetConnectionSlot(req)
	case "WebAppsClient.DeployWorkflowArtifacts":
		resp, err = w.dispatchDeployWorkflowArtifacts(req)
	case "WebAppsClient.DeployWorkflowArtifactsSlot":
		resp, err = w.dispatchDeployWorkflowArtifactsSlot(req)
	case "WebAppsClient.DiscoverBackup":
		resp, err = w.dispatchDiscoverBackup(req)
	case "WebAppsClient.DiscoverBackupSlot":
		resp, err = w.dispatchDiscoverBackupSlot(req)
	case "WebAppsClient.GenerateNewSitePublishingPassword":
		resp, err = w.dispatchGenerateNewSitePublishingPassword(req)
	case "WebAppsClient.GenerateNewSitePublishingPasswordSlot":
		resp, err = w.dispatchGenerateNewSitePublishingPasswordSlot(req)
	case "WebAppsClient.Get":
		resp, err = w.dispatchGet(req)
	case "WebAppsClient.GetAppSettingKeyVaultReference":
		resp, err = w.dispatchGetAppSettingKeyVaultReference(req)
	case "WebAppsClient.GetAppSettingKeyVaultReferenceSlot":
		resp, err = w.dispatchGetAppSettingKeyVaultReferenceSlot(req)
	case "WebAppsClient.NewGetAppSettingsKeyVaultReferencesPager":
		resp, err = w.dispatchNewGetAppSettingsKeyVaultReferencesPager(req)
	case "WebAppsClient.NewGetAppSettingsKeyVaultReferencesSlotPager":
		resp, err = w.dispatchNewGetAppSettingsKeyVaultReferencesSlotPager(req)
	case "WebAppsClient.GetAuthSettings":
		resp, err = w.dispatchGetAuthSettings(req)
	case "WebAppsClient.GetAuthSettingsSlot":
		resp, err = w.dispatchGetAuthSettingsSlot(req)
	case "WebAppsClient.GetAuthSettingsV2":
		resp, err = w.dispatchGetAuthSettingsV2(req)
	case "WebAppsClient.GetAuthSettingsV2Slot":
		resp, err = w.dispatchGetAuthSettingsV2Slot(req)
	case "WebAppsClient.GetAuthSettingsV2WithoutSecrets":
		resp, err = w.dispatchGetAuthSettingsV2WithoutSecrets(req)
	case "WebAppsClient.GetAuthSettingsV2WithoutSecretsSlot":
		resp, err = w.dispatchGetAuthSettingsV2WithoutSecretsSlot(req)
	case "WebAppsClient.GetBackupConfiguration":
		resp, err = w.dispatchGetBackupConfiguration(req)
	case "WebAppsClient.GetBackupConfigurationSlot":
		resp, err = w.dispatchGetBackupConfigurationSlot(req)
	case "WebAppsClient.GetBackupStatus":
		resp, err = w.dispatchGetBackupStatus(req)
	case "WebAppsClient.GetBackupStatusSlot":
		resp, err = w.dispatchGetBackupStatusSlot(req)
	case "WebAppsClient.GetConfiguration":
		resp, err = w.dispatchGetConfiguration(req)
	case "WebAppsClient.GetConfigurationSlot":
		resp, err = w.dispatchGetConfigurationSlot(req)
	case "WebAppsClient.GetConfigurationSnapshot":
		resp, err = w.dispatchGetConfigurationSnapshot(req)
	case "WebAppsClient.GetConfigurationSnapshotSlot":
		resp, err = w.dispatchGetConfigurationSnapshotSlot(req)
	case "WebAppsClient.GetContainerLogsZip":
		resp, err = w.dispatchGetContainerLogsZip(req)
	case "WebAppsClient.GetContainerLogsZipSlot":
		resp, err = w.dispatchGetContainerLogsZipSlot(req)
	case "WebAppsClient.GetContinuousWebJob":
		resp, err = w.dispatchGetContinuousWebJob(req)
	case "WebAppsClient.GetContinuousWebJobSlot":
		resp, err = w.dispatchGetContinuousWebJobSlot(req)
	case "WebAppsClient.GetDeployment":
		resp, err = w.dispatchGetDeployment(req)
	case "WebAppsClient.GetDeploymentSlot":
		resp, err = w.dispatchGetDeploymentSlot(req)
	case "WebAppsClient.GetDiagnosticLogsConfiguration":
		resp, err = w.dispatchGetDiagnosticLogsConfiguration(req)
	case "WebAppsClient.GetDiagnosticLogsConfigurationSlot":
		resp, err = w.dispatchGetDiagnosticLogsConfigurationSlot(req)
	case "WebAppsClient.GetDomainOwnershipIdentifier":
		resp, err = w.dispatchGetDomainOwnershipIdentifier(req)
	case "WebAppsClient.GetDomainOwnershipIdentifierSlot":
		resp, err = w.dispatchGetDomainOwnershipIdentifierSlot(req)
	case "WebAppsClient.GetFtpAllowed":
		resp, err = w.dispatchGetFtpAllowed(req)
	case "WebAppsClient.GetFtpAllowedSlot":
		resp, err = w.dispatchGetFtpAllowedSlot(req)
	case "WebAppsClient.GetFunction":
		resp, err = w.dispatchGetFunction(req)
	case "WebAppsClient.GetFunctionsAdminToken":
		resp, err = w.dispatchGetFunctionsAdminToken(req)
	case "WebAppsClient.GetFunctionsAdminTokenSlot":
		resp, err = w.dispatchGetFunctionsAdminTokenSlot(req)
	case "WebAppsClient.GetHostNameBinding":
		resp, err = w.dispatchGetHostNameBinding(req)
	case "WebAppsClient.GetHostNameBindingSlot":
		resp, err = w.dispatchGetHostNameBindingSlot(req)
	case "WebAppsClient.GetHybridConnection":
		resp, err = w.dispatchGetHybridConnection(req)
	case "WebAppsClient.GetHybridConnectionSlot":
		resp, err = w.dispatchGetHybridConnectionSlot(req)
	case "WebAppsClient.GetInstanceFunctionSlot":
		resp, err = w.dispatchGetInstanceFunctionSlot(req)
	case "WebAppsClient.GetInstanceInfo":
		resp, err = w.dispatchGetInstanceInfo(req)
	case "WebAppsClient.GetInstanceInfoSlot":
		resp, err = w.dispatchGetInstanceInfoSlot(req)
	case "WebAppsClient.GetInstanceMSDeployLog":
		resp, err = w.dispatchGetInstanceMSDeployLog(req)
	case "WebAppsClient.GetInstanceMSDeployLogSlot":
		resp, err = w.dispatchGetInstanceMSDeployLogSlot(req)
	case "WebAppsClient.GetInstanceMsDeployStatus":
		resp, err = w.dispatchGetInstanceMsDeployStatus(req)
	case "WebAppsClient.GetInstanceMsDeployStatusSlot":
		resp, err = w.dispatchGetInstanceMsDeployStatusSlot(req)
	case "WebAppsClient.GetInstanceProcess":
		resp, err = w.dispatchGetInstanceProcess(req)
	case "WebAppsClient.GetInstanceProcessDump":
		resp, err = w.dispatchGetInstanceProcessDump(req)
	case "WebAppsClient.GetInstanceProcessDumpSlot":
		resp, err = w.dispatchGetInstanceProcessDumpSlot(req)
	case "WebAppsClient.GetInstanceProcessModule":
		resp, err = w.dispatchGetInstanceProcessModule(req)
	case "WebAppsClient.GetInstanceProcessModuleSlot":
		resp, err = w.dispatchGetInstanceProcessModuleSlot(req)
	case "WebAppsClient.GetInstanceProcessSlot":
		resp, err = w.dispatchGetInstanceProcessSlot(req)
	case "WebAppsClient.GetInstanceWorkflowSlot":
		resp, err = w.dispatchGetInstanceWorkflowSlot(req)
	case "WebAppsClient.GetMSDeployLog":
		resp, err = w.dispatchGetMSDeployLog(req)
	case "WebAppsClient.GetMSDeployLogSlot":
		resp, err = w.dispatchGetMSDeployLogSlot(req)
	case "WebAppsClient.GetMSDeployStatus":
		resp, err = w.dispatchGetMSDeployStatus(req)
	case "WebAppsClient.GetMSDeployStatusSlot":
		resp, err = w.dispatchGetMSDeployStatusSlot(req)
	case "WebAppsClient.GetMigrateMySQLStatus":
		resp, err = w.dispatchGetMigrateMySQLStatus(req)
	case "WebAppsClient.GetMigrateMySQLStatusSlot":
		resp, err = w.dispatchGetMigrateMySQLStatusSlot(req)
	case "WebAppsClient.GetNetworkTraceOperation":
		resp, err = w.dispatchGetNetworkTraceOperation(req)
	case "WebAppsClient.GetNetworkTraceOperationSlot":
		resp, err = w.dispatchGetNetworkTraceOperationSlot(req)
	case "WebAppsClient.GetNetworkTraceOperationSlotV2":
		resp, err = w.dispatchGetNetworkTraceOperationSlotV2(req)
	case "WebAppsClient.GetNetworkTraceOperationV2":
		resp, err = w.dispatchGetNetworkTraceOperationV2(req)
	case "WebAppsClient.GetNetworkTraces":
		resp, err = w.dispatchGetNetworkTraces(req)
	case "WebAppsClient.GetNetworkTracesSlot":
		resp, err = w.dispatchGetNetworkTracesSlot(req)
	case "WebAppsClient.GetNetworkTracesSlotV2":
		resp, err = w.dispatchGetNetworkTracesSlotV2(req)
	case "WebAppsClient.GetNetworkTracesV2":
		resp, err = w.dispatchGetNetworkTracesV2(req)
	case "WebAppsClient.GetOneDeployStatus":
		resp, err = w.dispatchGetOneDeployStatus(req)
	case "WebAppsClient.GetPremierAddOn":
		resp, err = w.dispatchGetPremierAddOn(req)
	case "WebAppsClient.GetPremierAddOnSlot":
		resp, err = w.dispatchGetPremierAddOnSlot(req)
	case "WebAppsClient.GetPrivateAccess":
		resp, err = w.dispatchGetPrivateAccess(req)
	case "WebAppsClient.GetPrivateAccessSlot":
		resp, err = w.dispatchGetPrivateAccessSlot(req)
	case "WebAppsClient.GetPrivateEndpointConnection":
		resp, err = w.dispatchGetPrivateEndpointConnection(req)
	case "WebAppsClient.NewGetPrivateEndpointConnectionListPager":
		resp, err = w.dispatchNewGetPrivateEndpointConnectionListPager(req)
	case "WebAppsClient.NewGetPrivateEndpointConnectionListSlotPager":
		resp, err = w.dispatchNewGetPrivateEndpointConnectionListSlotPager(req)
	case "WebAppsClient.GetPrivateEndpointConnectionSlot":
		resp, err = w.dispatchGetPrivateEndpointConnectionSlot(req)
	case "WebAppsClient.GetPrivateLinkResources":
		resp, err = w.dispatchGetPrivateLinkResources(req)
	case "WebAppsClient.GetPrivateLinkResourcesSlot":
		resp, err = w.dispatchGetPrivateLinkResourcesSlot(req)
	case "WebAppsClient.GetProcess":
		resp, err = w.dispatchGetProcess(req)
	case "WebAppsClient.GetProcessDump":
		resp, err = w.dispatchGetProcessDump(req)
	case "WebAppsClient.GetProcessDumpSlot":
		resp, err = w.dispatchGetProcessDumpSlot(req)
	case "WebAppsClient.GetProcessModule":
		resp, err = w.dispatchGetProcessModule(req)
	case "WebAppsClient.GetProcessModuleSlot":
		resp, err = w.dispatchGetProcessModuleSlot(req)
	case "WebAppsClient.GetProcessSlot":
		resp, err = w.dispatchGetProcessSlot(req)
	case "WebAppsClient.BeginGetProductionSiteDeploymentStatus":
		resp, err = w.dispatchBeginGetProductionSiteDeploymentStatus(req)
	case "WebAppsClient.GetPublicCertificate":
		resp, err = w.dispatchGetPublicCertificate(req)
	case "WebAppsClient.GetPublicCertificateSlot":
		resp, err = w.dispatchGetPublicCertificateSlot(req)
	case "WebAppsClient.GetRelayServiceConnection":
		resp, err = w.dispatchGetRelayServiceConnection(req)
	case "WebAppsClient.GetRelayServiceConnectionSlot":
		resp, err = w.dispatchGetRelayServiceConnectionSlot(req)
	case "WebAppsClient.GetScmAllowed":
		resp, err = w.dispatchGetScmAllowed(req)
	case "WebAppsClient.GetScmAllowedSlot":
		resp, err = w.dispatchGetScmAllowedSlot(req)
	case "WebAppsClient.GetSiteConnectionStringKeyVaultReference":
		resp, err = w.dispatchGetSiteConnectionStringKeyVaultReference(req)
	case "WebAppsClient.GetSiteConnectionStringKeyVaultReferenceSlot":
		resp, err = w.dispatchGetSiteConnectionStringKeyVaultReferenceSlot(req)
	case "WebAppsClient.NewGetSiteConnectionStringKeyVaultReferencesPager":
		resp, err = w.dispatchNewGetSiteConnectionStringKeyVaultReferencesPager(req)
	case "WebAppsClient.NewGetSiteConnectionStringKeyVaultReferencesSlotPager":
		resp, err = w.dispatchNewGetSiteConnectionStringKeyVaultReferencesSlotPager(req)
	case "WebAppsClient.GetSiteExtension":
		resp, err = w.dispatchGetSiteExtension(req)
	case "WebAppsClient.GetSiteExtensionSlot":
		resp, err = w.dispatchGetSiteExtensionSlot(req)
	case "WebAppsClient.GetSitePhpErrorLogFlag":
		resp, err = w.dispatchGetSitePhpErrorLogFlag(req)
	case "WebAppsClient.GetSitePhpErrorLogFlagSlot":
		resp, err = w.dispatchGetSitePhpErrorLogFlagSlot(req)
	case "WebAppsClient.GetSlot":
		resp, err = w.dispatchGetSlot(req)
	case "WebAppsClient.BeginGetSlotSiteDeploymentStatusSlot":
		resp, err = w.dispatchBeginGetSlotSiteDeploymentStatusSlot(req)
	case "WebAppsClient.GetSourceControl":
		resp, err = w.dispatchGetSourceControl(req)
	case "WebAppsClient.GetSourceControlSlot":
		resp, err = w.dispatchGetSourceControlSlot(req)
	case "WebAppsClient.GetSwiftVirtualNetworkConnection":
		resp, err = w.dispatchGetSwiftVirtualNetworkConnection(req)
	case "WebAppsClient.GetSwiftVirtualNetworkConnectionSlot":
		resp, err = w.dispatchGetSwiftVirtualNetworkConnectionSlot(req)
	case "WebAppsClient.GetTriggeredWebJob":
		resp, err = w.dispatchGetTriggeredWebJob(req)
	case "WebAppsClient.GetTriggeredWebJobHistory":
		resp, err = w.dispatchGetTriggeredWebJobHistory(req)
	case "WebAppsClient.GetTriggeredWebJobHistorySlot":
		resp, err = w.dispatchGetTriggeredWebJobHistorySlot(req)
	case "WebAppsClient.GetTriggeredWebJobSlot":
		resp, err = w.dispatchGetTriggeredWebJobSlot(req)
	case "WebAppsClient.GetVnetConnection":
		resp, err = w.dispatchGetVnetConnection(req)
	case "WebAppsClient.GetVnetConnectionGateway":
		resp, err = w.dispatchGetVnetConnectionGateway(req)
	case "WebAppsClient.GetVnetConnectionGatewaySlot":
		resp, err = w.dispatchGetVnetConnectionGatewaySlot(req)
	case "WebAppsClient.GetVnetConnectionSlot":
		resp, err = w.dispatchGetVnetConnectionSlot(req)
	case "WebAppsClient.GetWebJob":
		resp, err = w.dispatchGetWebJob(req)
	case "WebAppsClient.GetWebJobSlot":
		resp, err = w.dispatchGetWebJobSlot(req)
	case "WebAppsClient.GetWebSiteContainerLogs":
		resp, err = w.dispatchGetWebSiteContainerLogs(req)
	case "WebAppsClient.GetWebSiteContainerLogsSlot":
		resp, err = w.dispatchGetWebSiteContainerLogsSlot(req)
	case "WebAppsClient.GetWorkflow":
		resp, err = w.dispatchGetWorkflow(req)
	case "WebAppsClient.BeginInstallSiteExtension":
		resp, err = w.dispatchBeginInstallSiteExtension(req)
	case "WebAppsClient.BeginInstallSiteExtensionSlot":
		resp, err = w.dispatchBeginInstallSiteExtensionSlot(req)
	case "WebAppsClient.IsCloneable":
		resp, err = w.dispatchIsCloneable(req)
	case "WebAppsClient.IsCloneableSlot":
		resp, err = w.dispatchIsCloneableSlot(req)
	case "WebAppsClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WebAppsClient.ListApplicationSettings":
		resp, err = w.dispatchListApplicationSettings(req)
	case "WebAppsClient.ListApplicationSettingsSlot":
		resp, err = w.dispatchListApplicationSettingsSlot(req)
	case "WebAppsClient.ListAzureStorageAccounts":
		resp, err = w.dispatchListAzureStorageAccounts(req)
	case "WebAppsClient.ListAzureStorageAccountsSlot":
		resp, err = w.dispatchListAzureStorageAccountsSlot(req)
	case "WebAppsClient.ListBackupStatusSecrets":
		resp, err = w.dispatchListBackupStatusSecrets(req)
	case "WebAppsClient.ListBackupStatusSecretsSlot":
		resp, err = w.dispatchListBackupStatusSecretsSlot(req)
	case "WebAppsClient.NewListBackupsPager":
		resp, err = w.dispatchNewListBackupsPager(req)
	case "WebAppsClient.NewListBackupsSlotPager":
		resp, err = w.dispatchNewListBackupsSlotPager(req)
	case "WebAppsClient.NewListBasicPublishingCredentialsPoliciesPager":
		resp, err = w.dispatchNewListBasicPublishingCredentialsPoliciesPager(req)
	case "WebAppsClient.NewListBasicPublishingCredentialsPoliciesSlotPager":
		resp, err = w.dispatchNewListBasicPublishingCredentialsPoliciesSlotPager(req)
	case "WebAppsClient.NewListByResourceGroupPager":
		resp, err = w.dispatchNewListByResourceGroupPager(req)
	case "WebAppsClient.NewListConfigurationSnapshotInfoPager":
		resp, err = w.dispatchNewListConfigurationSnapshotInfoPager(req)
	case "WebAppsClient.NewListConfigurationSnapshotInfoSlotPager":
		resp, err = w.dispatchNewListConfigurationSnapshotInfoSlotPager(req)
	case "WebAppsClient.NewListConfigurationsPager":
		resp, err = w.dispatchNewListConfigurationsPager(req)
	case "WebAppsClient.NewListConfigurationsSlotPager":
		resp, err = w.dispatchNewListConfigurationsSlotPager(req)
	case "WebAppsClient.ListConnectionStrings":
		resp, err = w.dispatchListConnectionStrings(req)
	case "WebAppsClient.ListConnectionStringsSlot":
		resp, err = w.dispatchListConnectionStringsSlot(req)
	case "WebAppsClient.NewListContinuousWebJobsPager":
		resp, err = w.dispatchNewListContinuousWebJobsPager(req)
	case "WebAppsClient.NewListContinuousWebJobsSlotPager":
		resp, err = w.dispatchNewListContinuousWebJobsSlotPager(req)
	case "WebAppsClient.ListDeploymentLog":
		resp, err = w.dispatchListDeploymentLog(req)
	case "WebAppsClient.ListDeploymentLogSlot":
		resp, err = w.dispatchListDeploymentLogSlot(req)
	case "WebAppsClient.NewListDeploymentsPager":
		resp, err = w.dispatchNewListDeploymentsPager(req)
	case "WebAppsClient.NewListDeploymentsSlotPager":
		resp, err = w.dispatchNewListDeploymentsSlotPager(req)
	case "WebAppsClient.NewListDomainOwnershipIdentifiersPager":
		resp, err = w.dispatchNewListDomainOwnershipIdentifiersPager(req)
	case "WebAppsClient.NewListDomainOwnershipIdentifiersSlotPager":
		resp, err = w.dispatchNewListDomainOwnershipIdentifiersSlotPager(req)
	case "WebAppsClient.ListFunctionKeys":
		resp, err = w.dispatchListFunctionKeys(req)
	case "WebAppsClient.ListFunctionKeysSlot":
		resp, err = w.dispatchListFunctionKeysSlot(req)
	case "WebAppsClient.ListFunctionSecrets":
		resp, err = w.dispatchListFunctionSecrets(req)
	case "WebAppsClient.ListFunctionSecretsSlot":
		resp, err = w.dispatchListFunctionSecretsSlot(req)
	case "WebAppsClient.NewListFunctionsPager":
		resp, err = w.dispatchNewListFunctionsPager(req)
	case "WebAppsClient.ListHostKeys":
		resp, err = w.dispatchListHostKeys(req)
	case "WebAppsClient.ListHostKeysSlot":
		resp, err = w.dispatchListHostKeysSlot(req)
	case "WebAppsClient.NewListHostNameBindingsPager":
		resp, err = w.dispatchNewListHostNameBindingsPager(req)
	case "WebAppsClient.NewListHostNameBindingsSlotPager":
		resp, err = w.dispatchNewListHostNameBindingsSlotPager(req)
	case "WebAppsClient.ListHybridConnections":
		resp, err = w.dispatchListHybridConnections(req)
	case "WebAppsClient.ListHybridConnectionsSlot":
		resp, err = w.dispatchListHybridConnectionsSlot(req)
	case "WebAppsClient.NewListInstanceFunctionsSlotPager":
		resp, err = w.dispatchNewListInstanceFunctionsSlotPager(req)
	case "WebAppsClient.NewListInstanceIdentifiersPager":
		resp, err = w.dispatchNewListInstanceIdentifiersPager(req)
	case "WebAppsClient.NewListInstanceIdentifiersSlotPager":
		resp, err = w.dispatchNewListInstanceIdentifiersSlotPager(req)
	case "WebAppsClient.NewListInstanceProcessModulesPager":
		resp, err = w.dispatchNewListInstanceProcessModulesPager(req)
	case "WebAppsClient.NewListInstanceProcessModulesSlotPager":
		resp, err = w.dispatchNewListInstanceProcessModulesSlotPager(req)
	case "WebAppsClient.NewListInstanceProcessThreadsPager":
		resp, err = w.dispatchNewListInstanceProcessThreadsPager(req)
	case "WebAppsClient.NewListInstanceProcessThreadsSlotPager":
		resp, err = w.dispatchNewListInstanceProcessThreadsSlotPager(req)
	case "WebAppsClient.NewListInstanceProcessesPager":
		resp, err = w.dispatchNewListInstanceProcessesPager(req)
	case "WebAppsClient.NewListInstanceProcessesSlotPager":
		resp, err = w.dispatchNewListInstanceProcessesSlotPager(req)
	case "WebAppsClient.NewListInstanceWorkflowsSlotPager":
		resp, err = w.dispatchNewListInstanceWorkflowsSlotPager(req)
	case "WebAppsClient.ListMetadata":
		resp, err = w.dispatchListMetadata(req)
	case "WebAppsClient.ListMetadataSlot":
		resp, err = w.dispatchListMetadataSlot(req)
	case "WebAppsClient.ListNetworkFeatures":
		resp, err = w.dispatchListNetworkFeatures(req)
	case "WebAppsClient.ListNetworkFeaturesSlot":
		resp, err = w.dispatchListNetworkFeaturesSlot(req)
	case "WebAppsClient.NewListPerfMonCountersPager":
		resp, err = w.dispatchNewListPerfMonCountersPager(req)
	case "WebAppsClient.NewListPerfMonCountersSlotPager":
		resp, err = w.dispatchNewListPerfMonCountersSlotPager(req)
	case "WebAppsClient.ListPremierAddOns":
		resp, err = w.dispatchListPremierAddOns(req)
	case "WebAppsClient.ListPremierAddOnsSlot":
		resp, err = w.dispatchListPremierAddOnsSlot(req)
	case "WebAppsClient.NewListProcessModulesPager":
		resp, err = w.dispatchNewListProcessModulesPager(req)
	case "WebAppsClient.NewListProcessModulesSlotPager":
		resp, err = w.dispatchNewListProcessModulesSlotPager(req)
	case "WebAppsClient.NewListProcessThreadsPager":
		resp, err = w.dispatchNewListProcessThreadsPager(req)
	case "WebAppsClient.NewListProcessThreadsSlotPager":
		resp, err = w.dispatchNewListProcessThreadsSlotPager(req)
	case "WebAppsClient.NewListProcessesPager":
		resp, err = w.dispatchNewListProcessesPager(req)
	case "WebAppsClient.NewListProcessesSlotPager":
		resp, err = w.dispatchNewListProcessesSlotPager(req)
	case "WebAppsClient.NewListProductionSiteDeploymentStatusesPager":
		resp, err = w.dispatchNewListProductionSiteDeploymentStatusesPager(req)
	case "WebAppsClient.NewListPublicCertificatesPager":
		resp, err = w.dispatchNewListPublicCertificatesPager(req)
	case "WebAppsClient.NewListPublicCertificatesSlotPager":
		resp, err = w.dispatchNewListPublicCertificatesSlotPager(req)
	case "WebAppsClient.BeginListPublishingCredentials":
		resp, err = w.dispatchBeginListPublishingCredentials(req)
	case "WebAppsClient.BeginListPublishingCredentialsSlot":
		resp, err = w.dispatchBeginListPublishingCredentialsSlot(req)
	case "WebAppsClient.ListPublishingProfileXMLWithSecrets":
		resp, err = w.dispatchListPublishingProfileXMLWithSecrets(req)
	case "WebAppsClient.ListPublishingProfileXMLWithSecretsSlot":
		resp, err = w.dispatchListPublishingProfileXMLWithSecretsSlot(req)
	case "WebAppsClient.ListRelayServiceConnections":
		resp, err = w.dispatchListRelayServiceConnections(req)
	case "WebAppsClient.ListRelayServiceConnectionsSlot":
		resp, err = w.dispatchListRelayServiceConnectionsSlot(req)
	case "WebAppsClient.NewListSiteBackupsPager":
		resp, err = w.dispatchNewListSiteBackupsPager(req)
	case "WebAppsClient.NewListSiteBackupsSlotPager":
		resp, err = w.dispatchNewListSiteBackupsSlotPager(req)
	case "WebAppsClient.NewListSiteExtensionsPager":
		resp, err = w.dispatchNewListSiteExtensionsPager(req)
	case "WebAppsClient.NewListSiteExtensionsSlotPager":
		resp, err = w.dispatchNewListSiteExtensionsSlotPager(req)
	case "WebAppsClient.ListSitePushSettings":
		resp, err = w.dispatchListSitePushSettings(req)
	case "WebAppsClient.ListSitePushSettingsSlot":
		resp, err = w.dispatchListSitePushSettingsSlot(req)
	case "WebAppsClient.ListSlotConfigurationNames":
		resp, err = w.dispatchListSlotConfigurationNames(req)
	case "WebAppsClient.NewListSlotDifferencesFromProductionPager":
		resp, err = w.dispatchNewListSlotDifferencesFromProductionPager(req)
	case "WebAppsClient.NewListSlotDifferencesSlotPager":
		resp, err = w.dispatchNewListSlotDifferencesSlotPager(req)
	case "WebAppsClient.NewListSlotSiteDeploymentStatusesSlotPager":
		resp, err = w.dispatchNewListSlotSiteDeploymentStatusesSlotPager(req)
	case "WebAppsClient.NewListSlotsPager":
		resp, err = w.dispatchNewListSlotsPager(req)
	case "WebAppsClient.NewListSnapshotsPager":
		resp, err = w.dispatchNewListSnapshotsPager(req)
	case "WebAppsClient.NewListSnapshotsFromDRSecondaryPager":
		resp, err = w.dispatchNewListSnapshotsFromDRSecondaryPager(req)
	case "WebAppsClient.NewListSnapshotsFromDRSecondarySlotPager":
		resp, err = w.dispatchNewListSnapshotsFromDRSecondarySlotPager(req)
	case "WebAppsClient.NewListSnapshotsSlotPager":
		resp, err = w.dispatchNewListSnapshotsSlotPager(req)
	case "WebAppsClient.ListSyncFunctionTriggers":
		resp, err = w.dispatchListSyncFunctionTriggers(req)
	case "WebAppsClient.ListSyncFunctionTriggersSlot":
		resp, err = w.dispatchListSyncFunctionTriggersSlot(req)
	case "WebAppsClient.ListSyncStatus":
		resp, err = w.dispatchListSyncStatus(req)
	case "WebAppsClient.ListSyncStatusSlot":
		resp, err = w.dispatchListSyncStatusSlot(req)
	case "WebAppsClient.NewListTriggeredWebJobHistoryPager":
		resp, err = w.dispatchNewListTriggeredWebJobHistoryPager(req)
	case "WebAppsClient.NewListTriggeredWebJobHistorySlotPager":
		resp, err = w.dispatchNewListTriggeredWebJobHistorySlotPager(req)
	case "WebAppsClient.NewListTriggeredWebJobsPager":
		resp, err = w.dispatchNewListTriggeredWebJobsPager(req)
	case "WebAppsClient.NewListTriggeredWebJobsSlotPager":
		resp, err = w.dispatchNewListTriggeredWebJobsSlotPager(req)
	case "WebAppsClient.NewListUsagesPager":
		resp, err = w.dispatchNewListUsagesPager(req)
	case "WebAppsClient.NewListUsagesSlotPager":
		resp, err = w.dispatchNewListUsagesSlotPager(req)
	case "WebAppsClient.ListVnetConnections":
		resp, err = w.dispatchListVnetConnections(req)
	case "WebAppsClient.ListVnetConnectionsSlot":
		resp, err = w.dispatchListVnetConnectionsSlot(req)
	case "WebAppsClient.NewListWebJobsPager":
		resp, err = w.dispatchNewListWebJobsPager(req)
	case "WebAppsClient.NewListWebJobsSlotPager":
		resp, err = w.dispatchNewListWebJobsSlotPager(req)
	case "WebAppsClient.NewListWorkflowsPager":
		resp, err = w.dispatchNewListWorkflowsPager(req)
	case "WebAppsClient.ListWorkflowsConnections":
		resp, err = w.dispatchListWorkflowsConnections(req)
	case "WebAppsClient.ListWorkflowsConnectionsSlot":
		resp, err = w.dispatchListWorkflowsConnectionsSlot(req)
	case "WebAppsClient.BeginMigrateMySQL":
		resp, err = w.dispatchBeginMigrateMySQL(req)
	case "WebAppsClient.BeginMigrateStorage":
		resp, err = w.dispatchBeginMigrateStorage(req)
	case "WebAppsClient.PutPrivateAccessVnet":
		resp, err = w.dispatchPutPrivateAccessVnet(req)
	case "WebAppsClient.PutPrivateAccessVnetSlot":
		resp, err = w.dispatchPutPrivateAccessVnetSlot(req)
	case "WebAppsClient.RecoverSiteConfigurationSnapshot":
		resp, err = w.dispatchRecoverSiteConfigurationSnapshot(req)
	case "WebAppsClient.RecoverSiteConfigurationSnapshotSlot":
		resp, err = w.dispatchRecoverSiteConfigurationSnapshotSlot(req)
	case "WebAppsClient.ResetProductionSlotConfig":
		resp, err = w.dispatchResetProductionSlotConfig(req)
	case "WebAppsClient.ResetSlotConfigurationSlot":
		resp, err = w.dispatchResetSlotConfigurationSlot(req)
	case "WebAppsClient.Restart":
		resp, err = w.dispatchRestart(req)
	case "WebAppsClient.RestartSlot":
		resp, err = w.dispatchRestartSlot(req)
	case "WebAppsClient.BeginRestore":
		resp, err = w.dispatchBeginRestore(req)
	case "WebAppsClient.BeginRestoreFromBackupBlob":
		resp, err = w.dispatchBeginRestoreFromBackupBlob(req)
	case "WebAppsClient.BeginRestoreFromBackupBlobSlot":
		resp, err = w.dispatchBeginRestoreFromBackupBlobSlot(req)
	case "WebAppsClient.BeginRestoreFromDeletedApp":
		resp, err = w.dispatchBeginRestoreFromDeletedApp(req)
	case "WebAppsClient.BeginRestoreFromDeletedAppSlot":
		resp, err = w.dispatchBeginRestoreFromDeletedAppSlot(req)
	case "WebAppsClient.BeginRestoreSlot":
		resp, err = w.dispatchBeginRestoreSlot(req)
	case "WebAppsClient.BeginRestoreSnapshot":
		resp, err = w.dispatchBeginRestoreSnapshot(req)
	case "WebAppsClient.BeginRestoreSnapshotSlot":
		resp, err = w.dispatchBeginRestoreSnapshotSlot(req)
	case "WebAppsClient.RunTriggeredWebJob":
		resp, err = w.dispatchRunTriggeredWebJob(req)
	case "WebAppsClient.RunTriggeredWebJobSlot":
		resp, err = w.dispatchRunTriggeredWebJobSlot(req)
	case "WebAppsClient.Start":
		resp, err = w.dispatchStart(req)
	case "WebAppsClient.StartContinuousWebJob":
		resp, err = w.dispatchStartContinuousWebJob(req)
	case "WebAppsClient.StartContinuousWebJobSlot":
		resp, err = w.dispatchStartContinuousWebJobSlot(req)
	case "WebAppsClient.BeginStartNetworkTrace":
		resp, err = w.dispatchBeginStartNetworkTrace(req)
	case "WebAppsClient.BeginStartNetworkTraceSlot":
		resp, err = w.dispatchBeginStartNetworkTraceSlot(req)
	case "WebAppsClient.StartSlot":
		resp, err = w.dispatchStartSlot(req)
	case "WebAppsClient.StartWebSiteNetworkTrace":
		resp, err = w.dispatchStartWebSiteNetworkTrace(req)
	case "WebAppsClient.BeginStartWebSiteNetworkTraceOperation":
		resp, err = w.dispatchBeginStartWebSiteNetworkTraceOperation(req)
	case "WebAppsClient.BeginStartWebSiteNetworkTraceOperationSlot":
		resp, err = w.dispatchBeginStartWebSiteNetworkTraceOperationSlot(req)
	case "WebAppsClient.StartWebSiteNetworkTraceSlot":
		resp, err = w.dispatchStartWebSiteNetworkTraceSlot(req)
	case "WebAppsClient.Stop":
		resp, err = w.dispatchStop(req)
	case "WebAppsClient.StopContinuousWebJob":
		resp, err = w.dispatchStopContinuousWebJob(req)
	case "WebAppsClient.StopContinuousWebJobSlot":
		resp, err = w.dispatchStopContinuousWebJobSlot(req)
	case "WebAppsClient.StopNetworkTrace":
		resp, err = w.dispatchStopNetworkTrace(req)
	case "WebAppsClient.StopNetworkTraceSlot":
		resp, err = w.dispatchStopNetworkTraceSlot(req)
	case "WebAppsClient.StopSlot":
		resp, err = w.dispatchStopSlot(req)
	case "WebAppsClient.StopWebSiteNetworkTrace":
		resp, err = w.dispatchStopWebSiteNetworkTrace(req)
	case "WebAppsClient.StopWebSiteNetworkTraceSlot":
		resp, err = w.dispatchStopWebSiteNetworkTraceSlot(req)
	case "WebAppsClient.BeginSwapSlot":
		resp, err = w.dispatchBeginSwapSlot(req)
	case "WebAppsClient.BeginSwapSlotWithProduction":
		resp, err = w.dispatchBeginSwapSlotWithProduction(req)
	case "WebAppsClient.SyncFunctionTriggers":
		resp, err = w.dispatchSyncFunctionTriggers(req)
	case "WebAppsClient.SyncFunctionTriggersSlot":
		resp, err = w.dispatchSyncFunctionTriggersSlot(req)
	case "WebAppsClient.SyncFunctions":
		resp, err = w.dispatchSyncFunctions(req)
	case "WebAppsClient.SyncFunctionsSlot":
		resp, err = w.dispatchSyncFunctionsSlot(req)
	case "WebAppsClient.SyncRepository":
		resp, err = w.dispatchSyncRepository(req)
	case "WebAppsClient.SyncRepositorySlot":
		resp, err = w.dispatchSyncRepositorySlot(req)
	case "WebAppsClient.Update":
		resp, err = w.dispatchUpdate(req)
	case "WebAppsClient.UpdateApplicationSettings":
		resp, err = w.dispatchUpdateApplicationSettings(req)
	case "WebAppsClient.UpdateApplicationSettingsSlot":
		resp, err = w.dispatchUpdateApplicationSettingsSlot(req)
	case "WebAppsClient.UpdateAuthSettings":
		resp, err = w.dispatchUpdateAuthSettings(req)
	case "WebAppsClient.UpdateAuthSettingsSlot":
		resp, err = w.dispatchUpdateAuthSettingsSlot(req)
	case "WebAppsClient.UpdateAuthSettingsV2":
		resp, err = w.dispatchUpdateAuthSettingsV2(req)
	case "WebAppsClient.UpdateAuthSettingsV2Slot":
		resp, err = w.dispatchUpdateAuthSettingsV2Slot(req)
	case "WebAppsClient.UpdateAzureStorageAccounts":
		resp, err = w.dispatchUpdateAzureStorageAccounts(req)
	case "WebAppsClient.UpdateAzureStorageAccountsSlot":
		resp, err = w.dispatchUpdateAzureStorageAccountsSlot(req)
	case "WebAppsClient.UpdateBackupConfiguration":
		resp, err = w.dispatchUpdateBackupConfiguration(req)
	case "WebAppsClient.UpdateBackupConfigurationSlot":
		resp, err = w.dispatchUpdateBackupConfigurationSlot(req)
	case "WebAppsClient.UpdateConfiguration":
		resp, err = w.dispatchUpdateConfiguration(req)
	case "WebAppsClient.UpdateConfigurationSlot":
		resp, err = w.dispatchUpdateConfigurationSlot(req)
	case "WebAppsClient.UpdateConnectionStrings":
		resp, err = w.dispatchUpdateConnectionStrings(req)
	case "WebAppsClient.UpdateConnectionStringsSlot":
		resp, err = w.dispatchUpdateConnectionStringsSlot(req)
	case "WebAppsClient.UpdateDiagnosticLogsConfig":
		resp, err = w.dispatchUpdateDiagnosticLogsConfig(req)
	case "WebAppsClient.UpdateDiagnosticLogsConfigSlot":
		resp, err = w.dispatchUpdateDiagnosticLogsConfigSlot(req)
	case "WebAppsClient.UpdateDomainOwnershipIdentifier":
		resp, err = w.dispatchUpdateDomainOwnershipIdentifier(req)
	case "WebAppsClient.UpdateDomainOwnershipIdentifierSlot":
		resp, err = w.dispatchUpdateDomainOwnershipIdentifierSlot(req)
	case "WebAppsClient.UpdateFtpAllowed":
		resp, err = w.dispatchUpdateFtpAllowed(req)
	case "WebAppsClient.UpdateFtpAllowedSlot":
		resp, err = w.dispatchUpdateFtpAllowedSlot(req)
	case "WebAppsClient.UpdateHybridConnection":
		resp, err = w.dispatchUpdateHybridConnection(req)
	case "WebAppsClient.UpdateHybridConnectionSlot":
		resp, err = w.dispatchUpdateHybridConnectionSlot(req)
	case "WebAppsClient.UpdateMetadata":
		resp, err = w.dispatchUpdateMetadata(req)
	case "WebAppsClient.UpdateMetadataSlot":
		resp, err = w.dispatchUpdateMetadataSlot(req)
	case "WebAppsClient.UpdatePremierAddOn":
		resp, err = w.dispatchUpdatePremierAddOn(req)
	case "WebAppsClient.UpdatePremierAddOnSlot":
		resp, err = w.dispatchUpdatePremierAddOnSlot(req)
	case "WebAppsClient.UpdateRelayServiceConnection":
		resp, err = w.dispatchUpdateRelayServiceConnection(req)
	case "WebAppsClient.UpdateRelayServiceConnectionSlot":
		resp, err = w.dispatchUpdateRelayServiceConnectionSlot(req)
	case "WebAppsClient.UpdateScmAllowed":
		resp, err = w.dispatchUpdateScmAllowed(req)
	case "WebAppsClient.UpdateScmAllowedSlot":
		resp, err = w.dispatchUpdateScmAllowedSlot(req)
	case "WebAppsClient.UpdateSitePushSettings":
		resp, err = w.dispatchUpdateSitePushSettings(req)
	case "WebAppsClient.UpdateSitePushSettingsSlot":
		resp, err = w.dispatchUpdateSitePushSettingsSlot(req)
	case "WebAppsClient.UpdateSlot":
		resp, err = w.dispatchUpdateSlot(req)
	case "WebAppsClient.UpdateSlotConfigurationNames":
		resp, err = w.dispatchUpdateSlotConfigurationNames(req)
	case "WebAppsClient.UpdateSourceControl":
		resp, err = w.dispatchUpdateSourceControl(req)
	case "WebAppsClient.UpdateSourceControlSlot":
		resp, err = w.dispatchUpdateSourceControlSlot(req)
	case "WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheck":
		resp, err = w.dispatchUpdateSwiftVirtualNetworkConnectionWithCheck(req)
	case "WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheckSlot":
		resp, err = w.dispatchUpdateSwiftVirtualNetworkConnectionWithCheckSlot(req)
	case "WebAppsClient.UpdateVnetConnection":
		resp, err = w.dispatchUpdateVnetConnection(req)
	case "WebAppsClient.UpdateVnetConnectionGateway":
		resp, err = w.dispatchUpdateVnetConnectionGateway(req)
	case "WebAppsClient.UpdateVnetConnectionGatewaySlot":
		resp, err = w.dispatchUpdateVnetConnectionGatewaySlot(req)
	case "WebAppsClient.UpdateVnetConnectionSlot":
		resp, err = w.dispatchUpdateVnetConnectionSlot(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchAddPremierAddOn(req *http.Request) (*http.Response, error) {
	if w.srv.AddPremierAddOn == nil {
		return nil, &nonRetriableError{errors.New("fake for method AddPremierAddOn not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons/(?P<premierAddOnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PremierAddOn](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	premierAddOnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("premierAddOnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.AddPremierAddOn(req.Context(), resourceGroupNameParam, nameParam, premierAddOnNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PremierAddOn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchAddPremierAddOnSlot(req *http.Request) (*http.Response, error) {
	if w.srv.AddPremierAddOnSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method AddPremierAddOnSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons/(?P<premierAddOnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PremierAddOn](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	premierAddOnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("premierAddOnName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.AddPremierAddOnSlot(req.Context(), resourceGroupNameParam, nameParam, premierAddOnNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PremierAddOn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchAnalyzeCustomHostname(req *http.Request) (*http.Response, error) {
	if w.srv.AnalyzeCustomHostname == nil {
		return nil, &nonRetriableError{errors.New("fake for method AnalyzeCustomHostname not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyzeCustomHostname`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	hostNameUnescaped, err := url.QueryUnescape(qp.Get("hostName"))
	if err != nil {
		return nil, err
	}
	hostNameParam := getOptional(hostNameUnescaped)
	var options *armappservice.WebAppsClientAnalyzeCustomHostnameOptions
	if hostNameParam != nil {
		options = &armappservice.WebAppsClientAnalyzeCustomHostnameOptions{
			HostName: hostNameParam,
		}
	}
	respr, errRespr := w.srv.AnalyzeCustomHostname(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomHostnameAnalysisResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchAnalyzeCustomHostnameSlot(req *http.Request) (*http.Response, error) {
	if w.srv.AnalyzeCustomHostnameSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method AnalyzeCustomHostnameSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyzeCustomHostname`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	hostNameUnescaped, err := url.QueryUnescape(qp.Get("hostName"))
	if err != nil {
		return nil, err
	}
	hostNameParam := getOptional(hostNameUnescaped)
	var options *armappservice.WebAppsClientAnalyzeCustomHostnameSlotOptions
	if hostNameParam != nil {
		options = &armappservice.WebAppsClientAnalyzeCustomHostnameSlotOptions{
			HostName: hostNameParam,
		}
	}
	respr, errRespr := w.srv.AnalyzeCustomHostnameSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomHostnameAnalysisResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchApplySlotConfigToProduction(req *http.Request) (*http.Response, error) {
	if w.srv.ApplySlotConfigToProduction == nil {
		return nil, &nonRetriableError{errors.New("fake for method ApplySlotConfigToProduction not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applySlotConfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CsmSlotEntity](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ApplySlotConfigToProduction(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchApplySlotConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ApplySlotConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ApplySlotConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applySlotConfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CsmSlotEntity](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ApplySlotConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginApproveOrRejectPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if w.srv.BeginApproveOrRejectPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginApproveOrRejectPrivateEndpointConnection not implemented")}
	}
	beginApproveOrRejectPrivateEndpointConnection := w.beginApproveOrRejectPrivateEndpointConnection.get(req)
	if beginApproveOrRejectPrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.PrivateLinkConnectionApprovalRequestResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginApproveOrRejectPrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginApproveOrRejectPrivateEndpointConnection = &respr
		w.beginApproveOrRejectPrivateEndpointConnection.add(req, beginApproveOrRejectPrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginApproveOrRejectPrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginApproveOrRejectPrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginApproveOrRejectPrivateEndpointConnection) {
		w.beginApproveOrRejectPrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginApproveOrRejectPrivateEndpointConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginApproveOrRejectPrivateEndpointConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginApproveOrRejectPrivateEndpointConnectionSlot not implemented")}
	}
	beginApproveOrRejectPrivateEndpointConnectionSlot := w.beginApproveOrRejectPrivateEndpointConnectionSlot.get(req)
	if beginApproveOrRejectPrivateEndpointConnectionSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.PrivateLinkConnectionApprovalRequestResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginApproveOrRejectPrivateEndpointConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginApproveOrRejectPrivateEndpointConnectionSlot = &respr
		w.beginApproveOrRejectPrivateEndpointConnectionSlot.add(req, beginApproveOrRejectPrivateEndpointConnectionSlot)
	}

	resp, err := server.PollerResponderNext(beginApproveOrRejectPrivateEndpointConnectionSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginApproveOrRejectPrivateEndpointConnectionSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginApproveOrRejectPrivateEndpointConnectionSlot) {
		w.beginApproveOrRejectPrivateEndpointConnectionSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBackup(req *http.Request) (*http.Response, error) {
	if w.srv.Backup == nil {
		return nil, &nonRetriableError{errors.New("fake for method Backup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.BackupRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Backup(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBackupSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BackupSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BackupSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.BackupRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.BackupSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateDeployment(req *http.Request) (*http.Response, error) {
	if w.srv.CreateDeployment == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateDeployment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.Deployment](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateDeployment(req.Context(), resourceGroupNameParam, nameParam, idParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Deployment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateDeploymentSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateDeploymentSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateDeploymentSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.Deployment](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateDeploymentSlot(req.Context(), resourceGroupNameParam, nameParam, idParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Deployment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateFunction(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateFunction == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateFunction not implemented")}
	}
	beginCreateFunction := w.beginCreateFunction.get(req)
	if beginCreateFunction == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.FunctionEnvelope](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateFunction(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateFunction = &respr
		w.beginCreateFunction.add(req, beginCreateFunction)
	}

	resp, err := server.PollerResponderNext(beginCreateFunction, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		w.beginCreateFunction.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateFunction) {
		w.beginCreateFunction.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateInstanceFunctionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateInstanceFunctionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateInstanceFunctionSlot not implemented")}
	}
	beginCreateInstanceFunctionSlot := w.beginCreateInstanceFunctionSlot.get(req)
	if beginCreateInstanceFunctionSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.FunctionEnvelope](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateInstanceFunctionSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateInstanceFunctionSlot = &respr
		w.beginCreateInstanceFunctionSlot.add(req, beginCreateInstanceFunctionSlot)
	}

	resp, err := server.PollerResponderNext(beginCreateInstanceFunctionSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		w.beginCreateInstanceFunctionSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateInstanceFunctionSlot) {
		w.beginCreateInstanceFunctionSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateInstanceMSDeployOperation(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateInstanceMSDeployOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateInstanceMSDeployOperation not implemented")}
	}
	beginCreateInstanceMSDeployOperation := w.beginCreateInstanceMSDeployOperation.get(req)
	if beginCreateInstanceMSDeployOperation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.MSDeploy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateInstanceMSDeployOperation(req.Context(), resourceGroupNameParam, nameParam, instanceIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateInstanceMSDeployOperation = &respr
		w.beginCreateInstanceMSDeployOperation.add(req, beginCreateInstanceMSDeployOperation)
	}

	resp, err := server.PollerResponderNext(beginCreateInstanceMSDeployOperation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		w.beginCreateInstanceMSDeployOperation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateInstanceMSDeployOperation) {
		w.beginCreateInstanceMSDeployOperation.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateInstanceMSDeployOperationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateInstanceMSDeployOperationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateInstanceMSDeployOperationSlot not implemented")}
	}
	beginCreateInstanceMSDeployOperationSlot := w.beginCreateInstanceMSDeployOperationSlot.get(req)
	if beginCreateInstanceMSDeployOperationSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.MSDeploy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateInstanceMSDeployOperationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, instanceIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateInstanceMSDeployOperationSlot = &respr
		w.beginCreateInstanceMSDeployOperationSlot.add(req, beginCreateInstanceMSDeployOperationSlot)
	}

	resp, err := server.PollerResponderNext(beginCreateInstanceMSDeployOperationSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		w.beginCreateInstanceMSDeployOperationSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateInstanceMSDeployOperationSlot) {
		w.beginCreateInstanceMSDeployOperationSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateMSDeployOperation(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateMSDeployOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateMSDeployOperation not implemented")}
	}
	beginCreateMSDeployOperation := w.beginCreateMSDeployOperation.get(req)
	if beginCreateMSDeployOperation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.MSDeploy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateMSDeployOperation(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateMSDeployOperation = &respr
		w.beginCreateMSDeployOperation.add(req, beginCreateMSDeployOperation)
	}

	resp, err := server.PollerResponderNext(beginCreateMSDeployOperation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		w.beginCreateMSDeployOperation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateMSDeployOperation) {
		w.beginCreateMSDeployOperation.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateMSDeployOperationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateMSDeployOperationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateMSDeployOperationSlot not implemented")}
	}
	beginCreateMSDeployOperationSlot := w.beginCreateMSDeployOperationSlot.get(req)
	if beginCreateMSDeployOperationSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.MSDeploy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateMSDeployOperationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateMSDeployOperationSlot = &respr
		w.beginCreateMSDeployOperationSlot.add(req, beginCreateMSDeployOperationSlot)
	}

	resp, err := server.PollerResponderNext(beginCreateMSDeployOperationSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		w.beginCreateMSDeployOperationSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateMSDeployOperationSlot) {
		w.beginCreateMSDeployOperationSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOneDeployOperation(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOneDeployOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOneDeployOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/onedeploy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOneDeployOperation(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := w.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.Site](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		w.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		w.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteConfigResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateConfiguration(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteConfigResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateDomainOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateDomainOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateDomainOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.Identifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateDomainOwnershipIdentifier(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Identifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateDomainOwnershipIdentifierSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateDomainOwnershipIdentifierSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateDomainOwnershipIdentifierSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.Identifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateDomainOwnershipIdentifierSlot(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Identifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateFunctionSecret(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateFunctionSecret == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateFunctionSecret not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/keys/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.KeyInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateFunctionSecret(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, keyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateFunctionSecretSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateFunctionSecretSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateFunctionSecretSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/keys/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.KeyInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateFunctionSecretSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, keyNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateHostNameBinding(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateHostNameBinding == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateHostNameBinding not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings/(?P<hostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.HostNameBinding](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	hostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateHostNameBinding(req.Context(), resourceGroupNameParam, nameParam, hostNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostNameBinding, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateHostNameBindingSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateHostNameBindingSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateHostNameBindingSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings/(?P<hostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.HostNameBinding](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	hostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateHostNameBindingSlot(req.Context(), resourceGroupNameParam, nameParam, hostNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostNameBinding, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateHostSecret(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateHostSecret == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateHostSecret not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/(?P<keyType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.KeyInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	keyTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyType")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateHostSecret(req.Context(), resourceGroupNameParam, nameParam, keyTypeParam, keyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateHostSecretSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateHostSecretSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateHostSecretSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/(?P<keyType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.KeyInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	keyTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyType")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateHostSecretSlot(req.Context(), resourceGroupNameParam, nameParam, keyTypeParam, keyNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateHybridConnection(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateHybridConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateHybridConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.HybridConnection](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateHybridConnection(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateHybridConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateHybridConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateHybridConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.HybridConnection](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateHybridConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdatePublicCertificate(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdatePublicCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdatePublicCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates/(?P<publicCertificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PublicCertificate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	publicCertificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicCertificateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdatePublicCertificate(req.Context(), resourceGroupNameParam, nameParam, publicCertificateNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicCertificate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdatePublicCertificateSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdatePublicCertificateSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdatePublicCertificateSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates/(?P<publicCertificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PublicCertificate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	publicCertificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicCertificateName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdatePublicCertificateSlot(req.Context(), resourceGroupNameParam, nameParam, publicCertificateNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicCertificate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateRelayServiceConnection(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateRelayServiceConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateRelayServiceConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection/(?P<entityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.RelayServiceConnectionEntity](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	entityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("entityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateRelayServiceConnection(req.Context(), resourceGroupNameParam, nameParam, entityNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RelayServiceConnectionEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateRelayServiceConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateRelayServiceConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateRelayServiceConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection/(?P<entityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.RelayServiceConnectionEntity](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	entityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("entityName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateRelayServiceConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, entityNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RelayServiceConnectionEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateOrUpdateSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateOrUpdateSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateSlot not implemented")}
	}
	beginCreateOrUpdateSlot := w.beginCreateOrUpdateSlot.get(req)
	if beginCreateOrUpdateSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.Site](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateOrUpdateSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateSlot = &respr
		w.beginCreateOrUpdateSlot.add(req, beginCreateOrUpdateSlot)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginCreateOrUpdateSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateSlot) {
		w.beginCreateOrUpdateSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateOrUpdateSourceControl(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateOrUpdateSourceControl == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateSourceControl not implemented")}
	}
	beginCreateOrUpdateSourceControl := w.beginCreateOrUpdateSourceControl.get(req)
	if beginCreateOrUpdateSourceControl == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/web`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.SiteSourceControl](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateOrUpdateSourceControl(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateSourceControl = &respr
		w.beginCreateOrUpdateSourceControl.add(req, beginCreateOrUpdateSourceControl)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateSourceControl, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		w.beginCreateOrUpdateSourceControl.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateSourceControl) {
		w.beginCreateOrUpdateSourceControl.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginCreateOrUpdateSourceControlSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateOrUpdateSourceControlSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateSourceControlSlot not implemented")}
	}
	beginCreateOrUpdateSourceControlSlot := w.beginCreateOrUpdateSourceControlSlot.get(req)
	if beginCreateOrUpdateSourceControlSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/web`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.SiteSourceControl](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateOrUpdateSourceControlSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateSourceControlSlot = &respr
		w.beginCreateOrUpdateSourceControlSlot.add(req, beginCreateOrUpdateSourceControlSlot)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateSourceControlSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		w.beginCreateOrUpdateSourceControlSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateSourceControlSlot) {
		w.beginCreateOrUpdateSourceControlSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateSwiftVirtualNetworkConnectionWithCheck(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfig/virtualNetwork`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SwiftVirtualNetwork](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SwiftVirtualNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfig/virtualNetwork`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SwiftVirtualNetwork](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SwiftVirtualNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateVnetConnection(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateVnetConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateVnetConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetInfoResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateVnetConnection(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateVnetConnectionGateway(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateVnetConnectionGateway == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateVnetConnectionGateway not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gateways/(?P<gatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetGateway](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	gatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateVnetConnectionGateway(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, gatewayNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateVnetConnectionGatewaySlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateVnetConnectionGatewaySlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateVnetConnectionGatewaySlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gateways/(?P<gatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetGateway](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	gatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateVnetConnectionGatewaySlot(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, gatewayNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchCreateOrUpdateVnetConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdateVnetConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateVnetConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetInfoResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdateVnetConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if w.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	deleteMetricsUnescaped, err := url.QueryUnescape(qp.Get("deleteMetrics"))
	if err != nil {
		return nil, err
	}
	deleteMetricsParam, err := parseOptional(deleteMetricsUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	deleteEmptyServerFarmUnescaped, err := url.QueryUnescape(qp.Get("deleteEmptyServerFarm"))
	if err != nil {
		return nil, err
	}
	deleteEmptyServerFarmParam, err := parseOptional(deleteEmptyServerFarmUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.WebAppsClientDeleteOptions
	if deleteMetricsParam != nil || deleteEmptyServerFarmParam != nil {
		options = &armappservice.WebAppsClientDeleteOptions{
			DeleteMetrics:         deleteMetricsParam,
			DeleteEmptyServerFarm: deleteEmptyServerFarmParam,
		}
	}
	respr, errRespr := w.srv.Delete(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteBackup(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteBackup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteBackup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteBackup(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteBackupConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteBackupConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteBackupConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteBackupConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteBackupConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteBackupConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteBackupConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteBackupConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteBackupSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteBackupSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteBackupSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteBackupSlot(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteContinuousWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteContinuousWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteContinuousWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteContinuousWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteContinuousWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteContinuousWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteContinuousWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteContinuousWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteDeployment(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteDeployment == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDeployment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteDeployment(req.Context(), resourceGroupNameParam, nameParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteDeploymentSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteDeploymentSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDeploymentSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteDeploymentSlot(req.Context(), resourceGroupNameParam, nameParam, idParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteDomainOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteDomainOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDomainOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteDomainOwnershipIdentifier(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteDomainOwnershipIdentifierSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteDomainOwnershipIdentifierSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDomainOwnershipIdentifierSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteDomainOwnershipIdentifierSlot(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteFunction(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteFunction == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteFunction not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteFunction(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteFunctionSecret(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteFunctionSecret == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteFunctionSecret not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/keys/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteFunctionSecret(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, keyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteFunctionSecretSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteFunctionSecretSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteFunctionSecretSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/keys/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteFunctionSecretSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, keyNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteHostNameBinding(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteHostNameBinding == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHostNameBinding not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings/(?P<hostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	hostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteHostNameBinding(req.Context(), resourceGroupNameParam, nameParam, hostNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteHostNameBindingSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteHostNameBindingSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHostNameBindingSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings/(?P<hostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	hostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteHostNameBindingSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, hostNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteHostSecret(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteHostSecret == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHostSecret not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/(?P<keyType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	keyTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyType")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteHostSecret(req.Context(), resourceGroupNameParam, nameParam, keyTypeParam, keyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteHostSecretSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteHostSecretSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHostSecretSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/(?P<keyType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	keyTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyType")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteHostSecretSlot(req.Context(), resourceGroupNameParam, nameParam, keyTypeParam, keyNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteHybridConnection(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteHybridConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHybridConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteHybridConnection(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteHybridConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteHybridConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHybridConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteHybridConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteInstanceFunctionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteInstanceFunctionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteInstanceFunctionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteInstanceFunctionSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteInstanceProcess(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteInstanceProcess == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteInstanceProcess not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteInstanceProcess(req.Context(), resourceGroupNameParam, nameParam, processIDParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteInstanceProcessSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteInstanceProcessSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteInstanceProcessSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteInstanceProcessSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, slotParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeletePremierAddOn(req *http.Request) (*http.Response, error) {
	if w.srv.DeletePremierAddOn == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeletePremierAddOn not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons/(?P<premierAddOnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	premierAddOnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("premierAddOnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeletePremierAddOn(req.Context(), resourceGroupNameParam, nameParam, premierAddOnNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeletePremierAddOnSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeletePremierAddOnSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeletePremierAddOnSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons/(?P<premierAddOnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	premierAddOnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("premierAddOnName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeletePremierAddOnSlot(req.Context(), resourceGroupNameParam, nameParam, premierAddOnNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginDeletePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeletePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePrivateEndpointConnection not implemented")}
	}
	beginDeletePrivateEndpointConnection := w.beginDeletePrivateEndpointConnection.get(req)
	if beginDeletePrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeletePrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePrivateEndpointConnection = &respr
		w.beginDeletePrivateEndpointConnection.add(req, beginDeletePrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginDeletePrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeletePrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePrivateEndpointConnection) {
		w.beginDeletePrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginDeletePrivateEndpointConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeletePrivateEndpointConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePrivateEndpointConnectionSlot not implemented")}
	}
	beginDeletePrivateEndpointConnectionSlot := w.beginDeletePrivateEndpointConnectionSlot.get(req)
	if beginDeletePrivateEndpointConnectionSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeletePrivateEndpointConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, slotParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePrivateEndpointConnectionSlot = &respr
		w.beginDeletePrivateEndpointConnectionSlot.add(req, beginDeletePrivateEndpointConnectionSlot)
	}

	resp, err := server.PollerResponderNext(beginDeletePrivateEndpointConnectionSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeletePrivateEndpointConnectionSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePrivateEndpointConnectionSlot) {
		w.beginDeletePrivateEndpointConnectionSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteProcess(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteProcess == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteProcess not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteProcess(req.Context(), resourceGroupNameParam, nameParam, processIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteProcessSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteProcessSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteProcessSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteProcessSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeletePublicCertificate(req *http.Request) (*http.Response, error) {
	if w.srv.DeletePublicCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeletePublicCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates/(?P<publicCertificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	publicCertificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicCertificateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeletePublicCertificate(req.Context(), resourceGroupNameParam, nameParam, publicCertificateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeletePublicCertificateSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeletePublicCertificateSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeletePublicCertificateSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates/(?P<publicCertificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	publicCertificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicCertificateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeletePublicCertificateSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, publicCertificateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteRelayServiceConnection(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteRelayServiceConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteRelayServiceConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection/(?P<entityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	entityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("entityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteRelayServiceConnection(req.Context(), resourceGroupNameParam, nameParam, entityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteRelayServiceConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteRelayServiceConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteRelayServiceConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection/(?P<entityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	entityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("entityName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteRelayServiceConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, entityNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSiteExtension(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSiteExtension == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSiteExtension not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions/(?P<siteExtensionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	siteExtensionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteExtensionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteSiteExtension(req.Context(), resourceGroupNameParam, nameParam, siteExtensionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSiteExtensionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSiteExtensionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSiteExtensionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions/(?P<siteExtensionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	siteExtensionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteExtensionId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteSiteExtensionSlot(req.Context(), resourceGroupNameParam, nameParam, siteExtensionIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	deleteMetricsUnescaped, err := url.QueryUnescape(qp.Get("deleteMetrics"))
	if err != nil {
		return nil, err
	}
	deleteMetricsParam, err := parseOptional(deleteMetricsUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	deleteEmptyServerFarmUnescaped, err := url.QueryUnescape(qp.Get("deleteEmptyServerFarm"))
	if err != nil {
		return nil, err
	}
	deleteEmptyServerFarmParam, err := parseOptional(deleteEmptyServerFarmUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.WebAppsClientDeleteSlotOptions
	if deleteMetricsParam != nil || deleteEmptyServerFarmParam != nil {
		options = &armappservice.WebAppsClientDeleteSlotOptions{
			DeleteMetrics:         deleteMetricsParam,
			DeleteEmptyServerFarm: deleteEmptyServerFarmParam,
		}
	}
	respr, errRespr := w.srv.DeleteSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSourceControl(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSourceControl == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSourceControl not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	additionalFlagsUnescaped, err := url.QueryUnescape(qp.Get("additionalFlags"))
	if err != nil {
		return nil, err
	}
	additionalFlagsParam := getOptional(additionalFlagsUnescaped)
	var options *armappservice.WebAppsClientDeleteSourceControlOptions
	if additionalFlagsParam != nil {
		options = &armappservice.WebAppsClientDeleteSourceControlOptions{
			AdditionalFlags: additionalFlagsParam,
		}
	}
	respr, errRespr := w.srv.DeleteSourceControl(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSourceControlSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSourceControlSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSourceControlSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	additionalFlagsUnescaped, err := url.QueryUnescape(qp.Get("additionalFlags"))
	if err != nil {
		return nil, err
	}
	additionalFlagsParam := getOptional(additionalFlagsUnescaped)
	var options *armappservice.WebAppsClientDeleteSourceControlSlotOptions
	if additionalFlagsParam != nil {
		options = &armappservice.WebAppsClientDeleteSourceControlSlotOptions{
			AdditionalFlags: additionalFlagsParam,
		}
	}
	respr, errRespr := w.srv.DeleteSourceControlSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSwiftVirtualNetwork(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSwiftVirtualNetwork == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSwiftVirtualNetwork not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfig/virtualNetwork`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteSwiftVirtualNetwork(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteSwiftVirtualNetworkSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteSwiftVirtualNetworkSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteSwiftVirtualNetworkSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfig/virtualNetwork`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteSwiftVirtualNetworkSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteTriggeredWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteTriggeredWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteTriggeredWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteTriggeredWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteTriggeredWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteTriggeredWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteTriggeredWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteTriggeredWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteVnetConnection(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteVnetConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteVnetConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteVnetConnection(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeleteVnetConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeleteVnetConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteVnetConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DeleteVnetConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeployWorkflowArtifacts(req *http.Request) (*http.Response, error) {
	if w.srv.DeployWorkflowArtifacts == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeployWorkflowArtifacts not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployWorkflowArtifacts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.WorkflowArtifacts](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	var options *armappservice.WebAppsClientDeployWorkflowArtifactsOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armappservice.WebAppsClientDeployWorkflowArtifactsOptions{
			WorkflowArtifacts: &body,
		}
	}
	respr, errRespr := w.srv.DeployWorkflowArtifacts(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDeployWorkflowArtifactsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DeployWorkflowArtifactsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeployWorkflowArtifactsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployWorkflowArtifacts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.WorkflowArtifacts](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	var options *armappservice.WebAppsClientDeployWorkflowArtifactsSlotOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armappservice.WebAppsClientDeployWorkflowArtifactsSlotOptions{
			WorkflowArtifacts: &body,
		}
	}
	respr, errRespr := w.srv.DeployWorkflowArtifactsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDiscoverBackup(req *http.Request) (*http.Response, error) {
	if w.srv.DiscoverBackup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DiscoverBackup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/discoverbackup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.RestoreRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DiscoverBackup(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RestoreRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchDiscoverBackupSlot(req *http.Request) (*http.Response, error) {
	if w.srv.DiscoverBackupSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method DiscoverBackupSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/discoverbackup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.RestoreRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.DiscoverBackupSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RestoreRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGenerateNewSitePublishingPassword(req *http.Request) (*http.Response, error) {
	if w.srv.GenerateNewSitePublishingPassword == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateNewSitePublishingPassword not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/newpassword`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GenerateNewSitePublishingPassword(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGenerateNewSitePublishingPasswordSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GenerateNewSitePublishingPasswordSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateNewSitePublishingPasswordSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/newpassword`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GenerateNewSitePublishingPasswordSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Site, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAppSettingKeyVaultReference(req *http.Request) (*http.Response, error) {
	if w.srv.GetAppSettingKeyVaultReference == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAppSettingKeyVaultReference not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/appsettings/(?P<appSettingKey>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	appSettingKeyParam, err := url.PathUnescape(matches[regex.SubexpIndex("appSettingKey")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAppSettingKeyVaultReference(req.Context(), resourceGroupNameParam, nameParam, appSettingKeyParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKVReference, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAppSettingKeyVaultReferenceSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetAppSettingKeyVaultReferenceSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAppSettingKeyVaultReferenceSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/appsettings/(?P<appSettingKey>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	appSettingKeyParam, err := url.PathUnescape(matches[regex.SubexpIndex("appSettingKey")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAppSettingKeyVaultReferenceSlot(req.Context(), resourceGroupNameParam, nameParam, appSettingKeyParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKVReference, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewGetAppSettingsKeyVaultReferencesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewGetAppSettingsKeyVaultReferencesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetAppSettingsKeyVaultReferencesPager not implemented")}
	}
	newGetAppSettingsKeyVaultReferencesPager := w.newGetAppSettingsKeyVaultReferencesPager.get(req)
	if newGetAppSettingsKeyVaultReferencesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/appsettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewGetAppSettingsKeyVaultReferencesPager(resourceGroupNameParam, nameParam, nil)
		newGetAppSettingsKeyVaultReferencesPager = &resp
		w.newGetAppSettingsKeyVaultReferencesPager.add(req, newGetAppSettingsKeyVaultReferencesPager)
		server.PagerResponderInjectNextLinks(newGetAppSettingsKeyVaultReferencesPager, req, func(page *armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetAppSettingsKeyVaultReferencesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newGetAppSettingsKeyVaultReferencesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetAppSettingsKeyVaultReferencesPager) {
		w.newGetAppSettingsKeyVaultReferencesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewGetAppSettingsKeyVaultReferencesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewGetAppSettingsKeyVaultReferencesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetAppSettingsKeyVaultReferencesSlotPager not implemented")}
	}
	newGetAppSettingsKeyVaultReferencesSlotPager := w.newGetAppSettingsKeyVaultReferencesSlotPager.get(req)
	if newGetAppSettingsKeyVaultReferencesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/appsettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewGetAppSettingsKeyVaultReferencesSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newGetAppSettingsKeyVaultReferencesSlotPager = &resp
		w.newGetAppSettingsKeyVaultReferencesSlotPager.add(req, newGetAppSettingsKeyVaultReferencesSlotPager)
		server.PagerResponderInjectNextLinks(newGetAppSettingsKeyVaultReferencesSlotPager, req, func(page *armappservice.WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetAppSettingsKeyVaultReferencesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newGetAppSettingsKeyVaultReferencesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetAppSettingsKeyVaultReferencesSlotPager) {
		w.newGetAppSettingsKeyVaultReferencesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAuthSettings(req *http.Request) (*http.Response, error) {
	if w.srv.GetAuthSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAuthSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAuthSettings(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAuthSettingsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetAuthSettingsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAuthSettingsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAuthSettingsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAuthSettingsV2(req *http.Request) (*http.Response, error) {
	if w.srv.GetAuthSettingsV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAuthSettingsV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettingsV2/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAuthSettingsV2(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettingsV2, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAuthSettingsV2Slot(req *http.Request) (*http.Response, error) {
	if w.srv.GetAuthSettingsV2Slot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAuthSettingsV2Slot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettingsV2/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAuthSettingsV2Slot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettingsV2, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAuthSettingsV2WithoutSecrets(req *http.Request) (*http.Response, error) {
	if w.srv.GetAuthSettingsV2WithoutSecrets == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAuthSettingsV2WithoutSecrets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettingsV2`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAuthSettingsV2WithoutSecrets(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettingsV2, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetAuthSettingsV2WithoutSecretsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetAuthSettingsV2WithoutSecretsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAuthSettingsV2WithoutSecretsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettingsV2`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAuthSettingsV2WithoutSecretsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettingsV2, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetBackupConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.GetBackupConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBackupConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/backup/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetBackupConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetBackupConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetBackupConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBackupConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/backup/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetBackupConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetBackupStatus(req *http.Request) (*http.Response, error) {
	if w.srv.GetBackupStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBackupStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetBackupStatus(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetBackupStatusSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetBackupStatusSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBackupStatusSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetBackupStatusSlot(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.GetConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetConfigurationSnapshot(req *http.Request) (*http.Response, error) {
	if w.srv.GetConfigurationSnapshot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetConfigurationSnapshot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web/snapshots/(?P<snapshotId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	snapshotIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("snapshotId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetConfigurationSnapshot(req.Context(), resourceGroupNameParam, nameParam, snapshotIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetConfigurationSnapshotSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetConfigurationSnapshotSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetConfigurationSnapshotSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web/snapshots/(?P<snapshotId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	snapshotIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("snapshotId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetConfigurationSnapshotSlot(req.Context(), resourceGroupNameParam, nameParam, snapshotIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetContainerLogsZip(req *http.Request) (*http.Response, error) {
	if w.srv.GetContainerLogsZip == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetContainerLogsZip not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containerlogs/zip/download`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetContainerLogsZip(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetContainerLogsZipSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetContainerLogsZipSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetContainerLogsZipSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containerlogs/zip/download`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetContainerLogsZipSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetContinuousWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.GetContinuousWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetContinuousWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetContinuousWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ContinuousWebJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetContinuousWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetContinuousWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetContinuousWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetContinuousWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ContinuousWebJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetDeployment(req *http.Request) (*http.Response, error) {
	if w.srv.GetDeployment == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeployment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDeployment(req.Context(), resourceGroupNameParam, nameParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Deployment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetDeploymentSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetDeploymentSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeploymentSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDeploymentSlot(req.Context(), resourceGroupNameParam, nameParam, idParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Deployment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetDiagnosticLogsConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.GetDiagnosticLogsConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDiagnosticLogsConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/logs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDiagnosticLogsConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteLogsConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetDiagnosticLogsConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetDiagnosticLogsConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDiagnosticLogsConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/logs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDiagnosticLogsConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteLogsConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetDomainOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if w.srv.GetDomainOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDomainOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDomainOwnershipIdentifier(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Identifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetDomainOwnershipIdentifierSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetDomainOwnershipIdentifierSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDomainOwnershipIdentifierSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDomainOwnershipIdentifierSlot(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Identifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetFtpAllowed(req *http.Request) (*http.Response, error) {
	if w.srv.GetFtpAllowed == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFtpAllowed not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicPublishingCredentialsPolicies/ftp`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetFtpAllowed(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CsmPublishingCredentialsPoliciesEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetFtpAllowedSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetFtpAllowedSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFtpAllowedSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicPublishingCredentialsPolicies/ftp`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetFtpAllowedSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CsmPublishingCredentialsPoliciesEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetFunction(req *http.Request) (*http.Response, error) {
	if w.srv.GetFunction == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFunction not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetFunction(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FunctionEnvelope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetFunctionsAdminToken(req *http.Request) (*http.Response, error) {
	if w.srv.GetFunctionsAdminToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFunctionsAdminToken not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/admin/token`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetFunctionsAdminToken(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetFunctionsAdminTokenSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetFunctionsAdminTokenSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFunctionsAdminTokenSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/admin/token`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetFunctionsAdminTokenSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetHostNameBinding(req *http.Request) (*http.Response, error) {
	if w.srv.GetHostNameBinding == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHostNameBinding not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings/(?P<hostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	hostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetHostNameBinding(req.Context(), resourceGroupNameParam, nameParam, hostNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostNameBinding, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetHostNameBindingSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetHostNameBindingSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHostNameBindingSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings/(?P<hostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	hostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetHostNameBindingSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, hostNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostNameBinding, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetHybridConnection(req *http.Request) (*http.Response, error) {
	if w.srv.GetHybridConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHybridConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetHybridConnection(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetHybridConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetHybridConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHybridConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetHybridConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceFunctionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceFunctionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceFunctionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceFunctionSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FunctionEnvelope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceInfo(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceInfo(req.Context(), resourceGroupNameParam, nameParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebSiteInstanceStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceInfoSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceInfoSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceInfoSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceInfoSlot(req.Context(), resourceGroupNameParam, nameParam, instanceIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebSiteInstanceStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceMSDeployLog(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceMSDeployLog == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceMSDeployLog not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy/log`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceMSDeployLog(req.Context(), resourceGroupNameParam, nameParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployLog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceMSDeployLogSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceMSDeployLogSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceMSDeployLogSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy/log`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceMSDeployLogSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployLog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceMsDeployStatus(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceMsDeployStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceMsDeployStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceMsDeployStatus(req.Context(), resourceGroupNameParam, nameParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceMsDeployStatusSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceMsDeployStatusSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceMsDeployStatusSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceMsDeployStatusSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceProcess(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceProcess == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceProcess not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceProcess(req.Context(), resourceGroupNameParam, nameParam, processIDParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceProcessDump(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceProcessDump == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceProcessDump not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dump`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceProcessDump(req.Context(), resourceGroupNameParam, nameParam, processIDParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceProcessDumpSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceProcessDumpSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceProcessDumpSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dump`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceProcessDumpSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, slotParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceProcessModule(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceProcessModule == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceProcessModule not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules/(?P<baseAddress>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	baseAddressParam, err := url.PathUnescape(matches[regex.SubexpIndex("baseAddress")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceProcessModule(req.Context(), resourceGroupNameParam, nameParam, processIDParam, baseAddressParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessModuleInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceProcessModuleSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceProcessModuleSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceProcessModuleSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules/(?P<baseAddress>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	baseAddressParam, err := url.PathUnescape(matches[regex.SubexpIndex("baseAddress")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceProcessModuleSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, baseAddressParam, slotParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessModuleInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceProcessSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceProcessSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceProcessSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceProcessSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, slotParam, instanceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetInstanceWorkflowSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetInstanceWorkflowSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceWorkflowSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workflows/(?P<workflowName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	workflowNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workflowName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetInstanceWorkflowSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, workflowNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkflowEnvelope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetMSDeployLog(req *http.Request) (*http.Response, error) {
	if w.srv.GetMSDeployLog == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMSDeployLog not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy/log`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetMSDeployLog(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployLog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetMSDeployLogSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetMSDeployLogSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMSDeployLogSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy/log`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetMSDeployLogSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployLog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetMSDeployStatus(req *http.Request) (*http.Response, error) {
	if w.srv.GetMSDeployStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMSDeployStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetMSDeployStatus(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetMSDeployStatusSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetMSDeployStatusSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMSDeployStatusSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/MSDeploy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetMSDeployStatusSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MSDeployStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetMigrateMySQLStatus(req *http.Request) (*http.Response, error) {
	if w.srv.GetMigrateMySQLStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMigrateMySQLStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migratemysql/status`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetMigrateMySQLStatus(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MigrateMySQLStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetMigrateMySQLStatusSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetMigrateMySQLStatusSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMigrateMySQLStatusSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migratemysql/status`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetMigrateMySQLStatusSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MigrateMySQLStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTraceOperation(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTraceOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTraceOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/operationresults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTraceOperation(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTraceOperationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTraceOperationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTraceOperationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/operationresults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTraceOperationSlot(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTraceOperationSlotV2(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTraceOperationSlotV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTraceOperationSlotV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTraces/current/operationresults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTraceOperationSlotV2(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTraceOperationV2(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTraceOperationV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTraceOperationV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTraces/current/operationresults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTraceOperationV2(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTraces(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTraces == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTraces not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTraces(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTracesSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTracesSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTracesSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTracesSlot(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTracesSlotV2(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTracesSlotV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTracesSlotV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTraces/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTracesSlotV2(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetNetworkTracesV2(req *http.Request) (*http.Response, error) {
	if w.srv.GetNetworkTracesV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkTracesV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTraces/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetNetworkTracesV2(req.Context(), resourceGroupNameParam, nameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkTraceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetOneDeployStatus(req *http.Request) (*http.Response, error) {
	if w.srv.GetOneDeployStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOneDeployStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/onedeploy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetOneDeployStatus(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPremierAddOn(req *http.Request) (*http.Response, error) {
	if w.srv.GetPremierAddOn == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPremierAddOn not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons/(?P<premierAddOnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	premierAddOnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("premierAddOnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPremierAddOn(req.Context(), resourceGroupNameParam, nameParam, premierAddOnNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PremierAddOn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPremierAddOnSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetPremierAddOnSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPremierAddOnSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons/(?P<premierAddOnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	premierAddOnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("premierAddOnName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPremierAddOnSlot(req.Context(), resourceGroupNameParam, nameParam, premierAddOnNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PremierAddOn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPrivateAccess(req *http.Request) (*http.Response, error) {
	if w.srv.GetPrivateAccess == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateAccess not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateAccess/virtualNetworks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPrivateAccess(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateAccess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPrivateAccessSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetPrivateAccessSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateAccessSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateAccess/virtualNetworks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPrivateAccessSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateAccess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if w.srv.GetPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateEndpointConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RemotePrivateEndpointConnectionARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewGetPrivateEndpointConnectionListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewGetPrivateEndpointConnectionListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetPrivateEndpointConnectionListPager not implemented")}
	}
	newGetPrivateEndpointConnectionListPager := w.newGetPrivateEndpointConnectionListPager.get(req)
	if newGetPrivateEndpointConnectionListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewGetPrivateEndpointConnectionListPager(resourceGroupNameParam, nameParam, nil)
		newGetPrivateEndpointConnectionListPager = &resp
		w.newGetPrivateEndpointConnectionListPager.add(req, newGetPrivateEndpointConnectionListPager)
		server.PagerResponderInjectNextLinks(newGetPrivateEndpointConnectionListPager, req, func(page *armappservice.WebAppsClientGetPrivateEndpointConnectionListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetPrivateEndpointConnectionListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newGetPrivateEndpointConnectionListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetPrivateEndpointConnectionListPager) {
		w.newGetPrivateEndpointConnectionListPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewGetPrivateEndpointConnectionListSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewGetPrivateEndpointConnectionListSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetPrivateEndpointConnectionListSlotPager not implemented")}
	}
	newGetPrivateEndpointConnectionListSlotPager := w.newGetPrivateEndpointConnectionListSlotPager.get(req)
	if newGetPrivateEndpointConnectionListSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewGetPrivateEndpointConnectionListSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newGetPrivateEndpointConnectionListSlotPager = &resp
		w.newGetPrivateEndpointConnectionListSlotPager.add(req, newGetPrivateEndpointConnectionListSlotPager)
		server.PagerResponderInjectNextLinks(newGetPrivateEndpointConnectionListSlotPager, req, func(page *armappservice.WebAppsClientGetPrivateEndpointConnectionListSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetPrivateEndpointConnectionListSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newGetPrivateEndpointConnectionListSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetPrivateEndpointConnectionListSlotPager) {
		w.newGetPrivateEndpointConnectionListSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPrivateEndpointConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetPrivateEndpointConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateEndpointConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPrivateEndpointConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RemotePrivateEndpointConnectionARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPrivateLinkResources(req *http.Request) (*http.Response, error) {
	if w.srv.GetPrivateLinkResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateLinkResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPrivateLinkResources(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResourcesWrapper, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPrivateLinkResourcesSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetPrivateLinkResourcesSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateLinkResourcesSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPrivateLinkResourcesSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResourcesWrapper, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetProcess(req *http.Request) (*http.Response, error) {
	if w.srv.GetProcess == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProcess not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetProcess(req.Context(), resourceGroupNameParam, nameParam, processIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetProcessDump(req *http.Request) (*http.Response, error) {
	if w.srv.GetProcessDump == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProcessDump not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dump`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetProcessDump(req.Context(), resourceGroupNameParam, nameParam, processIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetProcessDumpSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetProcessDumpSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProcessDumpSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dump`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetProcessDumpSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetProcessModule(req *http.Request) (*http.Response, error) {
	if w.srv.GetProcessModule == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProcessModule not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules/(?P<baseAddress>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	baseAddressParam, err := url.PathUnescape(matches[regex.SubexpIndex("baseAddress")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetProcessModule(req.Context(), resourceGroupNameParam, nameParam, processIDParam, baseAddressParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessModuleInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetProcessModuleSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetProcessModuleSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProcessModuleSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules/(?P<baseAddress>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	baseAddressParam, err := url.PathUnescape(matches[regex.SubexpIndex("baseAddress")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetProcessModuleSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, baseAddressParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessModuleInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetProcessSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetProcessSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProcessSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetProcessSlot(req.Context(), resourceGroupNameParam, nameParam, processIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProcessInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginGetProductionSiteDeploymentStatus(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetProductionSiteDeploymentStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetProductionSiteDeploymentStatus not implemented")}
	}
	beginGetProductionSiteDeploymentStatus := w.beginGetProductionSiteDeploymentStatus.get(req)
	if beginGetProductionSiteDeploymentStatus == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deploymentStatus/(?P<deploymentStatusId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		deploymentStatusIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStatusId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetProductionSiteDeploymentStatus(req.Context(), resourceGroupNameParam, nameParam, deploymentStatusIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetProductionSiteDeploymentStatus = &respr
		w.beginGetProductionSiteDeploymentStatus.add(req, beginGetProductionSiteDeploymentStatus)
	}

	resp, err := server.PollerResponderNext(beginGetProductionSiteDeploymentStatus, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetProductionSiteDeploymentStatus.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetProductionSiteDeploymentStatus) {
		w.beginGetProductionSiteDeploymentStatus.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPublicCertificate(req *http.Request) (*http.Response, error) {
	if w.srv.GetPublicCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPublicCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates/(?P<publicCertificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	publicCertificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicCertificateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPublicCertificate(req.Context(), resourceGroupNameParam, nameParam, publicCertificateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicCertificate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetPublicCertificateSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetPublicCertificateSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPublicCertificateSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates/(?P<publicCertificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	publicCertificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicCertificateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPublicCertificateSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, publicCertificateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicCertificate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetRelayServiceConnection(req *http.Request) (*http.Response, error) {
	if w.srv.GetRelayServiceConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRelayServiceConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection/(?P<entityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	entityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("entityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetRelayServiceConnection(req.Context(), resourceGroupNameParam, nameParam, entityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RelayServiceConnectionEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetRelayServiceConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetRelayServiceConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRelayServiceConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection/(?P<entityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	entityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("entityName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetRelayServiceConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, entityNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RelayServiceConnectionEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetScmAllowed(req *http.Request) (*http.Response, error) {
	if w.srv.GetScmAllowed == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetScmAllowed not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicPublishingCredentialsPolicies/scm`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetScmAllowed(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CsmPublishingCredentialsPoliciesEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetScmAllowedSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetScmAllowedSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetScmAllowedSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicPublishingCredentialsPolicies/scm`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetScmAllowedSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CsmPublishingCredentialsPoliciesEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSiteConnectionStringKeyVaultReference(req *http.Request) (*http.Response, error) {
	if w.srv.GetSiteConnectionStringKeyVaultReference == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteConnectionStringKeyVaultReference not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/connectionstrings/(?P<connectionStringKey>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	connectionStringKeyParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectionStringKey")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSiteConnectionStringKeyVaultReference(req.Context(), resourceGroupNameParam, nameParam, connectionStringKeyParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKVReference, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSiteConnectionStringKeyVaultReferenceSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetSiteConnectionStringKeyVaultReferenceSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteConnectionStringKeyVaultReferenceSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/connectionstrings/(?P<connectionStringKey>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	connectionStringKeyParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectionStringKey")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSiteConnectionStringKeyVaultReferenceSlot(req.Context(), resourceGroupNameParam, nameParam, connectionStringKeyParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKVReference, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewGetSiteConnectionStringKeyVaultReferencesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewGetSiteConnectionStringKeyVaultReferencesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetSiteConnectionStringKeyVaultReferencesPager not implemented")}
	}
	newGetSiteConnectionStringKeyVaultReferencesPager := w.newGetSiteConnectionStringKeyVaultReferencesPager.get(req)
	if newGetSiteConnectionStringKeyVaultReferencesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/connectionstrings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewGetSiteConnectionStringKeyVaultReferencesPager(resourceGroupNameParam, nameParam, nil)
		newGetSiteConnectionStringKeyVaultReferencesPager = &resp
		w.newGetSiteConnectionStringKeyVaultReferencesPager.add(req, newGetSiteConnectionStringKeyVaultReferencesPager)
		server.PagerResponderInjectNextLinks(newGetSiteConnectionStringKeyVaultReferencesPager, req, func(page *armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetSiteConnectionStringKeyVaultReferencesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newGetSiteConnectionStringKeyVaultReferencesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetSiteConnectionStringKeyVaultReferencesPager) {
		w.newGetSiteConnectionStringKeyVaultReferencesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewGetSiteConnectionStringKeyVaultReferencesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewGetSiteConnectionStringKeyVaultReferencesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetSiteConnectionStringKeyVaultReferencesSlotPager not implemented")}
	}
	newGetSiteConnectionStringKeyVaultReferencesSlotPager := w.newGetSiteConnectionStringKeyVaultReferencesSlotPager.get(req)
	if newGetSiteConnectionStringKeyVaultReferencesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/configreferences/connectionstrings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewGetSiteConnectionStringKeyVaultReferencesSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newGetSiteConnectionStringKeyVaultReferencesSlotPager = &resp
		w.newGetSiteConnectionStringKeyVaultReferencesSlotPager.add(req, newGetSiteConnectionStringKeyVaultReferencesSlotPager)
		server.PagerResponderInjectNextLinks(newGetSiteConnectionStringKeyVaultReferencesSlotPager, req, func(page *armappservice.WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetSiteConnectionStringKeyVaultReferencesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newGetSiteConnectionStringKeyVaultReferencesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetSiteConnectionStringKeyVaultReferencesSlotPager) {
		w.newGetSiteConnectionStringKeyVaultReferencesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSiteExtension(req *http.Request) (*http.Response, error) {
	if w.srv.GetSiteExtension == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteExtension not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions/(?P<siteExtensionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	siteExtensionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteExtensionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSiteExtension(req.Context(), resourceGroupNameParam, nameParam, siteExtensionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteExtensionInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSiteExtensionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetSiteExtensionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteExtensionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions/(?P<siteExtensionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	siteExtensionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteExtensionId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSiteExtensionSlot(req.Context(), resourceGroupNameParam, nameParam, siteExtensionIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteExtensionInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSitePhpErrorLogFlag(req *http.Request) (*http.Response, error) {
	if w.srv.GetSitePhpErrorLogFlag == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSitePhpErrorLogFlag not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/phplogging`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSitePhpErrorLogFlag(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SitePhpErrorLogFlag, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSitePhpErrorLogFlagSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetSitePhpErrorLogFlagSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSitePhpErrorLogFlagSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/phplogging`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSitePhpErrorLogFlagSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SitePhpErrorLogFlag, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Site, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginGetSlotSiteDeploymentStatusSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetSlotSiteDeploymentStatusSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetSlotSiteDeploymentStatusSlot not implemented")}
	}
	beginGetSlotSiteDeploymentStatusSlot := w.beginGetSlotSiteDeploymentStatusSlot.get(req)
	if beginGetSlotSiteDeploymentStatusSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deploymentStatus/(?P<deploymentStatusId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		deploymentStatusIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStatusId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetSlotSiteDeploymentStatusSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, deploymentStatusIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetSlotSiteDeploymentStatusSlot = &respr
		w.beginGetSlotSiteDeploymentStatusSlot.add(req, beginGetSlotSiteDeploymentStatusSlot)
	}

	resp, err := server.PollerResponderNext(beginGetSlotSiteDeploymentStatusSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetSlotSiteDeploymentStatusSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetSlotSiteDeploymentStatusSlot) {
		w.beginGetSlotSiteDeploymentStatusSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSourceControl(req *http.Request) (*http.Response, error) {
	if w.srv.GetSourceControl == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSourceControl not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSourceControl(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteSourceControl, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSourceControlSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetSourceControlSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSourceControlSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSourceControlSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteSourceControl, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSwiftVirtualNetworkConnection(req *http.Request) (*http.Response, error) {
	if w.srv.GetSwiftVirtualNetworkConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSwiftVirtualNetworkConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfig/virtualNetwork`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSwiftVirtualNetworkConnection(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SwiftVirtualNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetSwiftVirtualNetworkConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetSwiftVirtualNetworkConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSwiftVirtualNetworkConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfig/virtualNetwork`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSwiftVirtualNetworkConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SwiftVirtualNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetTriggeredWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.GetTriggeredWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTriggeredWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetTriggeredWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TriggeredWebJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetTriggeredWebJobHistory(req *http.Request) (*http.Response, error) {
	if w.srv.GetTriggeredWebJobHistory == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTriggeredWebJobHistory not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/history/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetTriggeredWebJobHistory(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TriggeredJobHistory, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetTriggeredWebJobHistorySlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetTriggeredWebJobHistorySlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTriggeredWebJobHistorySlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/history/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetTriggeredWebJobHistorySlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, idParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TriggeredJobHistory, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetTriggeredWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetTriggeredWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTriggeredWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetTriggeredWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TriggeredWebJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetVnetConnection(req *http.Request) (*http.Response, error) {
	if w.srv.GetVnetConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVnetConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetVnetConnection(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetVnetConnectionGateway(req *http.Request) (*http.Response, error) {
	if w.srv.GetVnetConnectionGateway == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVnetConnectionGateway not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gateways/(?P<gatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	gatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetVnetConnectionGateway(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, gatewayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetVnetConnectionGatewaySlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetVnetConnectionGatewaySlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVnetConnectionGatewaySlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gateways/(?P<gatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	gatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetVnetConnectionGatewaySlot(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, gatewayNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetVnetConnectionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetVnetConnectionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVnetConnectionSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetVnetConnectionSlot(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.GetWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetWebSiteContainerLogs(req *http.Request) (*http.Response, error) {
	if w.srv.GetWebSiteContainerLogs == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWebSiteContainerLogs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containerlogs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetWebSiteContainerLogs(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetWebSiteContainerLogsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.GetWebSiteContainerLogsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWebSiteContainerLogsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containerlogs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetWebSiteContainerLogsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchGetWorkflow(req *http.Request) (*http.Response, error) {
	if w.srv.GetWorkflow == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWorkflow not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workflows/(?P<workflowName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	workflowNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workflowName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetWorkflow(req.Context(), resourceGroupNameParam, nameParam, workflowNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkflowEnvelope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginInstallSiteExtension(req *http.Request) (*http.Response, error) {
	if w.srv.BeginInstallSiteExtension == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInstallSiteExtension not implemented")}
	}
	beginInstallSiteExtension := w.beginInstallSiteExtension.get(req)
	if beginInstallSiteExtension == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions/(?P<siteExtensionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		siteExtensionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteExtensionId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginInstallSiteExtension(req.Context(), resourceGroupNameParam, nameParam, siteExtensionIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInstallSiteExtension = &respr
		w.beginInstallSiteExtension.add(req, beginInstallSiteExtension)
	}

	resp, err := server.PollerResponderNext(beginInstallSiteExtension, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginInstallSiteExtension.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInstallSiteExtension) {
		w.beginInstallSiteExtension.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginInstallSiteExtensionSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginInstallSiteExtensionSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInstallSiteExtensionSlot not implemented")}
	}
	beginInstallSiteExtensionSlot := w.beginInstallSiteExtensionSlot.get(req)
	if beginInstallSiteExtensionSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions/(?P<siteExtensionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		siteExtensionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteExtensionId")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginInstallSiteExtensionSlot(req.Context(), resourceGroupNameParam, nameParam, siteExtensionIDParam, slotParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInstallSiteExtensionSlot = &respr
		w.beginInstallSiteExtensionSlot.add(req, beginInstallSiteExtensionSlot)
	}

	resp, err := server.PollerResponderNext(beginInstallSiteExtensionSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginInstallSiteExtensionSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInstallSiteExtensionSlot) {
		w.beginInstallSiteExtensionSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchIsCloneable(req *http.Request) (*http.Response, error) {
	if w.srv.IsCloneable == nil {
		return nil, &nonRetriableError{errors.New("fake for method IsCloneable not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscloneable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.IsCloneable(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteCloneability, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchIsCloneableSlot(req *http.Request) (*http.Response, error) {
	if w.srv.IsCloneableSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method IsCloneableSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscloneable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.IsCloneableSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteCloneability, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListPager(nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.WebAppsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListApplicationSettings(req *http.Request) (*http.Response, error) {
	if w.srv.ListApplicationSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListApplicationSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/appsettings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListApplicationSettings(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListApplicationSettingsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListApplicationSettingsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListApplicationSettingsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/appsettings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListApplicationSettingsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListAzureStorageAccounts(req *http.Request) (*http.Response, error) {
	if w.srv.ListAzureStorageAccounts == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAzureStorageAccounts not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/azurestorageaccounts/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListAzureStorageAccounts(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureStoragePropertyDictionaryResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListAzureStorageAccountsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListAzureStorageAccountsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAzureStorageAccountsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/azurestorageaccounts/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListAzureStorageAccountsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureStoragePropertyDictionaryResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListBackupStatusSecrets(req *http.Request) (*http.Response, error) {
	if w.srv.ListBackupStatusSecrets == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListBackupStatusSecrets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.BackupRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListBackupStatusSecrets(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListBackupStatusSecretsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListBackupStatusSecretsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListBackupStatusSecretsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.BackupRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListBackupStatusSecretsSlot(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListBackupsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListBackupsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBackupsPager not implemented")}
	}
	newListBackupsPager := w.newListBackupsPager.get(req)
	if newListBackupsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListBackupsPager(resourceGroupNameParam, nameParam, nil)
		newListBackupsPager = &resp
		w.newListBackupsPager.add(req, newListBackupsPager)
		server.PagerResponderInjectNextLinks(newListBackupsPager, req, func(page *armappservice.WebAppsClientListBackupsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBackupsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListBackupsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBackupsPager) {
		w.newListBackupsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListBackupsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListBackupsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBackupsSlotPager not implemented")}
	}
	newListBackupsSlotPager := w.newListBackupsSlotPager.get(req)
	if newListBackupsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListBackupsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListBackupsSlotPager = &resp
		w.newListBackupsSlotPager.add(req, newListBackupsSlotPager)
		server.PagerResponderInjectNextLinks(newListBackupsSlotPager, req, func(page *armappservice.WebAppsClientListBackupsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBackupsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListBackupsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBackupsSlotPager) {
		w.newListBackupsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListBasicPublishingCredentialsPoliciesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListBasicPublishingCredentialsPoliciesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBasicPublishingCredentialsPoliciesPager not implemented")}
	}
	newListBasicPublishingCredentialsPoliciesPager := w.newListBasicPublishingCredentialsPoliciesPager.get(req)
	if newListBasicPublishingCredentialsPoliciesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicPublishingCredentialsPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListBasicPublishingCredentialsPoliciesPager(resourceGroupNameParam, nameParam, nil)
		newListBasicPublishingCredentialsPoliciesPager = &resp
		w.newListBasicPublishingCredentialsPoliciesPager.add(req, newListBasicPublishingCredentialsPoliciesPager)
		server.PagerResponderInjectNextLinks(newListBasicPublishingCredentialsPoliciesPager, req, func(page *armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBasicPublishingCredentialsPoliciesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListBasicPublishingCredentialsPoliciesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBasicPublishingCredentialsPoliciesPager) {
		w.newListBasicPublishingCredentialsPoliciesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListBasicPublishingCredentialsPoliciesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListBasicPublishingCredentialsPoliciesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBasicPublishingCredentialsPoliciesSlotPager not implemented")}
	}
	newListBasicPublishingCredentialsPoliciesSlotPager := w.newListBasicPublishingCredentialsPoliciesSlotPager.get(req)
	if newListBasicPublishingCredentialsPoliciesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicPublishingCredentialsPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListBasicPublishingCredentialsPoliciesSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListBasicPublishingCredentialsPoliciesSlotPager = &resp
		w.newListBasicPublishingCredentialsPoliciesSlotPager.add(req, newListBasicPublishingCredentialsPoliciesSlotPager)
		server.PagerResponderInjectNextLinks(newListBasicPublishingCredentialsPoliciesSlotPager, req, func(page *armappservice.WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBasicPublishingCredentialsPoliciesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListBasicPublishingCredentialsPoliciesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBasicPublishingCredentialsPoliciesSlotPager) {
		w.newListBasicPublishingCredentialsPoliciesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := w.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		includeSlotsUnescaped, err := url.QueryUnescape(qp.Get("includeSlots"))
		if err != nil {
			return nil, err
		}
		includeSlotsParam, err := parseOptional(includeSlotsUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armappservice.WebAppsClientListByResourceGroupOptions
		if includeSlotsParam != nil {
			options = &armappservice.WebAppsClientListByResourceGroupOptions{
				IncludeSlots: includeSlotsParam,
			}
		}
		resp := w.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		w.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armappservice.WebAppsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		w.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListConfigurationSnapshotInfoPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListConfigurationSnapshotInfoPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConfigurationSnapshotInfoPager not implemented")}
	}
	newListConfigurationSnapshotInfoPager := w.newListConfigurationSnapshotInfoPager.get(req)
	if newListConfigurationSnapshotInfoPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web/snapshots`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListConfigurationSnapshotInfoPager(resourceGroupNameParam, nameParam, nil)
		newListConfigurationSnapshotInfoPager = &resp
		w.newListConfigurationSnapshotInfoPager.add(req, newListConfigurationSnapshotInfoPager)
		server.PagerResponderInjectNextLinks(newListConfigurationSnapshotInfoPager, req, func(page *armappservice.WebAppsClientListConfigurationSnapshotInfoResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConfigurationSnapshotInfoPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListConfigurationSnapshotInfoPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConfigurationSnapshotInfoPager) {
		w.newListConfigurationSnapshotInfoPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListConfigurationSnapshotInfoSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListConfigurationSnapshotInfoSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConfigurationSnapshotInfoSlotPager not implemented")}
	}
	newListConfigurationSnapshotInfoSlotPager := w.newListConfigurationSnapshotInfoSlotPager.get(req)
	if newListConfigurationSnapshotInfoSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web/snapshots`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListConfigurationSnapshotInfoSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListConfigurationSnapshotInfoSlotPager = &resp
		w.newListConfigurationSnapshotInfoSlotPager.add(req, newListConfigurationSnapshotInfoSlotPager)
		server.PagerResponderInjectNextLinks(newListConfigurationSnapshotInfoSlotPager, req, func(page *armappservice.WebAppsClientListConfigurationSnapshotInfoSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConfigurationSnapshotInfoSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListConfigurationSnapshotInfoSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConfigurationSnapshotInfoSlotPager) {
		w.newListConfigurationSnapshotInfoSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListConfigurationsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListConfigurationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConfigurationsPager not implemented")}
	}
	newListConfigurationsPager := w.newListConfigurationsPager.get(req)
	if newListConfigurationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListConfigurationsPager(resourceGroupNameParam, nameParam, nil)
		newListConfigurationsPager = &resp
		w.newListConfigurationsPager.add(req, newListConfigurationsPager)
		server.PagerResponderInjectNextLinks(newListConfigurationsPager, req, func(page *armappservice.WebAppsClientListConfigurationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConfigurationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListConfigurationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConfigurationsPager) {
		w.newListConfigurationsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListConfigurationsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListConfigurationsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConfigurationsSlotPager not implemented")}
	}
	newListConfigurationsSlotPager := w.newListConfigurationsSlotPager.get(req)
	if newListConfigurationsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListConfigurationsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListConfigurationsSlotPager = &resp
		w.newListConfigurationsSlotPager.add(req, newListConfigurationsSlotPager)
		server.PagerResponderInjectNextLinks(newListConfigurationsSlotPager, req, func(page *armappservice.WebAppsClientListConfigurationsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConfigurationsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListConfigurationsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConfigurationsSlotPager) {
		w.newListConfigurationsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListConnectionStrings(req *http.Request) (*http.Response, error) {
	if w.srv.ListConnectionStrings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListConnectionStrings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/connectionstrings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListConnectionStrings(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionStringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListConnectionStringsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListConnectionStringsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListConnectionStringsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/connectionstrings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListConnectionStringsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionStringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListContinuousWebJobsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListContinuousWebJobsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListContinuousWebJobsPager not implemented")}
	}
	newListContinuousWebJobsPager := w.newListContinuousWebJobsPager.get(req)
	if newListContinuousWebJobsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListContinuousWebJobsPager(resourceGroupNameParam, nameParam, nil)
		newListContinuousWebJobsPager = &resp
		w.newListContinuousWebJobsPager.add(req, newListContinuousWebJobsPager)
		server.PagerResponderInjectNextLinks(newListContinuousWebJobsPager, req, func(page *armappservice.WebAppsClientListContinuousWebJobsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListContinuousWebJobsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListContinuousWebJobsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListContinuousWebJobsPager) {
		w.newListContinuousWebJobsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListContinuousWebJobsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListContinuousWebJobsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListContinuousWebJobsSlotPager not implemented")}
	}
	newListContinuousWebJobsSlotPager := w.newListContinuousWebJobsSlotPager.get(req)
	if newListContinuousWebJobsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListContinuousWebJobsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListContinuousWebJobsSlotPager = &resp
		w.newListContinuousWebJobsSlotPager.add(req, newListContinuousWebJobsSlotPager)
		server.PagerResponderInjectNextLinks(newListContinuousWebJobsSlotPager, req, func(page *armappservice.WebAppsClientListContinuousWebJobsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListContinuousWebJobsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListContinuousWebJobsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListContinuousWebJobsSlotPager) {
		w.newListContinuousWebJobsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListDeploymentLog(req *http.Request) (*http.Response, error) {
	if w.srv.ListDeploymentLog == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListDeploymentLog not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/log`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListDeploymentLog(req.Context(), resourceGroupNameParam, nameParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Deployment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListDeploymentLogSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListDeploymentLogSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListDeploymentLogSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/log`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListDeploymentLogSlot(req.Context(), resourceGroupNameParam, nameParam, idParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Deployment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListDeploymentsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDeploymentsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeploymentsPager not implemented")}
	}
	newListDeploymentsPager := w.newListDeploymentsPager.get(req)
	if newListDeploymentsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDeploymentsPager(resourceGroupNameParam, nameParam, nil)
		newListDeploymentsPager = &resp
		w.newListDeploymentsPager.add(req, newListDeploymentsPager)
		server.PagerResponderInjectNextLinks(newListDeploymentsPager, req, func(page *armappservice.WebAppsClientListDeploymentsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeploymentsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDeploymentsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeploymentsPager) {
		w.newListDeploymentsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListDeploymentsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDeploymentsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeploymentsSlotPager not implemented")}
	}
	newListDeploymentsSlotPager := w.newListDeploymentsSlotPager.get(req)
	if newListDeploymentsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDeploymentsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListDeploymentsSlotPager = &resp
		w.newListDeploymentsSlotPager.add(req, newListDeploymentsSlotPager)
		server.PagerResponderInjectNextLinks(newListDeploymentsSlotPager, req, func(page *armappservice.WebAppsClientListDeploymentsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeploymentsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDeploymentsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeploymentsSlotPager) {
		w.newListDeploymentsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListDomainOwnershipIdentifiersPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDomainOwnershipIdentifiersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDomainOwnershipIdentifiersPager not implemented")}
	}
	newListDomainOwnershipIdentifiersPager := w.newListDomainOwnershipIdentifiersPager.get(req)
	if newListDomainOwnershipIdentifiersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDomainOwnershipIdentifiersPager(resourceGroupNameParam, nameParam, nil)
		newListDomainOwnershipIdentifiersPager = &resp
		w.newListDomainOwnershipIdentifiersPager.add(req, newListDomainOwnershipIdentifiersPager)
		server.PagerResponderInjectNextLinks(newListDomainOwnershipIdentifiersPager, req, func(page *armappservice.WebAppsClientListDomainOwnershipIdentifiersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDomainOwnershipIdentifiersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDomainOwnershipIdentifiersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDomainOwnershipIdentifiersPager) {
		w.newListDomainOwnershipIdentifiersPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListDomainOwnershipIdentifiersSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDomainOwnershipIdentifiersSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDomainOwnershipIdentifiersSlotPager not implemented")}
	}
	newListDomainOwnershipIdentifiersSlotPager := w.newListDomainOwnershipIdentifiersSlotPager.get(req)
	if newListDomainOwnershipIdentifiersSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDomainOwnershipIdentifiersSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListDomainOwnershipIdentifiersSlotPager = &resp
		w.newListDomainOwnershipIdentifiersSlotPager.add(req, newListDomainOwnershipIdentifiersSlotPager)
		server.PagerResponderInjectNextLinks(newListDomainOwnershipIdentifiersSlotPager, req, func(page *armappservice.WebAppsClientListDomainOwnershipIdentifiersSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDomainOwnershipIdentifiersSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDomainOwnershipIdentifiersSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDomainOwnershipIdentifiersSlotPager) {
		w.newListDomainOwnershipIdentifiersSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListFunctionKeys(req *http.Request) (*http.Response, error) {
	if w.srv.ListFunctionKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListFunctionKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listkeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListFunctionKeys(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListFunctionKeysSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListFunctionKeysSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListFunctionKeysSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listkeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListFunctionKeysSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListFunctionSecrets(req *http.Request) (*http.Response, error) {
	if w.srv.ListFunctionSecrets == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListFunctionSecrets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listsecrets`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListFunctionSecrets(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FunctionSecrets, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListFunctionSecretsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListFunctionSecretsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListFunctionSecretsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions/(?P<functionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listsecrets`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListFunctionSecretsSlot(req.Context(), resourceGroupNameParam, nameParam, functionNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FunctionSecrets, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListFunctionsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListFunctionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFunctionsPager not implemented")}
	}
	newListFunctionsPager := w.newListFunctionsPager.get(req)
	if newListFunctionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListFunctionsPager(resourceGroupNameParam, nameParam, nil)
		newListFunctionsPager = &resp
		w.newListFunctionsPager.add(req, newListFunctionsPager)
		server.PagerResponderInjectNextLinks(newListFunctionsPager, req, func(page *armappservice.WebAppsClientListFunctionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListFunctionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListFunctionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFunctionsPager) {
		w.newListFunctionsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListHostKeys(req *http.Request) (*http.Response, error) {
	if w.srv.ListHostKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListHostKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/listkeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListHostKeys(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListHostKeysSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListHostKeysSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListHostKeysSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/listkeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListHostKeysSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListHostNameBindingsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListHostNameBindingsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHostNameBindingsPager not implemented")}
	}
	newListHostNameBindingsPager := w.newListHostNameBindingsPager.get(req)
	if newListHostNameBindingsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListHostNameBindingsPager(resourceGroupNameParam, nameParam, nil)
		newListHostNameBindingsPager = &resp
		w.newListHostNameBindingsPager.add(req, newListHostNameBindingsPager)
		server.PagerResponderInjectNextLinks(newListHostNameBindingsPager, req, func(page *armappservice.WebAppsClientListHostNameBindingsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHostNameBindingsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListHostNameBindingsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHostNameBindingsPager) {
		w.newListHostNameBindingsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListHostNameBindingsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListHostNameBindingsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHostNameBindingsSlotPager not implemented")}
	}
	newListHostNameBindingsSlotPager := w.newListHostNameBindingsSlotPager.get(req)
	if newListHostNameBindingsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hostNameBindings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListHostNameBindingsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListHostNameBindingsSlotPager = &resp
		w.newListHostNameBindingsSlotPager.add(req, newListHostNameBindingsSlotPager)
		server.PagerResponderInjectNextLinks(newListHostNameBindingsSlotPager, req, func(page *armappservice.WebAppsClientListHostNameBindingsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHostNameBindingsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListHostNameBindingsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHostNameBindingsSlotPager) {
		w.newListHostNameBindingsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListHybridConnections(req *http.Request) (*http.Response, error) {
	if w.srv.ListHybridConnections == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListHybridConnections not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionRelays`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListHybridConnections(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListHybridConnectionsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListHybridConnectionsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListHybridConnectionsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionRelays`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListHybridConnectionsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceFunctionsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceFunctionsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceFunctionsSlotPager not implemented")}
	}
	newListInstanceFunctionsSlotPager := w.newListInstanceFunctionsSlotPager.get(req)
	if newListInstanceFunctionsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceFunctionsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListInstanceFunctionsSlotPager = &resp
		w.newListInstanceFunctionsSlotPager.add(req, newListInstanceFunctionsSlotPager)
		server.PagerResponderInjectNextLinks(newListInstanceFunctionsSlotPager, req, func(page *armappservice.WebAppsClientListInstanceFunctionsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceFunctionsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceFunctionsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceFunctionsSlotPager) {
		w.newListInstanceFunctionsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceIdentifiersPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceIdentifiersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceIdentifiersPager not implemented")}
	}
	newListInstanceIdentifiersPager := w.newListInstanceIdentifiersPager.get(req)
	if newListInstanceIdentifiersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceIdentifiersPager(resourceGroupNameParam, nameParam, nil)
		newListInstanceIdentifiersPager = &resp
		w.newListInstanceIdentifiersPager.add(req, newListInstanceIdentifiersPager)
		server.PagerResponderInjectNextLinks(newListInstanceIdentifiersPager, req, func(page *armappservice.WebAppsClientListInstanceIdentifiersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceIdentifiersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceIdentifiersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceIdentifiersPager) {
		w.newListInstanceIdentifiersPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceIdentifiersSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceIdentifiersSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceIdentifiersSlotPager not implemented")}
	}
	newListInstanceIdentifiersSlotPager := w.newListInstanceIdentifiersSlotPager.get(req)
	if newListInstanceIdentifiersSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceIdentifiersSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListInstanceIdentifiersSlotPager = &resp
		w.newListInstanceIdentifiersSlotPager.add(req, newListInstanceIdentifiersSlotPager)
		server.PagerResponderInjectNextLinks(newListInstanceIdentifiersSlotPager, req, func(page *armappservice.WebAppsClientListInstanceIdentifiersSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceIdentifiersSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceIdentifiersSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceIdentifiersSlotPager) {
		w.newListInstanceIdentifiersSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceProcessModulesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceProcessModulesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceProcessModulesPager not implemented")}
	}
	newListInstanceProcessModulesPager := w.newListInstanceProcessModulesPager.get(req)
	if newListInstanceProcessModulesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceProcessModulesPager(resourceGroupNameParam, nameParam, processIDParam, instanceIDParam, nil)
		newListInstanceProcessModulesPager = &resp
		w.newListInstanceProcessModulesPager.add(req, newListInstanceProcessModulesPager)
		server.PagerResponderInjectNextLinks(newListInstanceProcessModulesPager, req, func(page *armappservice.WebAppsClientListInstanceProcessModulesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceProcessModulesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceProcessModulesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceProcessModulesPager) {
		w.newListInstanceProcessModulesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceProcessModulesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceProcessModulesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceProcessModulesSlotPager not implemented")}
	}
	newListInstanceProcessModulesSlotPager := w.newListInstanceProcessModulesSlotPager.get(req)
	if newListInstanceProcessModulesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceProcessModulesSlotPager(resourceGroupNameParam, nameParam, processIDParam, slotParam, instanceIDParam, nil)
		newListInstanceProcessModulesSlotPager = &resp
		w.newListInstanceProcessModulesSlotPager.add(req, newListInstanceProcessModulesSlotPager)
		server.PagerResponderInjectNextLinks(newListInstanceProcessModulesSlotPager, req, func(page *armappservice.WebAppsClientListInstanceProcessModulesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceProcessModulesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceProcessModulesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceProcessModulesSlotPager) {
		w.newListInstanceProcessModulesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceProcessThreadsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceProcessThreadsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceProcessThreadsPager not implemented")}
	}
	newListInstanceProcessThreadsPager := w.newListInstanceProcessThreadsPager.get(req)
	if newListInstanceProcessThreadsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/threads`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceProcessThreadsPager(resourceGroupNameParam, nameParam, processIDParam, instanceIDParam, nil)
		newListInstanceProcessThreadsPager = &resp
		w.newListInstanceProcessThreadsPager.add(req, newListInstanceProcessThreadsPager)
		server.PagerResponderInjectNextLinks(newListInstanceProcessThreadsPager, req, func(page *armappservice.WebAppsClientListInstanceProcessThreadsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceProcessThreadsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceProcessThreadsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceProcessThreadsPager) {
		w.newListInstanceProcessThreadsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceProcessThreadsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceProcessThreadsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceProcessThreadsSlotPager not implemented")}
	}
	newListInstanceProcessThreadsSlotPager := w.newListInstanceProcessThreadsSlotPager.get(req)
	if newListInstanceProcessThreadsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/threads`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceProcessThreadsSlotPager(resourceGroupNameParam, nameParam, processIDParam, slotParam, instanceIDParam, nil)
		newListInstanceProcessThreadsSlotPager = &resp
		w.newListInstanceProcessThreadsSlotPager.add(req, newListInstanceProcessThreadsSlotPager)
		server.PagerResponderInjectNextLinks(newListInstanceProcessThreadsSlotPager, req, func(page *armappservice.WebAppsClientListInstanceProcessThreadsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceProcessThreadsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceProcessThreadsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceProcessThreadsSlotPager) {
		w.newListInstanceProcessThreadsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceProcessesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceProcessesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceProcessesPager not implemented")}
	}
	newListInstanceProcessesPager := w.newListInstanceProcessesPager.get(req)
	if newListInstanceProcessesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceProcessesPager(resourceGroupNameParam, nameParam, instanceIDParam, nil)
		newListInstanceProcessesPager = &resp
		w.newListInstanceProcessesPager.add(req, newListInstanceProcessesPager)
		server.PagerResponderInjectNextLinks(newListInstanceProcessesPager, req, func(page *armappservice.WebAppsClientListInstanceProcessesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceProcessesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceProcessesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceProcessesPager) {
		w.newListInstanceProcessesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceProcessesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceProcessesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceProcessesSlotPager not implemented")}
	}
	newListInstanceProcessesSlotPager := w.newListInstanceProcessesSlotPager.get(req)
	if newListInstanceProcessesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instanceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		instanceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("instanceId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceProcessesSlotPager(resourceGroupNameParam, nameParam, slotParam, instanceIDParam, nil)
		newListInstanceProcessesSlotPager = &resp
		w.newListInstanceProcessesSlotPager.add(req, newListInstanceProcessesSlotPager)
		server.PagerResponderInjectNextLinks(newListInstanceProcessesSlotPager, req, func(page *armappservice.WebAppsClientListInstanceProcessesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceProcessesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceProcessesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceProcessesSlotPager) {
		w.newListInstanceProcessesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListInstanceWorkflowsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListInstanceWorkflowsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceWorkflowsSlotPager not implemented")}
	}
	newListInstanceWorkflowsSlotPager := w.newListInstanceWorkflowsSlotPager.get(req)
	if newListInstanceWorkflowsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workflows`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListInstanceWorkflowsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListInstanceWorkflowsSlotPager = &resp
		w.newListInstanceWorkflowsSlotPager.add(req, newListInstanceWorkflowsSlotPager)
		server.PagerResponderInjectNextLinks(newListInstanceWorkflowsSlotPager, req, func(page *armappservice.WebAppsClientListInstanceWorkflowsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceWorkflowsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListInstanceWorkflowsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceWorkflowsSlotPager) {
		w.newListInstanceWorkflowsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListMetadata(req *http.Request) (*http.Response, error) {
	if w.srv.ListMetadata == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListMetadata not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/metadata/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListMetadata(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListMetadataSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListMetadataSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListMetadataSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/metadata/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListMetadataSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListNetworkFeatures(req *http.Request) (*http.Response, error) {
	if w.srv.ListNetworkFeatures == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListNetworkFeatures not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFeatures/(?P<view>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	viewParam, err := url.PathUnescape(matches[regex.SubexpIndex("view")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListNetworkFeatures(req.Context(), resourceGroupNameParam, nameParam, viewParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkFeatures, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListNetworkFeaturesSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListNetworkFeaturesSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListNetworkFeaturesSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFeatures/(?P<view>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	viewParam, err := url.PathUnescape(matches[regex.SubexpIndex("view")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListNetworkFeaturesSlot(req.Context(), resourceGroupNameParam, nameParam, viewParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkFeatures, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListPerfMonCountersPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPerfMonCountersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPerfMonCountersPager not implemented")}
	}
	newListPerfMonCountersPager := w.newListPerfMonCountersPager.get(req)
	if newListPerfMonCountersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/perfcounters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.WebAppsClientListPerfMonCountersOptions
		if filterParam != nil {
			options = &armappservice.WebAppsClientListPerfMonCountersOptions{
				Filter: filterParam,
			}
		}
		resp := w.srv.NewListPerfMonCountersPager(resourceGroupNameParam, nameParam, options)
		newListPerfMonCountersPager = &resp
		w.newListPerfMonCountersPager.add(req, newListPerfMonCountersPager)
		server.PagerResponderInjectNextLinks(newListPerfMonCountersPager, req, func(page *armappservice.WebAppsClientListPerfMonCountersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPerfMonCountersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPerfMonCountersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPerfMonCountersPager) {
		w.newListPerfMonCountersPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListPerfMonCountersSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPerfMonCountersSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPerfMonCountersSlotPager not implemented")}
	}
	newListPerfMonCountersSlotPager := w.newListPerfMonCountersSlotPager.get(req)
	if newListPerfMonCountersSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/perfcounters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.WebAppsClientListPerfMonCountersSlotOptions
		if filterParam != nil {
			options = &armappservice.WebAppsClientListPerfMonCountersSlotOptions{
				Filter: filterParam,
			}
		}
		resp := w.srv.NewListPerfMonCountersSlotPager(resourceGroupNameParam, nameParam, slotParam, options)
		newListPerfMonCountersSlotPager = &resp
		w.newListPerfMonCountersSlotPager.add(req, newListPerfMonCountersSlotPager)
		server.PagerResponderInjectNextLinks(newListPerfMonCountersSlotPager, req, func(page *armappservice.WebAppsClientListPerfMonCountersSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPerfMonCountersSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPerfMonCountersSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPerfMonCountersSlotPager) {
		w.newListPerfMonCountersSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListPremierAddOns(req *http.Request) (*http.Response, error) {
	if w.srv.ListPremierAddOns == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPremierAddOns not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListPremierAddOns(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PremierAddOn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListPremierAddOnsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListPremierAddOnsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPremierAddOnsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/premieraddons`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListPremierAddOnsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PremierAddOn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProcessModulesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProcessModulesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProcessModulesPager not implemented")}
	}
	newListProcessModulesPager := w.newListProcessModulesPager.get(req)
	if newListProcessModulesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProcessModulesPager(resourceGroupNameParam, nameParam, processIDParam, nil)
		newListProcessModulesPager = &resp
		w.newListProcessModulesPager.add(req, newListProcessModulesPager)
		server.PagerResponderInjectNextLinks(newListProcessModulesPager, req, func(page *armappservice.WebAppsClientListProcessModulesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProcessModulesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProcessModulesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProcessModulesPager) {
		w.newListProcessModulesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProcessModulesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProcessModulesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProcessModulesSlotPager not implemented")}
	}
	newListProcessModulesSlotPager := w.newListProcessModulesSlotPager.get(req)
	if newListProcessModulesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProcessModulesSlotPager(resourceGroupNameParam, nameParam, processIDParam, slotParam, nil)
		newListProcessModulesSlotPager = &resp
		w.newListProcessModulesSlotPager.add(req, newListProcessModulesSlotPager)
		server.PagerResponderInjectNextLinks(newListProcessModulesSlotPager, req, func(page *armappservice.WebAppsClientListProcessModulesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProcessModulesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProcessModulesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProcessModulesSlotPager) {
		w.newListProcessModulesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProcessThreadsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProcessThreadsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProcessThreadsPager not implemented")}
	}
	newListProcessThreadsPager := w.newListProcessThreadsPager.get(req)
	if newListProcessThreadsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/threads`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProcessThreadsPager(resourceGroupNameParam, nameParam, processIDParam, nil)
		newListProcessThreadsPager = &resp
		w.newListProcessThreadsPager.add(req, newListProcessThreadsPager)
		server.PagerResponderInjectNextLinks(newListProcessThreadsPager, req, func(page *armappservice.WebAppsClientListProcessThreadsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProcessThreadsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProcessThreadsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProcessThreadsPager) {
		w.newListProcessThreadsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProcessThreadsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProcessThreadsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProcessThreadsSlotPager not implemented")}
	}
	newListProcessThreadsSlotPager := w.newListProcessThreadsSlotPager.get(req)
	if newListProcessThreadsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes/(?P<processId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/threads`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		processIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("processId")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProcessThreadsSlotPager(resourceGroupNameParam, nameParam, processIDParam, slotParam, nil)
		newListProcessThreadsSlotPager = &resp
		w.newListProcessThreadsSlotPager.add(req, newListProcessThreadsSlotPager)
		server.PagerResponderInjectNextLinks(newListProcessThreadsSlotPager, req, func(page *armappservice.WebAppsClientListProcessThreadsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProcessThreadsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProcessThreadsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProcessThreadsSlotPager) {
		w.newListProcessThreadsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProcessesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProcessesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProcessesPager not implemented")}
	}
	newListProcessesPager := w.newListProcessesPager.get(req)
	if newListProcessesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProcessesPager(resourceGroupNameParam, nameParam, nil)
		newListProcessesPager = &resp
		w.newListProcessesPager.add(req, newListProcessesPager)
		server.PagerResponderInjectNextLinks(newListProcessesPager, req, func(page *armappservice.WebAppsClientListProcessesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProcessesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProcessesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProcessesPager) {
		w.newListProcessesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProcessesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProcessesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProcessesSlotPager not implemented")}
	}
	newListProcessesSlotPager := w.newListProcessesSlotPager.get(req)
	if newListProcessesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/processes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProcessesSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListProcessesSlotPager = &resp
		w.newListProcessesSlotPager.add(req, newListProcessesSlotPager)
		server.PagerResponderInjectNextLinks(newListProcessesSlotPager, req, func(page *armappservice.WebAppsClientListProcessesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProcessesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProcessesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProcessesSlotPager) {
		w.newListProcessesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListProductionSiteDeploymentStatusesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListProductionSiteDeploymentStatusesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProductionSiteDeploymentStatusesPager not implemented")}
	}
	newListProductionSiteDeploymentStatusesPager := w.newListProductionSiteDeploymentStatusesPager.get(req)
	if newListProductionSiteDeploymentStatusesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deploymentStatus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListProductionSiteDeploymentStatusesPager(resourceGroupNameParam, nameParam, nil)
		newListProductionSiteDeploymentStatusesPager = &resp
		w.newListProductionSiteDeploymentStatusesPager.add(req, newListProductionSiteDeploymentStatusesPager)
		server.PagerResponderInjectNextLinks(newListProductionSiteDeploymentStatusesPager, req, func(page *armappservice.WebAppsClientListProductionSiteDeploymentStatusesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProductionSiteDeploymentStatusesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListProductionSiteDeploymentStatusesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProductionSiteDeploymentStatusesPager) {
		w.newListProductionSiteDeploymentStatusesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListPublicCertificatesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPublicCertificatesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPublicCertificatesPager not implemented")}
	}
	newListPublicCertificatesPager := w.newListPublicCertificatesPager.get(req)
	if newListPublicCertificatesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPublicCertificatesPager(resourceGroupNameParam, nameParam, nil)
		newListPublicCertificatesPager = &resp
		w.newListPublicCertificatesPager.add(req, newListPublicCertificatesPager)
		server.PagerResponderInjectNextLinks(newListPublicCertificatesPager, req, func(page *armappservice.WebAppsClientListPublicCertificatesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPublicCertificatesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPublicCertificatesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPublicCertificatesPager) {
		w.newListPublicCertificatesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListPublicCertificatesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPublicCertificatesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPublicCertificatesSlotPager not implemented")}
	}
	newListPublicCertificatesSlotPager := w.newListPublicCertificatesSlotPager.get(req)
	if newListPublicCertificatesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicCertificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPublicCertificatesSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListPublicCertificatesSlotPager = &resp
		w.newListPublicCertificatesSlotPager.add(req, newListPublicCertificatesSlotPager)
		server.PagerResponderInjectNextLinks(newListPublicCertificatesSlotPager, req, func(page *armappservice.WebAppsClientListPublicCertificatesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPublicCertificatesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPublicCertificatesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPublicCertificatesSlotPager) {
		w.newListPublicCertificatesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginListPublishingCredentials(req *http.Request) (*http.Response, error) {
	if w.srv.BeginListPublishingCredentials == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListPublishingCredentials not implemented")}
	}
	beginListPublishingCredentials := w.beginListPublishingCredentials.get(req)
	if beginListPublishingCredentials == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/publishingcredentials/list`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginListPublishingCredentials(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListPublishingCredentials = &respr
		w.beginListPublishingCredentials.add(req, beginListPublishingCredentials)
	}

	resp, err := server.PollerResponderNext(beginListPublishingCredentials, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.beginListPublishingCredentials.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListPublishingCredentials) {
		w.beginListPublishingCredentials.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginListPublishingCredentialsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginListPublishingCredentialsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListPublishingCredentialsSlot not implemented")}
	}
	beginListPublishingCredentialsSlot := w.beginListPublishingCredentialsSlot.get(req)
	if beginListPublishingCredentialsSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/publishingcredentials/list`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginListPublishingCredentialsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListPublishingCredentialsSlot = &respr
		w.beginListPublishingCredentialsSlot.add(req, beginListPublishingCredentialsSlot)
	}

	resp, err := server.PollerResponderNext(beginListPublishingCredentialsSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.beginListPublishingCredentialsSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListPublishingCredentialsSlot) {
		w.beginListPublishingCredentialsSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListPublishingProfileXMLWithSecrets(req *http.Request) (*http.Response, error) {
	if w.srv.ListPublishingProfileXMLWithSecrets == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPublishingProfileXMLWithSecrets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publishxml`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CsmPublishingProfileOptions](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListPublishingProfileXMLWithSecrets(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListPublishingProfileXMLWithSecretsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListPublishingProfileXMLWithSecretsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPublishingProfileXMLWithSecretsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publishxml`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CsmPublishingProfileOptions](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListPublishingProfileXMLWithSecretsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListRelayServiceConnections(req *http.Request) (*http.Response, error) {
	if w.srv.ListRelayServiceConnections == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRelayServiceConnections not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListRelayServiceConnections(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RelayServiceConnectionEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListRelayServiceConnectionsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListRelayServiceConnectionsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRelayServiceConnectionsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridconnection`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListRelayServiceConnectionsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RelayServiceConnectionEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSiteBackupsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSiteBackupsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteBackupsPager not implemented")}
	}
	newListSiteBackupsPager := w.newListSiteBackupsPager.get(req)
	if newListSiteBackupsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listbackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSiteBackupsPager(resourceGroupNameParam, nameParam, nil)
		newListSiteBackupsPager = &resp
		w.newListSiteBackupsPager.add(req, newListSiteBackupsPager)
		server.PagerResponderInjectNextLinks(newListSiteBackupsPager, req, func(page *armappservice.WebAppsClientListSiteBackupsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteBackupsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSiteBackupsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteBackupsPager) {
		w.newListSiteBackupsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSiteBackupsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSiteBackupsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteBackupsSlotPager not implemented")}
	}
	newListSiteBackupsSlotPager := w.newListSiteBackupsSlotPager.get(req)
	if newListSiteBackupsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listbackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSiteBackupsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListSiteBackupsSlotPager = &resp
		w.newListSiteBackupsSlotPager.add(req, newListSiteBackupsSlotPager)
		server.PagerResponderInjectNextLinks(newListSiteBackupsSlotPager, req, func(page *armappservice.WebAppsClientListSiteBackupsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteBackupsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSiteBackupsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteBackupsSlotPager) {
		w.newListSiteBackupsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSiteExtensionsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSiteExtensionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteExtensionsPager not implemented")}
	}
	newListSiteExtensionsPager := w.newListSiteExtensionsPager.get(req)
	if newListSiteExtensionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSiteExtensionsPager(resourceGroupNameParam, nameParam, nil)
		newListSiteExtensionsPager = &resp
		w.newListSiteExtensionsPager.add(req, newListSiteExtensionsPager)
		server.PagerResponderInjectNextLinks(newListSiteExtensionsPager, req, func(page *armappservice.WebAppsClientListSiteExtensionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteExtensionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSiteExtensionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteExtensionsPager) {
		w.newListSiteExtensionsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSiteExtensionsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSiteExtensionsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteExtensionsSlotPager not implemented")}
	}
	newListSiteExtensionsSlotPager := w.newListSiteExtensionsSlotPager.get(req)
	if newListSiteExtensionsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/siteextensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSiteExtensionsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListSiteExtensionsSlotPager = &resp
		w.newListSiteExtensionsSlotPager.add(req, newListSiteExtensionsSlotPager)
		server.PagerResponderInjectNextLinks(newListSiteExtensionsSlotPager, req, func(page *armappservice.WebAppsClientListSiteExtensionsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteExtensionsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSiteExtensionsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteExtensionsSlotPager) {
		w.newListSiteExtensionsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSitePushSettings(req *http.Request) (*http.Response, error) {
	if w.srv.ListSitePushSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSitePushSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/pushsettings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSitePushSettings(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PushSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSitePushSettingsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListSitePushSettingsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSitePushSettingsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/pushsettings/list`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSitePushSettingsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PushSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSlotConfigurationNames(req *http.Request) (*http.Response, error) {
	if w.srv.ListSlotConfigurationNames == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSlotConfigurationNames not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/slotConfigNames`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSlotConfigurationNames(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SlotConfigNamesResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSlotDifferencesFromProductionPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSlotDifferencesFromProductionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSlotDifferencesFromProductionPager not implemented")}
	}
	newListSlotDifferencesFromProductionPager := w.newListSlotDifferencesFromProductionPager.get(req)
	if newListSlotDifferencesFromProductionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slotsdiffs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.CsmSlotEntity](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSlotDifferencesFromProductionPager(resourceGroupNameParam, nameParam, body, nil)
		newListSlotDifferencesFromProductionPager = &resp
		w.newListSlotDifferencesFromProductionPager.add(req, newListSlotDifferencesFromProductionPager)
		server.PagerResponderInjectNextLinks(newListSlotDifferencesFromProductionPager, req, func(page *armappservice.WebAppsClientListSlotDifferencesFromProductionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSlotDifferencesFromProductionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSlotDifferencesFromProductionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSlotDifferencesFromProductionPager) {
		w.newListSlotDifferencesFromProductionPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSlotDifferencesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSlotDifferencesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSlotDifferencesSlotPager not implemented")}
	}
	newListSlotDifferencesSlotPager := w.newListSlotDifferencesSlotPager.get(req)
	if newListSlotDifferencesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slotsdiffs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.CsmSlotEntity](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSlotDifferencesSlotPager(resourceGroupNameParam, nameParam, slotParam, body, nil)
		newListSlotDifferencesSlotPager = &resp
		w.newListSlotDifferencesSlotPager.add(req, newListSlotDifferencesSlotPager)
		server.PagerResponderInjectNextLinks(newListSlotDifferencesSlotPager, req, func(page *armappservice.WebAppsClientListSlotDifferencesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSlotDifferencesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSlotDifferencesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSlotDifferencesSlotPager) {
		w.newListSlotDifferencesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSlotSiteDeploymentStatusesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSlotSiteDeploymentStatusesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSlotSiteDeploymentStatusesSlotPager not implemented")}
	}
	newListSlotSiteDeploymentStatusesSlotPager := w.newListSlotSiteDeploymentStatusesSlotPager.get(req)
	if newListSlotSiteDeploymentStatusesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deploymentStatus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSlotSiteDeploymentStatusesSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListSlotSiteDeploymentStatusesSlotPager = &resp
		w.newListSlotSiteDeploymentStatusesSlotPager.add(req, newListSlotSiteDeploymentStatusesSlotPager)
		server.PagerResponderInjectNextLinks(newListSlotSiteDeploymentStatusesSlotPager, req, func(page *armappservice.WebAppsClientListSlotSiteDeploymentStatusesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSlotSiteDeploymentStatusesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSlotSiteDeploymentStatusesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSlotSiteDeploymentStatusesSlotPager) {
		w.newListSlotSiteDeploymentStatusesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSlotsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSlotsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSlotsPager not implemented")}
	}
	newListSlotsPager := w.newListSlotsPager.get(req)
	if newListSlotsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSlotsPager(resourceGroupNameParam, nameParam, nil)
		newListSlotsPager = &resp
		w.newListSlotsPager.add(req, newListSlotsPager)
		server.PagerResponderInjectNextLinks(newListSlotsPager, req, func(page *armappservice.WebAppsClientListSlotsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSlotsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSlotsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSlotsPager) {
		w.newListSlotsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSnapshotsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSnapshotsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSnapshotsPager not implemented")}
	}
	newListSnapshotsPager := w.newListSnapshotsPager.get(req)
	if newListSnapshotsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/snapshots`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSnapshotsPager(resourceGroupNameParam, nameParam, nil)
		newListSnapshotsPager = &resp
		w.newListSnapshotsPager.add(req, newListSnapshotsPager)
		server.PagerResponderInjectNextLinks(newListSnapshotsPager, req, func(page *armappservice.WebAppsClientListSnapshotsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSnapshotsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSnapshotsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSnapshotsPager) {
		w.newListSnapshotsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSnapshotsFromDRSecondaryPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSnapshotsFromDRSecondaryPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSnapshotsFromDRSecondaryPager not implemented")}
	}
	newListSnapshotsFromDRSecondaryPager := w.newListSnapshotsFromDRSecondaryPager.get(req)
	if newListSnapshotsFromDRSecondaryPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/snapshotsdr`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSnapshotsFromDRSecondaryPager(resourceGroupNameParam, nameParam, nil)
		newListSnapshotsFromDRSecondaryPager = &resp
		w.newListSnapshotsFromDRSecondaryPager.add(req, newListSnapshotsFromDRSecondaryPager)
		server.PagerResponderInjectNextLinks(newListSnapshotsFromDRSecondaryPager, req, func(page *armappservice.WebAppsClientListSnapshotsFromDRSecondaryResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSnapshotsFromDRSecondaryPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSnapshotsFromDRSecondaryPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSnapshotsFromDRSecondaryPager) {
		w.newListSnapshotsFromDRSecondaryPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSnapshotsFromDRSecondarySlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSnapshotsFromDRSecondarySlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSnapshotsFromDRSecondarySlotPager not implemented")}
	}
	newListSnapshotsFromDRSecondarySlotPager := w.newListSnapshotsFromDRSecondarySlotPager.get(req)
	if newListSnapshotsFromDRSecondarySlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/snapshotsdr`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSnapshotsFromDRSecondarySlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListSnapshotsFromDRSecondarySlotPager = &resp
		w.newListSnapshotsFromDRSecondarySlotPager.add(req, newListSnapshotsFromDRSecondarySlotPager)
		server.PagerResponderInjectNextLinks(newListSnapshotsFromDRSecondarySlotPager, req, func(page *armappservice.WebAppsClientListSnapshotsFromDRSecondarySlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSnapshotsFromDRSecondarySlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSnapshotsFromDRSecondarySlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSnapshotsFromDRSecondarySlotPager) {
		w.newListSnapshotsFromDRSecondarySlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListSnapshotsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSnapshotsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSnapshotsSlotPager not implemented")}
	}
	newListSnapshotsSlotPager := w.newListSnapshotsSlotPager.get(req)
	if newListSnapshotsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/snapshots`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSnapshotsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListSnapshotsSlotPager = &resp
		w.newListSnapshotsSlotPager.add(req, newListSnapshotsSlotPager)
		server.PagerResponderInjectNextLinks(newListSnapshotsSlotPager, req, func(page *armappservice.WebAppsClientListSnapshotsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSnapshotsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSnapshotsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSnapshotsSlotPager) {
		w.newListSnapshotsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSyncFunctionTriggers(req *http.Request) (*http.Response, error) {
	if w.srv.ListSyncFunctionTriggers == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSyncFunctionTriggers not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listsyncfunctiontriggerstatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSyncFunctionTriggers(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FunctionSecrets, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSyncFunctionTriggersSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListSyncFunctionTriggersSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSyncFunctionTriggersSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listsyncfunctiontriggerstatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSyncFunctionTriggersSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FunctionSecrets, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSyncStatus(req *http.Request) (*http.Response, error) {
	if w.srv.ListSyncStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSyncStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/listsyncstatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSyncStatus(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListSyncStatusSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListSyncStatusSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSyncStatusSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/listsyncstatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListSyncStatusSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListTriggeredWebJobHistoryPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListTriggeredWebJobHistoryPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListTriggeredWebJobHistoryPager not implemented")}
	}
	newListTriggeredWebJobHistoryPager := w.newListTriggeredWebJobHistoryPager.get(req)
	if newListTriggeredWebJobHistoryPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/history`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListTriggeredWebJobHistoryPager(resourceGroupNameParam, nameParam, webJobNameParam, nil)
		newListTriggeredWebJobHistoryPager = &resp
		w.newListTriggeredWebJobHistoryPager.add(req, newListTriggeredWebJobHistoryPager)
		server.PagerResponderInjectNextLinks(newListTriggeredWebJobHistoryPager, req, func(page *armappservice.WebAppsClientListTriggeredWebJobHistoryResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListTriggeredWebJobHistoryPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListTriggeredWebJobHistoryPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListTriggeredWebJobHistoryPager) {
		w.newListTriggeredWebJobHistoryPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListTriggeredWebJobHistorySlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListTriggeredWebJobHistorySlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListTriggeredWebJobHistorySlotPager not implemented")}
	}
	newListTriggeredWebJobHistorySlotPager := w.newListTriggeredWebJobHistorySlotPager.get(req)
	if newListTriggeredWebJobHistorySlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/history`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListTriggeredWebJobHistorySlotPager(resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
		newListTriggeredWebJobHistorySlotPager = &resp
		w.newListTriggeredWebJobHistorySlotPager.add(req, newListTriggeredWebJobHistorySlotPager)
		server.PagerResponderInjectNextLinks(newListTriggeredWebJobHistorySlotPager, req, func(page *armappservice.WebAppsClientListTriggeredWebJobHistorySlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListTriggeredWebJobHistorySlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListTriggeredWebJobHistorySlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListTriggeredWebJobHistorySlotPager) {
		w.newListTriggeredWebJobHistorySlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListTriggeredWebJobsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListTriggeredWebJobsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListTriggeredWebJobsPager not implemented")}
	}
	newListTriggeredWebJobsPager := w.newListTriggeredWebJobsPager.get(req)
	if newListTriggeredWebJobsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListTriggeredWebJobsPager(resourceGroupNameParam, nameParam, nil)
		newListTriggeredWebJobsPager = &resp
		w.newListTriggeredWebJobsPager.add(req, newListTriggeredWebJobsPager)
		server.PagerResponderInjectNextLinks(newListTriggeredWebJobsPager, req, func(page *armappservice.WebAppsClientListTriggeredWebJobsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListTriggeredWebJobsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListTriggeredWebJobsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListTriggeredWebJobsPager) {
		w.newListTriggeredWebJobsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListTriggeredWebJobsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListTriggeredWebJobsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListTriggeredWebJobsSlotPager not implemented")}
	}
	newListTriggeredWebJobsSlotPager := w.newListTriggeredWebJobsSlotPager.get(req)
	if newListTriggeredWebJobsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListTriggeredWebJobsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListTriggeredWebJobsSlotPager = &resp
		w.newListTriggeredWebJobsSlotPager.add(req, newListTriggeredWebJobsSlotPager)
		server.PagerResponderInjectNextLinks(newListTriggeredWebJobsSlotPager, req, func(page *armappservice.WebAppsClientListTriggeredWebJobsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListTriggeredWebJobsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListTriggeredWebJobsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListTriggeredWebJobsSlotPager) {
		w.newListTriggeredWebJobsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListUsagesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagesPager not implemented")}
	}
	newListUsagesPager := w.newListUsagesPager.get(req)
	if newListUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.WebAppsClientListUsagesOptions
		if filterParam != nil {
			options = &armappservice.WebAppsClientListUsagesOptions{
				Filter: filterParam,
			}
		}
		resp := w.srv.NewListUsagesPager(resourceGroupNameParam, nameParam, options)
		newListUsagesPager = &resp
		w.newListUsagesPager.add(req, newListUsagesPager)
		server.PagerResponderInjectNextLinks(newListUsagesPager, req, func(page *armappservice.WebAppsClientListUsagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagesPager) {
		w.newListUsagesPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListUsagesSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListUsagesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagesSlotPager not implemented")}
	}
	newListUsagesSlotPager := w.newListUsagesSlotPager.get(req)
	if newListUsagesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.WebAppsClientListUsagesSlotOptions
		if filterParam != nil {
			options = &armappservice.WebAppsClientListUsagesSlotOptions{
				Filter: filterParam,
			}
		}
		resp := w.srv.NewListUsagesSlotPager(resourceGroupNameParam, nameParam, slotParam, options)
		newListUsagesSlotPager = &resp
		w.newListUsagesSlotPager.add(req, newListUsagesSlotPager)
		server.PagerResponderInjectNextLinks(newListUsagesSlotPager, req, func(page *armappservice.WebAppsClientListUsagesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListUsagesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListUsagesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagesSlotPager) {
		w.newListUsagesSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListVnetConnections(req *http.Request) (*http.Response, error) {
	if w.srv.ListVnetConnections == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListVnetConnections not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListVnetConnections(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResourceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListVnetConnectionsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListVnetConnectionsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListVnetConnectionsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListVnetConnectionsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResourceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListWebJobsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListWebJobsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebJobsPager not implemented")}
	}
	newListWebJobsPager := w.newListWebJobsPager.get(req)
	if newListWebJobsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListWebJobsPager(resourceGroupNameParam, nameParam, nil)
		newListWebJobsPager = &resp
		w.newListWebJobsPager.add(req, newListWebJobsPager)
		server.PagerResponderInjectNextLinks(newListWebJobsPager, req, func(page *armappservice.WebAppsClientListWebJobsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebJobsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListWebJobsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebJobsPager) {
		w.newListWebJobsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListWebJobsSlotPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListWebJobsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebJobsSlotPager not implemented")}
	}
	newListWebJobsSlotPager := w.newListWebJobsSlotPager.get(req)
	if newListWebJobsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListWebJobsSlotPager(resourceGroupNameParam, nameParam, slotParam, nil)
		newListWebJobsSlotPager = &resp
		w.newListWebJobsSlotPager.add(req, newListWebJobsSlotPager)
		server.PagerResponderInjectNextLinks(newListWebJobsSlotPager, req, func(page *armappservice.WebAppsClientListWebJobsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebJobsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListWebJobsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebJobsSlotPager) {
		w.newListWebJobsSlotPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchNewListWorkflowsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListWorkflowsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWorkflowsPager not implemented")}
	}
	newListWorkflowsPager := w.newListWorkflowsPager.get(req)
	if newListWorkflowsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workflows`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListWorkflowsPager(resourceGroupNameParam, nameParam, nil)
		newListWorkflowsPager = &resp
		w.newListWorkflowsPager.add(req, newListWorkflowsPager)
		server.PagerResponderInjectNextLinks(newListWorkflowsPager, req, func(page *armappservice.WebAppsClientListWorkflowsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWorkflowsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListWorkflowsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWorkflowsPager) {
		w.newListWorkflowsPager.remove(req)
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListWorkflowsConnections(req *http.Request) (*http.Response, error) {
	if w.srv.ListWorkflowsConnections == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListWorkflowsConnections not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listWorkflowsConnections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListWorkflowsConnections(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkflowEnvelope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchListWorkflowsConnectionsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ListWorkflowsConnectionsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListWorkflowsConnectionsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listWorkflowsConnections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ListWorkflowsConnectionsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkflowEnvelope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginMigrateMySQL(req *http.Request) (*http.Response, error) {
	if w.srv.BeginMigrateMySQL == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateMySQL not implemented")}
	}
	beginMigrateMySQL := w.beginMigrateMySQL.get(req)
	if beginMigrateMySQL == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migratemysql`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.MigrateMySQLRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginMigrateMySQL(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateMySQL = &respr
		w.beginMigrateMySQL.add(req, beginMigrateMySQL)
	}

	resp, err := server.PollerResponderNext(beginMigrateMySQL, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.beginMigrateMySQL.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateMySQL) {
		w.beginMigrateMySQL.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginMigrateStorage(req *http.Request) (*http.Response, error) {
	if w.srv.BeginMigrateStorage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateStorage not implemented")}
	}
	beginMigrateStorage := w.beginMigrateStorage.get(req)
	if beginMigrateStorage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armappservice.StorageMigrationOptions](req)
		if err != nil {
			return nil, err
		}
		subscriptionNameParam, err := url.QueryUnescape(qp.Get("subscriptionName"))
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginMigrateStorage(req.Context(), subscriptionNameParam, resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateStorage = &respr
		w.beginMigrateStorage.add(req, beginMigrateStorage)
	}

	resp, err := server.PollerResponderNext(beginMigrateStorage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.beginMigrateStorage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateStorage) {
		w.beginMigrateStorage.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchPutPrivateAccessVnet(req *http.Request) (*http.Response, error) {
	if w.srv.PutPrivateAccessVnet == nil {
		return nil, &nonRetriableError{errors.New("fake for method PutPrivateAccessVnet not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateAccess/virtualNetworks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PrivateAccess](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.PutPrivateAccessVnet(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateAccess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchPutPrivateAccessVnetSlot(req *http.Request) (*http.Response, error) {
	if w.srv.PutPrivateAccessVnetSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method PutPrivateAccessVnetSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateAccess/virtualNetworks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PrivateAccess](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.PutPrivateAccessVnetSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateAccess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchRecoverSiteConfigurationSnapshot(req *http.Request) (*http.Response, error) {
	if w.srv.RecoverSiteConfigurationSnapshot == nil {
		return nil, &nonRetriableError{errors.New("fake for method RecoverSiteConfigurationSnapshot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web/snapshots/(?P<snapshotId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recover`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	snapshotIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("snapshotId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.RecoverSiteConfigurationSnapshot(req.Context(), resourceGroupNameParam, nameParam, snapshotIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchRecoverSiteConfigurationSnapshotSlot(req *http.Request) (*http.Response, error) {
	if w.srv.RecoverSiteConfigurationSnapshotSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method RecoverSiteConfigurationSnapshotSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web/snapshots/(?P<snapshotId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recover`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	snapshotIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("snapshotId")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.RecoverSiteConfigurationSnapshotSlot(req.Context(), resourceGroupNameParam, nameParam, snapshotIDParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchResetProductionSlotConfig(req *http.Request) (*http.Response, error) {
	if w.srv.ResetProductionSlotConfig == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetProductionSlotConfig not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetSlotConfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ResetProductionSlotConfig(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchResetSlotConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.ResetSlotConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetSlotConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetSlotConfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ResetSlotConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchRestart(req *http.Request) (*http.Response, error) {
	if w.srv.Restart == nil {
		return nil, &nonRetriableError{errors.New("fake for method Restart not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restart`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	softRestartUnescaped, err := url.QueryUnescape(qp.Get("softRestart"))
	if err != nil {
		return nil, err
	}
	softRestartParam, err := parseOptional(softRestartUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	synchronousUnescaped, err := url.QueryUnescape(qp.Get("synchronous"))
	if err != nil {
		return nil, err
	}
	synchronousParam, err := parseOptional(synchronousUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.WebAppsClientRestartOptions
	if softRestartParam != nil || synchronousParam != nil {
		options = &armappservice.WebAppsClientRestartOptions{
			SoftRestart: softRestartParam,
			Synchronous: synchronousParam,
		}
	}
	respr, errRespr := w.srv.Restart(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchRestartSlot(req *http.Request) (*http.Response, error) {
	if w.srv.RestartSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method RestartSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restart`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	softRestartUnescaped, err := url.QueryUnescape(qp.Get("softRestart"))
	if err != nil {
		return nil, err
	}
	softRestartParam, err := parseOptional(softRestartUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	synchronousUnescaped, err := url.QueryUnescape(qp.Get("synchronous"))
	if err != nil {
		return nil, err
	}
	synchronousParam, err := parseOptional(synchronousUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.WebAppsClientRestartSlotOptions
	if softRestartParam != nil || synchronousParam != nil {
		options = &armappservice.WebAppsClientRestartSlotOptions{
			SoftRestart: softRestartParam,
			Synchronous: synchronousParam,
		}
	}
	respr, errRespr := w.srv.RestartSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestore(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestore not implemented")}
	}
	beginRestore := w.beginRestore.get(req)
	if beginRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.RestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestore(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestore = &respr
		w.beginRestore.add(req, beginRestore)
	}

	resp, err := server.PollerResponderNext(beginRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestore) {
		w.beginRestore.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreFromBackupBlob(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreFromBackupBlob == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreFromBackupBlob not implemented")}
	}
	beginRestoreFromBackupBlob := w.beginRestoreFromBackupBlob.get(req)
	if beginRestoreFromBackupBlob == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreFromBackupBlob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.RestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreFromBackupBlob(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreFromBackupBlob = &respr
		w.beginRestoreFromBackupBlob.add(req, beginRestoreFromBackupBlob)
	}

	resp, err := server.PollerResponderNext(beginRestoreFromBackupBlob, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreFromBackupBlob.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreFromBackupBlob) {
		w.beginRestoreFromBackupBlob.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreFromBackupBlobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreFromBackupBlobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreFromBackupBlobSlot not implemented")}
	}
	beginRestoreFromBackupBlobSlot := w.beginRestoreFromBackupBlobSlot.get(req)
	if beginRestoreFromBackupBlobSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreFromBackupBlob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.RestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreFromBackupBlobSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreFromBackupBlobSlot = &respr
		w.beginRestoreFromBackupBlobSlot.add(req, beginRestoreFromBackupBlobSlot)
	}

	resp, err := server.PollerResponderNext(beginRestoreFromBackupBlobSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreFromBackupBlobSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreFromBackupBlobSlot) {
		w.beginRestoreFromBackupBlobSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreFromDeletedApp(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreFromDeletedApp == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreFromDeletedApp not implemented")}
	}
	beginRestoreFromDeletedApp := w.beginRestoreFromDeletedApp.get(req)
	if beginRestoreFromDeletedApp == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreFromDeletedApp`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.DeletedAppRestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreFromDeletedApp(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreFromDeletedApp = &respr
		w.beginRestoreFromDeletedApp.add(req, beginRestoreFromDeletedApp)
	}

	resp, err := server.PollerResponderNext(beginRestoreFromDeletedApp, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreFromDeletedApp.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreFromDeletedApp) {
		w.beginRestoreFromDeletedApp.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreFromDeletedAppSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreFromDeletedAppSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreFromDeletedAppSlot not implemented")}
	}
	beginRestoreFromDeletedAppSlot := w.beginRestoreFromDeletedAppSlot.get(req)
	if beginRestoreFromDeletedAppSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreFromDeletedApp`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.DeletedAppRestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreFromDeletedAppSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreFromDeletedAppSlot = &respr
		w.beginRestoreFromDeletedAppSlot.add(req, beginRestoreFromDeletedAppSlot)
	}

	resp, err := server.PollerResponderNext(beginRestoreFromDeletedAppSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreFromDeletedAppSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreFromDeletedAppSlot) {
		w.beginRestoreFromDeletedAppSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreSlot not implemented")}
	}
	beginRestoreSlot := w.beginRestoreSlot.get(req)
	if beginRestoreSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.RestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		backupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupId")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreSlot(req.Context(), resourceGroupNameParam, nameParam, backupIDParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreSlot = &respr
		w.beginRestoreSlot.add(req, beginRestoreSlot)
	}

	resp, err := server.PollerResponderNext(beginRestoreSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreSlot) {
		w.beginRestoreSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreSnapshot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreSnapshot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreSnapshot not implemented")}
	}
	beginRestoreSnapshot := w.beginRestoreSnapshot.get(req)
	if beginRestoreSnapshot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreSnapshot`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.SnapshotRestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreSnapshot(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreSnapshot = &respr
		w.beginRestoreSnapshot.add(req, beginRestoreSnapshot)
	}

	resp, err := server.PollerResponderNext(beginRestoreSnapshot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreSnapshot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreSnapshot) {
		w.beginRestoreSnapshot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginRestoreSnapshotSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRestoreSnapshotSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreSnapshotSlot not implemented")}
	}
	beginRestoreSnapshotSlot := w.beginRestoreSnapshotSlot.get(req)
	if beginRestoreSnapshotSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreSnapshot`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.SnapshotRestoreRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRestoreSnapshotSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreSnapshotSlot = &respr
		w.beginRestoreSnapshotSlot.add(req, beginRestoreSnapshotSlot)
	}

	resp, err := server.PollerResponderNext(beginRestoreSnapshotSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRestoreSnapshotSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreSnapshotSlot) {
		w.beginRestoreSnapshotSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchRunTriggeredWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.RunTriggeredWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method RunTriggeredWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/run`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.RunTriggeredWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchRunTriggeredWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.RunTriggeredWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method RunTriggeredWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggeredwebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/run`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.RunTriggeredWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStart(req *http.Request) (*http.Response, error) {
	if w.srv.Start == nil {
		return nil, &nonRetriableError{errors.New("fake for method Start not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Start(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStartContinuousWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.StartContinuousWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method StartContinuousWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StartContinuousWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStartContinuousWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StartContinuousWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StartContinuousWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StartContinuousWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginStartNetworkTrace(req *http.Request) (*http.Response, error) {
	if w.srv.BeginStartNetworkTrace == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartNetworkTrace not implemented")}
	}
	beginStartNetworkTrace := w.beginStartNetworkTrace.get(req)
	if beginStartNetworkTrace == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startNetworkTrace`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		durationInSecondsUnescaped, err := url.QueryUnescape(qp.Get("durationInSeconds"))
		if err != nil {
			return nil, err
		}
		durationInSecondsParam, err := parseOptional(durationInSecondsUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		maxFrameLengthUnescaped, err := url.QueryUnescape(qp.Get("maxFrameLength"))
		if err != nil {
			return nil, err
		}
		maxFrameLengthParam, err := parseOptional(maxFrameLengthUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		sasURLUnescaped, err := url.QueryUnescape(qp.Get("sasUrl"))
		if err != nil {
			return nil, err
		}
		sasURLParam := getOptional(sasURLUnescaped)
		var options *armappservice.WebAppsClientBeginStartNetworkTraceOptions
		if durationInSecondsParam != nil || maxFrameLengthParam != nil || sasURLParam != nil {
			options = &armappservice.WebAppsClientBeginStartNetworkTraceOptions{
				DurationInSeconds: durationInSecondsParam,
				MaxFrameLength:    maxFrameLengthParam,
				SasURL:            sasURLParam,
			}
		}
		respr, errRespr := w.srv.BeginStartNetworkTrace(req.Context(), resourceGroupNameParam, nameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartNetworkTrace = &respr
		w.beginStartNetworkTrace.add(req, beginStartNetworkTrace)
	}

	resp, err := server.PollerResponderNext(beginStartNetworkTrace, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginStartNetworkTrace.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartNetworkTrace) {
		w.beginStartNetworkTrace.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginStartNetworkTraceSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginStartNetworkTraceSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartNetworkTraceSlot not implemented")}
	}
	beginStartNetworkTraceSlot := w.beginStartNetworkTraceSlot.get(req)
	if beginStartNetworkTraceSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startNetworkTrace`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		durationInSecondsUnescaped, err := url.QueryUnescape(qp.Get("durationInSeconds"))
		if err != nil {
			return nil, err
		}
		durationInSecondsParam, err := parseOptional(durationInSecondsUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		maxFrameLengthUnescaped, err := url.QueryUnescape(qp.Get("maxFrameLength"))
		if err != nil {
			return nil, err
		}
		maxFrameLengthParam, err := parseOptional(maxFrameLengthUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		sasURLUnescaped, err := url.QueryUnescape(qp.Get("sasUrl"))
		if err != nil {
			return nil, err
		}
		sasURLParam := getOptional(sasURLUnescaped)
		var options *armappservice.WebAppsClientBeginStartNetworkTraceSlotOptions
		if durationInSecondsParam != nil || maxFrameLengthParam != nil || sasURLParam != nil {
			options = &armappservice.WebAppsClientBeginStartNetworkTraceSlotOptions{
				DurationInSeconds: durationInSecondsParam,
				MaxFrameLength:    maxFrameLengthParam,
				SasURL:            sasURLParam,
			}
		}
		respr, errRespr := w.srv.BeginStartNetworkTraceSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartNetworkTraceSlot = &respr
		w.beginStartNetworkTraceSlot.add(req, beginStartNetworkTraceSlot)
	}

	resp, err := server.PollerResponderNext(beginStartNetworkTraceSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginStartNetworkTraceSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartNetworkTraceSlot) {
		w.beginStartNetworkTraceSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStartSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StartSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StartSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StartSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStartWebSiteNetworkTrace(req *http.Request) (*http.Response, error) {
	if w.srv.StartWebSiteNetworkTrace == nil {
		return nil, &nonRetriableError{errors.New("fake for method StartWebSiteNetworkTrace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/start`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	durationInSecondsUnescaped, err := url.QueryUnescape(qp.Get("durationInSeconds"))
	if err != nil {
		return nil, err
	}
	durationInSecondsParam, err := parseOptional(durationInSecondsUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	maxFrameLengthUnescaped, err := url.QueryUnescape(qp.Get("maxFrameLength"))
	if err != nil {
		return nil, err
	}
	maxFrameLengthParam, err := parseOptional(maxFrameLengthUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	sasURLUnescaped, err := url.QueryUnescape(qp.Get("sasUrl"))
	if err != nil {
		return nil, err
	}
	sasURLParam := getOptional(sasURLUnescaped)
	var options *armappservice.WebAppsClientStartWebSiteNetworkTraceOptions
	if durationInSecondsParam != nil || maxFrameLengthParam != nil || sasURLParam != nil {
		options = &armappservice.WebAppsClientStartWebSiteNetworkTraceOptions{
			DurationInSeconds: durationInSecondsParam,
			MaxFrameLength:    maxFrameLengthParam,
			SasURL:            sasURLParam,
		}
	}
	respr, errRespr := w.srv.StartWebSiteNetworkTrace(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginStartWebSiteNetworkTraceOperation(req *http.Request) (*http.Response, error) {
	if w.srv.BeginStartWebSiteNetworkTraceOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartWebSiteNetworkTraceOperation not implemented")}
	}
	beginStartWebSiteNetworkTraceOperation := w.beginStartWebSiteNetworkTraceOperation.get(req)
	if beginStartWebSiteNetworkTraceOperation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/startOperation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		durationInSecondsUnescaped, err := url.QueryUnescape(qp.Get("durationInSeconds"))
		if err != nil {
			return nil, err
		}
		durationInSecondsParam, err := parseOptional(durationInSecondsUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		maxFrameLengthUnescaped, err := url.QueryUnescape(qp.Get("maxFrameLength"))
		if err != nil {
			return nil, err
		}
		maxFrameLengthParam, err := parseOptional(maxFrameLengthUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		sasURLUnescaped, err := url.QueryUnescape(qp.Get("sasUrl"))
		if err != nil {
			return nil, err
		}
		sasURLParam := getOptional(sasURLUnescaped)
		var options *armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions
		if durationInSecondsParam != nil || maxFrameLengthParam != nil || sasURLParam != nil {
			options = &armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions{
				DurationInSeconds: durationInSecondsParam,
				MaxFrameLength:    maxFrameLengthParam,
				SasURL:            sasURLParam,
			}
		}
		respr, errRespr := w.srv.BeginStartWebSiteNetworkTraceOperation(req.Context(), resourceGroupNameParam, nameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartWebSiteNetworkTraceOperation = &respr
		w.beginStartWebSiteNetworkTraceOperation.add(req, beginStartWebSiteNetworkTraceOperation)
	}

	resp, err := server.PollerResponderNext(beginStartWebSiteNetworkTraceOperation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginStartWebSiteNetworkTraceOperation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartWebSiteNetworkTraceOperation) {
		w.beginStartWebSiteNetworkTraceOperation.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginStartWebSiteNetworkTraceOperationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginStartWebSiteNetworkTraceOperationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartWebSiteNetworkTraceOperationSlot not implemented")}
	}
	beginStartWebSiteNetworkTraceOperationSlot := w.beginStartWebSiteNetworkTraceOperationSlot.get(req)
	if beginStartWebSiteNetworkTraceOperationSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/startOperation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		durationInSecondsUnescaped, err := url.QueryUnescape(qp.Get("durationInSeconds"))
		if err != nil {
			return nil, err
		}
		durationInSecondsParam, err := parseOptional(durationInSecondsUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		maxFrameLengthUnescaped, err := url.QueryUnescape(qp.Get("maxFrameLength"))
		if err != nil {
			return nil, err
		}
		maxFrameLengthParam, err := parseOptional(maxFrameLengthUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		sasURLUnescaped, err := url.QueryUnescape(qp.Get("sasUrl"))
		if err != nil {
			return nil, err
		}
		sasURLParam := getOptional(sasURLUnescaped)
		var options *armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions
		if durationInSecondsParam != nil || maxFrameLengthParam != nil || sasURLParam != nil {
			options = &armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions{
				DurationInSeconds: durationInSecondsParam,
				MaxFrameLength:    maxFrameLengthParam,
				SasURL:            sasURLParam,
			}
		}
		respr, errRespr := w.srv.BeginStartWebSiteNetworkTraceOperationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartWebSiteNetworkTraceOperationSlot = &respr
		w.beginStartWebSiteNetworkTraceOperationSlot.add(req, beginStartWebSiteNetworkTraceOperationSlot)
	}

	resp, err := server.PollerResponderNext(beginStartWebSiteNetworkTraceOperationSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginStartWebSiteNetworkTraceOperationSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartWebSiteNetworkTraceOperationSlot) {
		w.beginStartWebSiteNetworkTraceOperationSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStartWebSiteNetworkTraceSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StartWebSiteNetworkTraceSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StartWebSiteNetworkTraceSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/start`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	durationInSecondsUnescaped, err := url.QueryUnescape(qp.Get("durationInSeconds"))
	if err != nil {
		return nil, err
	}
	durationInSecondsParam, err := parseOptional(durationInSecondsUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	maxFrameLengthUnescaped, err := url.QueryUnescape(qp.Get("maxFrameLength"))
	if err != nil {
		return nil, err
	}
	maxFrameLengthParam, err := parseOptional(maxFrameLengthUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	sasURLUnescaped, err := url.QueryUnescape(qp.Get("sasUrl"))
	if err != nil {
		return nil, err
	}
	sasURLParam := getOptional(sasURLUnescaped)
	var options *armappservice.WebAppsClientStartWebSiteNetworkTraceSlotOptions
	if durationInSecondsParam != nil || maxFrameLengthParam != nil || sasURLParam != nil {
		options = &armappservice.WebAppsClientStartWebSiteNetworkTraceSlotOptions{
			DurationInSeconds: durationInSecondsParam,
			MaxFrameLength:    maxFrameLengthParam,
			SasURL:            sasURLParam,
		}
	}
	respr, errRespr := w.srv.StartWebSiteNetworkTraceSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStop(req *http.Request) (*http.Response, error) {
	if w.srv.Stop == nil {
		return nil, &nonRetriableError{errors.New("fake for method Stop not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Stop(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopContinuousWebJob(req *http.Request) (*http.Response, error) {
	if w.srv.StopContinuousWebJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopContinuousWebJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopContinuousWebJob(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopContinuousWebJobSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StopContinuousWebJobSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopContinuousWebJobSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/continuouswebjobs/(?P<webJobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	webJobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webJobName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopContinuousWebJobSlot(req.Context(), resourceGroupNameParam, nameParam, webJobNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopNetworkTrace(req *http.Request) (*http.Response, error) {
	if w.srv.StopNetworkTrace == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopNetworkTrace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stopNetworkTrace`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopNetworkTrace(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopNetworkTraceSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StopNetworkTraceSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopNetworkTraceSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stopNetworkTrace`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopNetworkTraceSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StopSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopWebSiteNetworkTrace(req *http.Request) (*http.Response, error) {
	if w.srv.StopWebSiteNetworkTrace == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopWebSiteNetworkTrace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopWebSiteNetworkTrace(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchStopWebSiteNetworkTraceSlot(req *http.Request) (*http.Response, error) {
	if w.srv.StopWebSiteNetworkTraceSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method StopWebSiteNetworkTraceSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkTrace/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.StopWebSiteNetworkTraceSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginSwapSlot(req *http.Request) (*http.Response, error) {
	if w.srv.BeginSwapSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSwapSlot not implemented")}
	}
	beginSwapSlot := w.beginSwapSlot.get(req)
	if beginSwapSlot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slotsswap`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.CsmSlotEntity](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginSwapSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSwapSlot = &respr
		w.beginSwapSlot.add(req, beginSwapSlot)
	}

	resp, err := server.PollerResponderNext(beginSwapSlot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginSwapSlot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSwapSlot) {
		w.beginSwapSlot.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchBeginSwapSlotWithProduction(req *http.Request) (*http.Response, error) {
	if w.srv.BeginSwapSlotWithProduction == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSwapSlotWithProduction not implemented")}
	}
	beginSwapSlotWithProduction := w.beginSwapSlotWithProduction.get(req)
	if beginSwapSlotWithProduction == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slotsswap`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.CsmSlotEntity](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginSwapSlotWithProduction(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSwapSlotWithProduction = &respr
		w.beginSwapSlotWithProduction.add(req, beginSwapSlotWithProduction)
	}

	resp, err := server.PollerResponderNext(beginSwapSlotWithProduction, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginSwapSlotWithProduction.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSwapSlotWithProduction) {
		w.beginSwapSlotWithProduction.remove(req)
	}

	return resp, nil
}

func (w *WebAppsServerTransport) dispatchSyncFunctionTriggers(req *http.Request) (*http.Response, error) {
	if w.srv.SyncFunctionTriggers == nil {
		return nil, &nonRetriableError{errors.New("fake for method SyncFunctionTriggers not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncfunctiontriggers`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.SyncFunctionTriggers(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchSyncFunctionTriggersSlot(req *http.Request) (*http.Response, error) {
	if w.srv.SyncFunctionTriggersSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method SyncFunctionTriggersSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncfunctiontriggers`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.SyncFunctionTriggersSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchSyncFunctions(req *http.Request) (*http.Response, error) {
	if w.srv.SyncFunctions == nil {
		return nil, &nonRetriableError{errors.New("fake for method SyncFunctions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/sync`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.SyncFunctions(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchSyncFunctionsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.SyncFunctionsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method SyncFunctionsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/host/default/sync`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.SyncFunctionsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchSyncRepository(req *http.Request) (*http.Response, error) {
	if w.srv.SyncRepository == nil {
		return nil, &nonRetriableError{errors.New("fake for method SyncRepository not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sync`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.SyncRepository(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchSyncRepositorySlot(req *http.Request) (*http.Response, error) {
	if w.srv.SyncRepositorySlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method SyncRepositorySlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sync`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.SyncRepositorySlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SitePatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Update(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Site, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateApplicationSettings(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateApplicationSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateApplicationSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/appsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateApplicationSettings(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateApplicationSettingsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateApplicationSettingsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateApplicationSettingsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/appsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateApplicationSettingsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateAuthSettings(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateAuthSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAuthSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteAuthSettings](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateAuthSettings(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateAuthSettingsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateAuthSettingsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAuthSettingsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteAuthSettings](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateAuthSettingsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateAuthSettingsV2(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateAuthSettingsV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAuthSettingsV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettingsV2`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteAuthSettingsV2](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateAuthSettingsV2(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettingsV2, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateAuthSettingsV2Slot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateAuthSettingsV2Slot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAuthSettingsV2Slot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/authsettingsV2`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteAuthSettingsV2](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateAuthSettingsV2Slot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteAuthSettingsV2, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateAzureStorageAccounts(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateAzureStorageAccounts == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAzureStorageAccounts not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/azurestorageaccounts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.AzureStoragePropertyDictionaryResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateAzureStorageAccounts(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureStoragePropertyDictionaryResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateAzureStorageAccountsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateAzureStorageAccountsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAzureStorageAccountsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/azurestorageaccounts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.AzureStoragePropertyDictionaryResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateAzureStorageAccountsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureStoragePropertyDictionaryResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateBackupConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateBackupConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateBackupConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.BackupRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateBackupConfiguration(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateBackupConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateBackupConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateBackupConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.BackupRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateBackupConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteConfigResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateConfiguration(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateConfigurationSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateConfigurationSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateConfigurationSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/web`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteConfigResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateConfigurationSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateConnectionStrings(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateConnectionStrings == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateConnectionStrings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/connectionstrings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.ConnectionStringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateConnectionStrings(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionStringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateConnectionStringsSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateConnectionStringsSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateConnectionStringsSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/connectionstrings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.ConnectionStringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateConnectionStringsSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionStringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateDiagnosticLogsConfig(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateDiagnosticLogsConfig == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateDiagnosticLogsConfig not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/logs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteLogsConfig](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateDiagnosticLogsConfig(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteLogsConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateDiagnosticLogsConfigSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateDiagnosticLogsConfigSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateDiagnosticLogsConfigSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/logs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteLogsConfig](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateDiagnosticLogsConfigSlot(req.Context(), resourceGroupNameParam, nameParam, slotParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteLogsConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateDomainOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateDomainOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateDomainOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.Identifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateDomainOwnershipIdentifier(req.Context(), resourceGroupNameParam, nameParam, domainOwnershipIdentifierNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Identifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebAppsServerTransport) dispatchUpdateDomainOwnershipIdentifierSlot(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateDomainOwnershipIdentifierSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateDomainOwnershipIdentifierSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<domainOwnershipIdentifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.Identifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainOwnershipIdentifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainOwnershipIdentifierName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnes