/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */


#pragma once

#include <string>

#include "eckit/geo/grid/Regular.h"
#include "eckit/geo/range/GaussianLatitude.h"
#include "eckit/geo/range/Regular.h"


namespace eckit::geo::grid::regular {


class RegularGaussian final : public Regular {
public:

    // -- Constructors

    explicit RegularGaussian(const Spec&);
    explicit RegularGaussian(size_t N, BoundingBox = {});

    // -- Methods

    size_t N() const { return N_; }

    // -- Overridden methods

    const std::string& type() const override;

    [[nodiscard]] Point first_point() const override;
    [[nodiscard]] Point last_point() const override;


    [[nodiscard]] BoundingBox* calculate_bbox() const override;

    [[nodiscard]] Grid* make_grid_cropped(const Area&) const override;

    double dx() const override { return x_.increment(); }
    double dy() const override { return y_.increment(); }

    size_t nx() const override { return x_.size(); }
    size_t ny() const override { return y_.size(); }

    const Range& x() const override { return x_; }
    const Range& y() const override { return y_; }

    // -- Class members

    [[nodiscard]] static Spec* spec(const std::string& name);

private:

    // -- Members

    const size_t N_;
    const range::RegularLongitude x_;
    const range::GaussianLatitude y_;

    // -- Overridden methods

    void fill_spec(spec::Custom&) const override;
};


}  // namespace eckit::geo::grid::regular
