// ****************************************************************************
//
//          Aevol - An in silico experimental evolution platform
//
// ****************************************************************************
//
// Copyright: See the AUTHORS file provided with the package or <www.aevol.fr>
// Web: http://www.aevol.fr/
// E-mail: See <http://www.aevol.fr/contact/>
// Original Authors : Guillaume Beslon, Carole Knibbe, David Parsons
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ****************************************************************************

#ifndef AEVOL_CHECKPOINTDATA_H_
#define AEVOL_CHECKPOINTDATA_H_

#include <memory>
#include <optional>

#include "ae_types.h"
#include "ExpSetup.h"
#include "Grid.h"
#include "indiv_idxs_map.h"
#include "PhenotypicTarget.h"

namespace aevol {

/// Holds data read from a Checkpoint
struct CheckpointData {
  time_type time;
  fasta_structured_population_t population;
  Grid grid;
  std::unique_ptr<PhenotypicTarget> phenotypic_target;
  std::unique_ptr<ExpSetup> exp_setup;
  time_type checkpoint_freq;
  std::optional<time_type> tree_output_freq;
  std::optional<time_type> best_indiv_stats_output_freq;
  std::optional<time_type> whole_pop_stats_output_freq;
};

}  // namespace aevol

#endif  // AEVOL_CHECKPOINTDATA_H_
